/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workmail.WorkMailAsyncClient;
import software.amazon.awssdk.services.workmail.internal.UserAgentUtils;
import software.amazon.awssdk.services.workmail.model.ListGroupMembersRequest;
import software.amazon.awssdk.services.workmail.model.ListGroupMembersResponse;

public class ListGroupMembersPublisher
implements SdkPublisher<ListGroupMembersResponse> {
    private final WorkMailAsyncClient client;
    private final ListGroupMembersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListGroupMembersPublisher(WorkMailAsyncClient client, ListGroupMembersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListGroupMembersPublisher(WorkMailAsyncClient client, ListGroupMembersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListGroupMembersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListGroupMembersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListGroupMembersResponseFetcher
    implements AsyncPageFetcher<ListGroupMembersResponse> {
        private ListGroupMembersResponseFetcher() {
        }

        public boolean hasNextPage(ListGroupMembersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListGroupMembersResponse> nextPage(ListGroupMembersResponse previousPage) {
            if (previousPage == null) {
                return ListGroupMembersPublisher.this.client.listGroupMembers(ListGroupMembersPublisher.this.firstRequest);
            }
            return ListGroupMembersPublisher.this.client.listGroupMembers((ListGroupMembersRequest)((Object)ListGroupMembersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

