/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.workmail.model.AssociateDelegateToResourceRequest;
import software.amazon.awssdk.services.workmail.model.AssociateDelegateToResourceResponse;
import software.amazon.awssdk.services.workmail.model.AssociateMemberToGroupRequest;
import software.amazon.awssdk.services.workmail.model.AssociateMemberToGroupResponse;
import software.amazon.awssdk.services.workmail.model.CreateAliasRequest;
import software.amazon.awssdk.services.workmail.model.CreateAliasResponse;
import software.amazon.awssdk.services.workmail.model.CreateGroupRequest;
import software.amazon.awssdk.services.workmail.model.CreateGroupResponse;
import software.amazon.awssdk.services.workmail.model.CreateResourceRequest;
import software.amazon.awssdk.services.workmail.model.CreateResourceResponse;
import software.amazon.awssdk.services.workmail.model.CreateUserRequest;
import software.amazon.awssdk.services.workmail.model.CreateUserResponse;
import software.amazon.awssdk.services.workmail.model.DeleteAccessControlRuleRequest;
import software.amazon.awssdk.services.workmail.model.DeleteAccessControlRuleResponse;
import software.amazon.awssdk.services.workmail.model.DeleteAliasRequest;
import software.amazon.awssdk.services.workmail.model.DeleteAliasResponse;
import software.amazon.awssdk.services.workmail.model.DeleteGroupRequest;
import software.amazon.awssdk.services.workmail.model.DeleteGroupResponse;
import software.amazon.awssdk.services.workmail.model.DeleteMailboxPermissionsRequest;
import software.amazon.awssdk.services.workmail.model.DeleteMailboxPermissionsResponse;
import software.amazon.awssdk.services.workmail.model.DeleteResourceRequest;
import software.amazon.awssdk.services.workmail.model.DeleteResourceResponse;
import software.amazon.awssdk.services.workmail.model.DeleteRetentionPolicyRequest;
import software.amazon.awssdk.services.workmail.model.DeleteRetentionPolicyResponse;
import software.amazon.awssdk.services.workmail.model.DeleteUserRequest;
import software.amazon.awssdk.services.workmail.model.DeleteUserResponse;
import software.amazon.awssdk.services.workmail.model.DeregisterFromWorkMailRequest;
import software.amazon.awssdk.services.workmail.model.DeregisterFromWorkMailResponse;
import software.amazon.awssdk.services.workmail.model.DescribeGroupRequest;
import software.amazon.awssdk.services.workmail.model.DescribeGroupResponse;
import software.amazon.awssdk.services.workmail.model.DescribeOrganizationRequest;
import software.amazon.awssdk.services.workmail.model.DescribeOrganizationResponse;
import software.amazon.awssdk.services.workmail.model.DescribeResourceRequest;
import software.amazon.awssdk.services.workmail.model.DescribeResourceResponse;
import software.amazon.awssdk.services.workmail.model.DescribeUserRequest;
import software.amazon.awssdk.services.workmail.model.DescribeUserResponse;
import software.amazon.awssdk.services.workmail.model.DirectoryServiceAuthenticationFailedException;
import software.amazon.awssdk.services.workmail.model.DirectoryUnavailableException;
import software.amazon.awssdk.services.workmail.model.DisassociateDelegateFromResourceRequest;
import software.amazon.awssdk.services.workmail.model.DisassociateDelegateFromResourceResponse;
import software.amazon.awssdk.services.workmail.model.DisassociateMemberFromGroupRequest;
import software.amazon.awssdk.services.workmail.model.DisassociateMemberFromGroupResponse;
import software.amazon.awssdk.services.workmail.model.EmailAddressInUseException;
import software.amazon.awssdk.services.workmail.model.EntityAlreadyRegisteredException;
import software.amazon.awssdk.services.workmail.model.EntityNotFoundException;
import software.amazon.awssdk.services.workmail.model.EntityStateException;
import software.amazon.awssdk.services.workmail.model.GetAccessControlEffectRequest;
import software.amazon.awssdk.services.workmail.model.GetAccessControlEffectResponse;
import software.amazon.awssdk.services.workmail.model.GetDefaultRetentionPolicyRequest;
import software.amazon.awssdk.services.workmail.model.GetDefaultRetentionPolicyResponse;
import software.amazon.awssdk.services.workmail.model.GetMailboxDetailsRequest;
import software.amazon.awssdk.services.workmail.model.GetMailboxDetailsResponse;
import software.amazon.awssdk.services.workmail.model.InvalidConfigurationException;
import software.amazon.awssdk.services.workmail.model.InvalidParameterException;
import software.amazon.awssdk.services.workmail.model.InvalidPasswordException;
import software.amazon.awssdk.services.workmail.model.LimitExceededException;
import software.amazon.awssdk.services.workmail.model.ListAccessControlRulesRequest;
import software.amazon.awssdk.services.workmail.model.ListAccessControlRulesResponse;
import software.amazon.awssdk.services.workmail.model.ListAliasesRequest;
import software.amazon.awssdk.services.workmail.model.ListAliasesResponse;
import software.amazon.awssdk.services.workmail.model.ListGroupMembersRequest;
import software.amazon.awssdk.services.workmail.model.ListGroupMembersResponse;
import software.amazon.awssdk.services.workmail.model.ListGroupsRequest;
import software.amazon.awssdk.services.workmail.model.ListGroupsResponse;
import software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsRequest;
import software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsResponse;
import software.amazon.awssdk.services.workmail.model.ListOrganizationsRequest;
import software.amazon.awssdk.services.workmail.model.ListOrganizationsResponse;
import software.amazon.awssdk.services.workmail.model.ListResourceDelegatesRequest;
import software.amazon.awssdk.services.workmail.model.ListResourceDelegatesResponse;
import software.amazon.awssdk.services.workmail.model.ListResourcesRequest;
import software.amazon.awssdk.services.workmail.model.ListResourcesResponse;
import software.amazon.awssdk.services.workmail.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.workmail.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.workmail.model.ListUsersRequest;
import software.amazon.awssdk.services.workmail.model.ListUsersResponse;
import software.amazon.awssdk.services.workmail.model.MailDomainNotFoundException;
import software.amazon.awssdk.services.workmail.model.MailDomainStateException;
import software.amazon.awssdk.services.workmail.model.NameAvailabilityException;
import software.amazon.awssdk.services.workmail.model.OrganizationNotFoundException;
import software.amazon.awssdk.services.workmail.model.OrganizationStateException;
import software.amazon.awssdk.services.workmail.model.PutAccessControlRuleRequest;
import software.amazon.awssdk.services.workmail.model.PutAccessControlRuleResponse;
import software.amazon.awssdk.services.workmail.model.PutMailboxPermissionsRequest;
import software.amazon.awssdk.services.workmail.model.PutMailboxPermissionsResponse;
import software.amazon.awssdk.services.workmail.model.PutRetentionPolicyRequest;
import software.amazon.awssdk.services.workmail.model.PutRetentionPolicyResponse;
import software.amazon.awssdk.services.workmail.model.RegisterToWorkMailRequest;
import software.amazon.awssdk.services.workmail.model.RegisterToWorkMailResponse;
import software.amazon.awssdk.services.workmail.model.ReservedNameException;
import software.amazon.awssdk.services.workmail.model.ResetPasswordRequest;
import software.amazon.awssdk.services.workmail.model.ResetPasswordResponse;
import software.amazon.awssdk.services.workmail.model.ResourceNotFoundException;
import software.amazon.awssdk.services.workmail.model.TagResourceRequest;
import software.amazon.awssdk.services.workmail.model.TagResourceResponse;
import software.amazon.awssdk.services.workmail.model.TooManyTagsException;
import software.amazon.awssdk.services.workmail.model.UnsupportedOperationException;
import software.amazon.awssdk.services.workmail.model.UntagResourceRequest;
import software.amazon.awssdk.services.workmail.model.UntagResourceResponse;
import software.amazon.awssdk.services.workmail.model.UpdateMailboxQuotaRequest;
import software.amazon.awssdk.services.workmail.model.UpdateMailboxQuotaResponse;
import software.amazon.awssdk.services.workmail.model.UpdatePrimaryEmailAddressRequest;
import software.amazon.awssdk.services.workmail.model.UpdatePrimaryEmailAddressResponse;
import software.amazon.awssdk.services.workmail.model.UpdateResourceRequest;
import software.amazon.awssdk.services.workmail.model.UpdateResourceResponse;
import software.amazon.awssdk.services.workmail.model.WorkMailException;
import software.amazon.awssdk.services.workmail.model.WorkMailRequest;
import software.amazon.awssdk.services.workmail.paginators.ListAliasesIterable;
import software.amazon.awssdk.services.workmail.paginators.ListGroupMembersIterable;
import software.amazon.awssdk.services.workmail.paginators.ListGroupsIterable;
import software.amazon.awssdk.services.workmail.paginators.ListMailboxPermissionsIterable;
import software.amazon.awssdk.services.workmail.paginators.ListOrganizationsIterable;
import software.amazon.awssdk.services.workmail.paginators.ListResourceDelegatesIterable;
import software.amazon.awssdk.services.workmail.paginators.ListResourcesIterable;
import software.amazon.awssdk.services.workmail.paginators.ListUsersIterable;
import software.amazon.awssdk.services.workmail.transform.AssociateDelegateToResourceRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.AssociateMemberToGroupRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.CreateAliasRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.CreateGroupRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.CreateResourceRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.CreateUserRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteAccessControlRuleRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteAliasRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteGroupRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteMailboxPermissionsRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteResourceRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteRetentionPolicyRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeregisterFromWorkMailRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DescribeGroupRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DescribeOrganizationRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DescribeResourceRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DescribeUserRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DisassociateDelegateFromResourceRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DisassociateMemberFromGroupRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.GetAccessControlEffectRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.GetDefaultRetentionPolicyRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.GetMailboxDetailsRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListAccessControlRulesRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListAliasesRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListGroupMembersRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListGroupsRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListMailboxPermissionsRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListOrganizationsRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListResourceDelegatesRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListResourcesRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListUsersRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.PutAccessControlRuleRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.PutMailboxPermissionsRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.PutRetentionPolicyRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.RegisterToWorkMailRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ResetPasswordRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.UpdateMailboxQuotaRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.UpdatePrimaryEmailAddressRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.UpdateResourceRequestMarshaller;

/**
 * Internal implementation of {@link WorkMailClient}.
 *
 * @see WorkMailClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultWorkMailClient implements WorkMailClient {
    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultWorkMailClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Adds a member (user or group) to the resource's set of delegates.
     * </p>
     *
     * @param associateDelegateToResourceRequest
     * @return Result of the AssociateDelegateToResource operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.AssociateDelegateToResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/AssociateDelegateToResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateDelegateToResourceResponse associateDelegateToResource(
            AssociateDelegateToResourceRequest associateDelegateToResourceRequest) throws EntityNotFoundException,
            EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException,
            AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateDelegateToResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateDelegateToResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<AssociateDelegateToResourceRequest, AssociateDelegateToResourceResponse>()
                        .withOperationName("AssociateDelegateToResource").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(associateDelegateToResourceRequest)
                        .withMarshaller(new AssociateDelegateToResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Adds a member (user or group) to the group's set.
     * </p>
     *
     * @param associateMemberToGroupRequest
     * @return Result of the AssociateMemberToGroup operation returned by the service.
     * @throws DirectoryServiceAuthenticationFailedException
     *         The directory service doesn't recognize the credentials supplied by WorkMail.
     * @throws DirectoryUnavailableException
     *         The directory on which you are trying to perform operations isn't available.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws UnsupportedOperationException
     *         You can't perform a write operation against a read-only directory.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.AssociateMemberToGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/AssociateMemberToGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateMemberToGroupResponse associateMemberToGroup(AssociateMemberToGroupRequest associateMemberToGroupRequest)
            throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, EntityNotFoundException,
            EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException,
            UnsupportedOperationException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateMemberToGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateMemberToGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<AssociateMemberToGroupRequest, AssociateMemberToGroupResponse>()
                .withOperationName("AssociateMemberToGroup").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(associateMemberToGroupRequest)
                .withMarshaller(new AssociateMemberToGroupRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Adds an alias to the set of a given member (user or group) of Amazon WorkMail.
     * </p>
     *
     * @param createAliasRequest
     * @return Result of the CreateAlias operation returned by the service.
     * @throws EmailAddressInUseException
     *         The email address that you're trying to assign is already created for a different user, group, or
     *         resource.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws MailDomainNotFoundException
     *         For an email or alias to be created in Amazon WorkMail, the included domain must be defined in the
     *         organization.
     * @throws MailDomainStateException
     *         After a domain has been added to the organization, it must be verified. The domain is not yet verified.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws LimitExceededException
     *         The request exceeds the limit of the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.CreateAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateAliasResponse createAlias(CreateAliasRequest createAliasRequest) throws EmailAddressInUseException,
            EntityNotFoundException, EntityStateException, InvalidParameterException, MailDomainNotFoundException,
            MailDomainStateException, OrganizationNotFoundException, OrganizationStateException, LimitExceededException,
            AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateAliasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateAliasRequest, CreateAliasResponse>()
                .withOperationName("CreateAlias").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createAliasRequest)
                .withMarshaller(new CreateAliasRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a group that can be used in Amazon WorkMail by calling the <a>RegisterToWorkMail</a> operation.
     * </p>
     *
     * @param createGroupRequest
     * @return Result of the CreateGroup operation returned by the service.
     * @throws DirectoryServiceAuthenticationFailedException
     *         The directory service doesn't recognize the credentials supplied by WorkMail.
     * @throws DirectoryUnavailableException
     *         The directory on which you are trying to perform operations isn't available.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws NameAvailabilityException
     *         The user, group, or resource name isn't unique in Amazon WorkMail.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws ReservedNameException
     *         This user, group, or resource name is not allowed in Amazon WorkMail.
     * @throws UnsupportedOperationException
     *         You can't perform a write operation against a read-only directory.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.CreateGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateGroupResponse createGroup(CreateGroupRequest createGroupRequest)
            throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, InvalidParameterException,
            NameAvailabilityException, OrganizationNotFoundException, OrganizationStateException, ReservedNameException,
            UnsupportedOperationException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateGroupRequest, CreateGroupResponse>()
                .withOperationName("CreateGroup").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createGroupRequest)
                .withMarshaller(new CreateGroupRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a new Amazon WorkMail resource.
     * </p>
     *
     * @param createResourceRequest
     * @return Result of the CreateResource operation returned by the service.
     * @throws DirectoryServiceAuthenticationFailedException
     *         The directory service doesn't recognize the credentials supplied by WorkMail.
     * @throws DirectoryUnavailableException
     *         The directory on which you are trying to perform operations isn't available.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws NameAvailabilityException
     *         The user, group, or resource name isn't unique in Amazon WorkMail.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws ReservedNameException
     *         This user, group, or resource name is not allowed in Amazon WorkMail.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.CreateResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateResourceResponse createResource(CreateResourceRequest createResourceRequest)
            throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, InvalidParameterException,
            NameAvailabilityException, OrganizationNotFoundException, OrganizationStateException, ReservedNameException,
            AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateResourceRequest, CreateResourceResponse>()
                .withOperationName("CreateResource").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createResourceRequest)
                .withMarshaller(new CreateResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a user who can be used in Amazon WorkMail by calling the <a>RegisterToWorkMail</a> operation.
     * </p>
     *
     * @param createUserRequest
     * @return Result of the CreateUser operation returned by the service.
     * @throws DirectoryServiceAuthenticationFailedException
     *         The directory service doesn't recognize the credentials supplied by WorkMail.
     * @throws DirectoryUnavailableException
     *         The directory on which you are trying to perform operations isn't available.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws InvalidPasswordException
     *         The supplied password doesn't match the minimum security constraints, such as length or use of special
     *         characters.
     * @throws NameAvailabilityException
     *         The user, group, or resource name isn't unique in Amazon WorkMail.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws ReservedNameException
     *         This user, group, or resource name is not allowed in Amazon WorkMail.
     * @throws UnsupportedOperationException
     *         You can't perform a write operation against a read-only directory.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.CreateUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateUserResponse createUser(CreateUserRequest createUserRequest)
            throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, InvalidParameterException,
            InvalidPasswordException, NameAvailabilityException, OrganizationNotFoundException, OrganizationStateException,
            ReservedNameException, UnsupportedOperationException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateUserRequest, CreateUserResponse>()
                .withOperationName("CreateUser").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createUserRequest)
                .withMarshaller(new CreateUserRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes an access control rule for the specified WorkMail organization.
     * </p>
     *
     * @param deleteAccessControlRuleRequest
     * @return Result of the DeleteAccessControlRule operation returned by the service.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DeleteAccessControlRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteAccessControlRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteAccessControlRuleResponse deleteAccessControlRule(DeleteAccessControlRuleRequest deleteAccessControlRuleRequest)
            throws OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException,
            WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAccessControlRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAccessControlRuleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteAccessControlRuleRequest, DeleteAccessControlRuleResponse>()
                .withOperationName("DeleteAccessControlRule").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteAccessControlRuleRequest)
                .withMarshaller(new DeleteAccessControlRuleRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Remove one or more specified aliases from a set of aliases for a given user.
     * </p>
     *
     * @param deleteAliasRequest
     * @return Result of the DeleteAlias operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DeleteAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteAliasResponse deleteAlias(DeleteAliasRequest deleteAliasRequest) throws EntityNotFoundException,
            EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException,
            AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteAliasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteAliasRequest, DeleteAliasResponse>()
                .withOperationName("DeleteAlias").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteAliasRequest)
                .withMarshaller(new DeleteAliasRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a group from Amazon WorkMail.
     * </p>
     *
     * @param deleteGroupRequest
     * @return Result of the DeleteGroup operation returned by the service.
     * @throws DirectoryServiceAuthenticationFailedException
     *         The directory service doesn't recognize the credentials supplied by WorkMail.
     * @throws DirectoryUnavailableException
     *         The directory on which you are trying to perform operations isn't available.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws UnsupportedOperationException
     *         You can't perform a write operation against a read-only directory.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DeleteGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteGroupResponse deleteGroup(DeleteGroupRequest deleteGroupRequest)
            throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, EntityStateException,
            InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, UnsupportedOperationException,
            AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteGroupRequest, DeleteGroupResponse>()
                .withOperationName("DeleteGroup").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteGroupRequest)
                .withMarshaller(new DeleteGroupRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes permissions granted to a member (user or group).
     * </p>
     *
     * @param deleteMailboxPermissionsRequest
     * @return Result of the DeleteMailboxPermissions operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DeleteMailboxPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteMailboxPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteMailboxPermissionsResponse deleteMailboxPermissions(
            DeleteMailboxPermissionsRequest deleteMailboxPermissionsRequest) throws EntityNotFoundException,
            EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException,
            AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteMailboxPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteMailboxPermissionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<DeleteMailboxPermissionsRequest, DeleteMailboxPermissionsResponse>()
                        .withOperationName("DeleteMailboxPermissions").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(deleteMailboxPermissionsRequest)
                        .withMarshaller(new DeleteMailboxPermissionsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes the specified resource.
     * </p>
     *
     * @param deleteResourceRequest
     * @return Result of the DeleteResource operation returned by the service.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DeleteResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteResourceResponse deleteResource(DeleteResourceRequest deleteResourceRequest) throws EntityStateException,
            InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteResourceRequest, DeleteResourceResponse>()
                .withOperationName("DeleteResource").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteResourceRequest)
                .withMarshaller(new DeleteResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes the specified retention policy from the specified organization.
     * </p>
     *
     * @param deleteRetentionPolicyRequest
     * @return Result of the DeleteRetentionPolicy operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DeleteRetentionPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteRetentionPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteRetentionPolicyResponse deleteRetentionPolicy(DeleteRetentionPolicyRequest deleteRetentionPolicyRequest)
            throws InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRetentionPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteRetentionPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteRetentionPolicyRequest, DeleteRetentionPolicyResponse>()
                .withOperationName("DeleteRetentionPolicy").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteRetentionPolicyRequest)
                .withMarshaller(new DeleteRetentionPolicyRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a user from Amazon WorkMail and all subsequent systems. Before you can delete a user, the user state must
     * be <code>DISABLED</code>. Use the <a>DescribeUser</a> action to confirm the user state.
     * </p>
     * <p>
     * Deleting a user is permanent and cannot be undone. WorkMail archives user mailboxes for 30 days before they are
     * permanently removed.
     * </p>
     *
     * @param deleteUserRequest
     * @return Result of the DeleteUser operation returned by the service.
     * @throws DirectoryServiceAuthenticationFailedException
     *         The directory service doesn't recognize the credentials supplied by WorkMail.
     * @throws DirectoryUnavailableException
     *         The directory on which you are trying to perform operations isn't available.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws UnsupportedOperationException
     *         You can't perform a write operation against a read-only directory.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DeleteUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteUserResponse deleteUser(DeleteUserRequest deleteUserRequest)
            throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, EntityStateException,
            InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, UnsupportedOperationException,
            AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteUserRequest, DeleteUserResponse>()
                .withOperationName("DeleteUser").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteUserRequest)
                .withMarshaller(new DeleteUserRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Mark a user, group, or resource as no longer used in Amazon WorkMail. This action disassociates the mailbox and
     * schedules it for clean-up. WorkMail keeps mailboxes for 30 days before they are permanently removed. The
     * functionality in the console is <i>Disable</i>.
     * </p>
     *
     * @param deregisterFromWorkMailRequest
     * @return Result of the DeregisterFromWorkMail operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DeregisterFromWorkMail
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeregisterFromWorkMail"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeregisterFromWorkMailResponse deregisterFromWorkMail(DeregisterFromWorkMailRequest deregisterFromWorkMailRequest)
            throws EntityNotFoundException, EntityStateException, InvalidParameterException, OrganizationNotFoundException,
            OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeregisterFromWorkMailResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeregisterFromWorkMailResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeregisterFromWorkMailRequest, DeregisterFromWorkMailResponse>()
                .withOperationName("DeregisterFromWorkMail").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deregisterFromWorkMailRequest)
                .withMarshaller(new DeregisterFromWorkMailRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns the data available for the group.
     * </p>
     *
     * @param describeGroupRequest
     * @return Result of the DescribeGroup operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DescribeGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeGroupResponse describeGroup(DescribeGroupRequest describeGroupRequest) throws EntityNotFoundException,
            InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DescribeGroupRequest, DescribeGroupResponse>()
                .withOperationName("DescribeGroup").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeGroupRequest)
                .withMarshaller(new DescribeGroupRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Provides more information regarding a given organization based on its identifier.
     * </p>
     *
     * @param describeOrganizationRequest
     * @return Result of the DescribeOrganization operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DescribeOrganization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeOrganization" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeOrganizationResponse describeOrganization(DescribeOrganizationRequest describeOrganizationRequest)
            throws InvalidParameterException, OrganizationNotFoundException, AwsServiceException, SdkClientException,
            WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeOrganizationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeOrganizationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DescribeOrganizationRequest, DescribeOrganizationResponse>()
                .withOperationName("DescribeOrganization").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeOrganizationRequest)
                .withMarshaller(new DescribeOrganizationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns the data available for the resource.
     * </p>
     *
     * @param describeResourceRequest
     * @return Result of the DescribeResource operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DescribeResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeResourceResponse describeResource(DescribeResourceRequest describeResourceRequest)
            throws EntityNotFoundException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException,
            AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DescribeResourceRequest, DescribeResourceResponse>()
                .withOperationName("DescribeResource").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeResourceRequest)
                .withMarshaller(new DescribeResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Provides information regarding the user.
     * </p>
     *
     * @param describeUserRequest
     * @return Result of the DescribeUser operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DescribeUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeUserResponse describeUser(DescribeUserRequest describeUserRequest) throws EntityNotFoundException,
            InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DescribeUserRequest, DescribeUserResponse>()
                .withOperationName("DescribeUser").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeUserRequest)
                .withMarshaller(new DescribeUserRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Removes a member from the resource's set of delegates.
     * </p>
     *
     * @param disassociateDelegateFromResourceRequest
     * @return Result of the DisassociateDelegateFromResource operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DisassociateDelegateFromResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DisassociateDelegateFromResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateDelegateFromResourceResponse disassociateDelegateFromResource(
            DisassociateDelegateFromResourceRequest disassociateDelegateFromResourceRequest) throws EntityNotFoundException,
            EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException,
            AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateDelegateFromResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateDelegateFromResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<DisassociateDelegateFromResourceRequest, DisassociateDelegateFromResourceResponse>()
                        .withOperationName("DisassociateDelegateFromResource").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(disassociateDelegateFromResourceRequest)
                        .withMarshaller(new DisassociateDelegateFromResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Removes a member from a group.
     * </p>
     *
     * @param disassociateMemberFromGroupRequest
     * @return Result of the DisassociateMemberFromGroup operation returned by the service.
     * @throws DirectoryServiceAuthenticationFailedException
     *         The directory service doesn't recognize the credentials supplied by WorkMail.
     * @throws DirectoryUnavailableException
     *         The directory on which you are trying to perform operations isn't available.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws UnsupportedOperationException
     *         You can't perform a write operation against a read-only directory.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DisassociateMemberFromGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DisassociateMemberFromGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateMemberFromGroupResponse disassociateMemberFromGroup(
            DisassociateMemberFromGroupRequest disassociateMemberFromGroupRequest)
            throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, EntityNotFoundException,
            EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException,
            UnsupportedOperationException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateMemberFromGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateMemberFromGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<DisassociateMemberFromGroupRequest, DisassociateMemberFromGroupResponse>()
                        .withOperationName("DisassociateMemberFromGroup").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(disassociateMemberFromGroupRequest)
                        .withMarshaller(new DisassociateMemberFromGroupRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets the effects of an organization's access control rules as they apply to a specified IPv4 address, access
     * protocol action, or user ID.
     * </p>
     *
     * @param getAccessControlEffectRequest
     * @return Result of the GetAccessControlEffect operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.GetAccessControlEffect
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetAccessControlEffect"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetAccessControlEffectResponse getAccessControlEffect(GetAccessControlEffectRequest getAccessControlEffectRequest)
            throws EntityNotFoundException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException,
            AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAccessControlEffectResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetAccessControlEffectResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetAccessControlEffectRequest, GetAccessControlEffectResponse>()
                .withOperationName("GetAccessControlEffect").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getAccessControlEffectRequest)
                .withMarshaller(new GetAccessControlEffectRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets the default retention policy details for the specified organization.
     * </p>
     *
     * @param getDefaultRetentionPolicyRequest
     * @return Result of the GetDefaultRetentionPolicy operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.GetDefaultRetentionPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetDefaultRetentionPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetDefaultRetentionPolicyResponse getDefaultRetentionPolicy(
            GetDefaultRetentionPolicyRequest getDefaultRetentionPolicyRequest) throws InvalidParameterException,
            OrganizationNotFoundException, OrganizationStateException, EntityNotFoundException, AwsServiceException,
            SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDefaultRetentionPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetDefaultRetentionPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<GetDefaultRetentionPolicyRequest, GetDefaultRetentionPolicyResponse>()
                        .withOperationName("GetDefaultRetentionPolicy").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(getDefaultRetentionPolicyRequest)
                        .withMarshaller(new GetDefaultRetentionPolicyRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Requests a user's mailbox details for a specified organization and user.
     * </p>
     *
     * @param getMailboxDetailsRequest
     * @return Result of the GetMailboxDetails operation returned by the service.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.GetMailboxDetails
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetMailboxDetails" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetMailboxDetailsResponse getMailboxDetails(GetMailboxDetailsRequest getMailboxDetailsRequest)
            throws OrganizationNotFoundException, OrganizationStateException, EntityNotFoundException, AwsServiceException,
            SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMailboxDetailsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetMailboxDetailsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetMailboxDetailsRequest, GetMailboxDetailsResponse>()
                .withOperationName("GetMailboxDetails").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getMailboxDetailsRequest)
                .withMarshaller(new GetMailboxDetailsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists the access control rules for the specified organization.
     * </p>
     *
     * @param listAccessControlRulesRequest
     * @return Result of the ListAccessControlRules operation returned by the service.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListAccessControlRules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListAccessControlRules"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAccessControlRulesResponse listAccessControlRules(ListAccessControlRulesRequest listAccessControlRulesRequest)
            throws OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException,
            WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAccessControlRulesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAccessControlRulesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListAccessControlRulesRequest, ListAccessControlRulesResponse>()
                .withOperationName("ListAccessControlRules").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listAccessControlRulesRequest)
                .withMarshaller(new ListAccessControlRulesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a paginated call to list the aliases associated with a given entity.
     * </p>
     *
     * @param listAliasesRequest
     * @return Result of the ListAliases operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListAliases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListAliasesResponse listAliases(ListAliasesRequest listAliasesRequest) throws EntityNotFoundException,
            EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException,
            AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAliasesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListAliasesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListAliasesRequest, ListAliasesResponse>()
                .withOperationName("ListAliases").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listAliasesRequest)
                .withMarshaller(new ListAliasesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a paginated call to list the aliases associated with a given entity.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAliases(software.amazon.awssdk.services.workmail.model.ListAliasesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListAliasesIterable responses = client.listAliasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workmail.paginators.ListAliasesIterable responses = client.listAliasesPaginator(request);
     *     for (software.amazon.awssdk.services.workmail.model.ListAliasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListAliasesIterable responses = client.listAliasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAliases(software.amazon.awssdk.services.workmail.model.ListAliasesRequest)} operation.</b>
     * </p>
     *
     * @param listAliasesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListAliases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListAliasesIterable listAliasesPaginator(ListAliasesRequest listAliasesRequest) throws EntityNotFoundException,
            EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException,
            AwsServiceException, SdkClientException, WorkMailException {
        return new ListAliasesIterable(this, applyPaginatorUserAgent(listAliasesRequest));
    }

    /**
     * <p>
     * Returns an overview of the members of a group. Users and groups can be members of a group.
     * </p>
     *
     * @param listGroupMembersRequest
     * @return Result of the ListGroupMembers operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListGroupMembers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroupMembers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListGroupMembersResponse listGroupMembers(ListGroupMembersRequest listGroupMembersRequest)
            throws EntityNotFoundException, EntityStateException, InvalidParameterException, OrganizationNotFoundException,
            OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListGroupMembersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListGroupMembersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListGroupMembersRequest, ListGroupMembersResponse>()
                .withOperationName("ListGroupMembers").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listGroupMembersRequest)
                .withMarshaller(new ListGroupMembersRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns an overview of the members of a group. Users and groups can be members of a group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGroupMembers(software.amazon.awssdk.services.workmail.model.ListGroupMembersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListGroupMembersIterable responses = client.listGroupMembersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workmail.paginators.ListGroupMembersIterable responses = client
     *             .listGroupMembersPaginator(request);
     *     for (software.amazon.awssdk.services.workmail.model.ListGroupMembersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListGroupMembersIterable responses = client.listGroupMembersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroupMembers(software.amazon.awssdk.services.workmail.model.ListGroupMembersRequest)} operation.</b>
     * </p>
     *
     * @param listGroupMembersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListGroupMembers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroupMembers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListGroupMembersIterable listGroupMembersPaginator(ListGroupMembersRequest listGroupMembersRequest)
            throws EntityNotFoundException, EntityStateException, InvalidParameterException, OrganizationNotFoundException,
            OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        return new ListGroupMembersIterable(this, applyPaginatorUserAgent(listGroupMembersRequest));
    }

    /**
     * <p>
     * Returns summaries of the organization's groups.
     * </p>
     *
     * @param listGroupsRequest
     * @return Result of the ListGroups operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListGroupsResponse listGroups(ListGroupsRequest listGroupsRequest) throws EntityNotFoundException,
            InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListGroupsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListGroupsRequest, ListGroupsResponse>()
                .withOperationName("ListGroups").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listGroupsRequest)
                .withMarshaller(new ListGroupsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns summaries of the organization's groups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listGroups(software.amazon.awssdk.services.workmail.model.ListGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListGroupsIterable responses = client.listGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workmail.paginators.ListGroupsIterable responses = client.listGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.workmail.model.ListGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListGroupsIterable responses = client.listGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroups(software.amazon.awssdk.services.workmail.model.ListGroupsRequest)} operation.</b>
     * </p>
     *
     * @param listGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListGroupsIterable listGroupsPaginator(ListGroupsRequest listGroupsRequest) throws EntityNotFoundException,
            InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        return new ListGroupsIterable(this, applyPaginatorUserAgent(listGroupsRequest));
    }

    /**
     * <p>
     * Lists the mailbox permissions associated with a user, group, or resource mailbox.
     * </p>
     *
     * @param listMailboxPermissionsRequest
     * @return Result of the ListMailboxPermissions operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListMailboxPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailboxPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListMailboxPermissionsResponse listMailboxPermissions(ListMailboxPermissionsRequest listMailboxPermissionsRequest)
            throws EntityNotFoundException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException,
            AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListMailboxPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListMailboxPermissionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListMailboxPermissionsRequest, ListMailboxPermissionsResponse>()
                .withOperationName("ListMailboxPermissions").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listMailboxPermissionsRequest)
                .withMarshaller(new ListMailboxPermissionsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists the mailbox permissions associated with a user, group, or resource mailbox.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMailboxPermissions(software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMailboxPermissionsIterable responses = client.listMailboxPermissionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workmail.paginators.ListMailboxPermissionsIterable responses = client
     *             .listMailboxPermissionsPaginator(request);
     *     for (software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMailboxPermissionsIterable responses = client.listMailboxPermissionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMailboxPermissions(software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMailboxPermissionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListMailboxPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailboxPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListMailboxPermissionsIterable listMailboxPermissionsPaginator(
            ListMailboxPermissionsRequest listMailboxPermissionsRequest) throws EntityNotFoundException,
            InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        return new ListMailboxPermissionsIterable(this, applyPaginatorUserAgent(listMailboxPermissionsRequest));
    }

    /**
     * <p>
     * Returns summaries of the customer's organizations.
     * </p>
     *
     * @param listOrganizationsRequest
     * @return Result of the ListOrganizations operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListOrganizations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListOrganizations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListOrganizationsResponse listOrganizations(ListOrganizationsRequest listOrganizationsRequest)
            throws InvalidParameterException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListOrganizationsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListOrganizationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListOrganizationsRequest, ListOrganizationsResponse>()
                .withOperationName("ListOrganizations").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listOrganizationsRequest)
                .withMarshaller(new ListOrganizationsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns summaries of the customer's organizations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOrganizations(software.amazon.awssdk.services.workmail.model.ListOrganizationsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListOrganizationsIterable responses = client.listOrganizationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workmail.paginators.ListOrganizationsIterable responses = client
     *             .listOrganizationsPaginator(request);
     *     for (software.amazon.awssdk.services.workmail.model.ListOrganizationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListOrganizationsIterable responses = client.listOrganizationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizations(software.amazon.awssdk.services.workmail.model.ListOrganizationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOrganizationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListOrganizations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListOrganizations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListOrganizationsIterable listOrganizationsPaginator(ListOrganizationsRequest listOrganizationsRequest)
            throws InvalidParameterException, AwsServiceException, SdkClientException, WorkMailException {
        return new ListOrganizationsIterable(this, applyPaginatorUserAgent(listOrganizationsRequest));
    }

    /**
     * <p>
     * Lists the delegates associated with a resource. Users and groups can be resource delegates and answer requests on
     * behalf of the resource.
     * </p>
     *
     * @param listResourceDelegatesRequest
     * @return Result of the ListResourceDelegates operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListResourceDelegates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResourceDelegates" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListResourceDelegatesResponse listResourceDelegates(ListResourceDelegatesRequest listResourceDelegatesRequest)
            throws EntityNotFoundException, EntityStateException, InvalidParameterException, OrganizationNotFoundException,
            OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListResourceDelegatesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListResourceDelegatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListResourceDelegatesRequest, ListResourceDelegatesResponse>()
                .withOperationName("ListResourceDelegates").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listResourceDelegatesRequest)
                .withMarshaller(new ListResourceDelegatesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists the delegates associated with a resource. Users and groups can be resource delegates and answer requests on
     * behalf of the resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourceDelegates(software.amazon.awssdk.services.workmail.model.ListResourceDelegatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListResourceDelegatesIterable responses = client.listResourceDelegatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workmail.paginators.ListResourceDelegatesIterable responses = client
     *             .listResourceDelegatesPaginator(request);
     *     for (software.amazon.awssdk.services.workmail.model.ListResourceDelegatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListResourceDelegatesIterable responses = client.listResourceDelegatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceDelegates(software.amazon.awssdk.services.workmail.model.ListResourceDelegatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourceDelegatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListResourceDelegates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResourceDelegates" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListResourceDelegatesIterable listResourceDelegatesPaginator(ListResourceDelegatesRequest listResourceDelegatesRequest)
            throws EntityNotFoundException, EntityStateException, InvalidParameterException, OrganizationNotFoundException,
            OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        return new ListResourceDelegatesIterable(this, applyPaginatorUserAgent(listResourceDelegatesRequest));
    }

    /**
     * <p>
     * Returns summaries of the organization's resources.
     * </p>
     *
     * @param listResourcesRequest
     * @return Result of the ListResources operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResources" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListResourcesResponse listResources(ListResourcesRequest listResourcesRequest) throws InvalidParameterException,
            OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListResourcesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListResourcesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListResourcesRequest, ListResourcesResponse>()
                .withOperationName("ListResources").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listResourcesRequest)
                .withMarshaller(new ListResourcesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns summaries of the organization's resources.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listResources(software.amazon.awssdk.services.workmail.model.ListResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListResourcesIterable responses = client.listResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workmail.paginators.ListResourcesIterable responses = client.listResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.workmail.model.ListResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListResourcesIterable responses = client.listResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResources(software.amazon.awssdk.services.workmail.model.ListResourcesRequest)} operation.</b>
     * </p>
     *
     * @param listResourcesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResources" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListResourcesIterable listResourcesPaginator(ListResourcesRequest listResourcesRequest)
            throws InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        return new ListResourcesIterable(this, applyPaginatorUserAgent(listResourcesRequest));
    }

    /**
     * <p>
     * Lists the tags applied to an Amazon WorkMail organization resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                .withOperationName("ListTagsForResource").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listTagsForResourceRequest)
                .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns summaries of the organization's users.
     * </p>
     *
     * @param listUsersRequest
     * @return Result of the ListUsers operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListUsersResponse listUsers(ListUsersRequest listUsersRequest) throws InvalidParameterException,
            OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListUsersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListUsersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListUsersRequest, ListUsersResponse>()
                .withOperationName("ListUsers").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listUsersRequest)
                .withMarshaller(new ListUsersRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns summaries of the organization's users.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listUsers(software.amazon.awssdk.services.workmail.model.ListUsersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListUsersIterable responses = client.listUsersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workmail.paginators.ListUsersIterable responses = client.listUsersPaginator(request);
     *     for (software.amazon.awssdk.services.workmail.model.ListUsersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListUsersIterable responses = client.listUsersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsers(software.amazon.awssdk.services.workmail.model.ListUsersRequest)} operation.</b>
     * </p>
     *
     * @param listUsersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListUsersIterable listUsersPaginator(ListUsersRequest listUsersRequest) throws InvalidParameterException,
            OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        return new ListUsersIterable(this, applyPaginatorUserAgent(listUsersRequest));
    }

    /**
     * <p>
     * Adds a new access control rule for the specified organization. The rule allows or denies access to the
     * organization for the specified IPv4 addresses, access protocol actions, and user IDs. Adding a new rule with the
     * same name as an existing rule replaces the older rule.
     * </p>
     *
     * @param putAccessControlRuleRequest
     * @return Result of the PutAccessControlRule operation returned by the service.
     * @throws LimitExceededException
     *         The request exceeds the limit of the resource.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.PutAccessControlRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutAccessControlRule" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public PutAccessControlRuleResponse putAccessControlRule(PutAccessControlRuleRequest putAccessControlRuleRequest)
            throws LimitExceededException, InvalidParameterException, EntityNotFoundException, OrganizationNotFoundException,
            OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutAccessControlRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutAccessControlRuleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<PutAccessControlRuleRequest, PutAccessControlRuleResponse>()
                .withOperationName("PutAccessControlRule").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(putAccessControlRuleRequest)
                .withMarshaller(new PutAccessControlRuleRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Sets permissions for a user, group, or resource. This replaces any pre-existing permissions.
     * </p>
     *
     * @param putMailboxPermissionsRequest
     * @return Result of the PutMailboxPermissions operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.PutMailboxPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutMailboxPermissions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public PutMailboxPermissionsResponse putMailboxPermissions(PutMailboxPermissionsRequest putMailboxPermissionsRequest)
            throws EntityNotFoundException, EntityStateException, InvalidParameterException, OrganizationNotFoundException,
            OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutMailboxPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutMailboxPermissionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<PutMailboxPermissionsRequest, PutMailboxPermissionsResponse>()
                .withOperationName("PutMailboxPermissions").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(putMailboxPermissionsRequest)
                .withMarshaller(new PutMailboxPermissionsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Puts a retention policy to the specified organization.
     * </p>
     *
     * @param putRetentionPolicyRequest
     * @return Result of the PutRetentionPolicy operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws LimitExceededException
     *         The request exceeds the limit of the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.PutRetentionPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutRetentionPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public PutRetentionPolicyResponse putRetentionPolicy(PutRetentionPolicyRequest putRetentionPolicyRequest)
            throws InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, LimitExceededException,
            AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutRetentionPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutRetentionPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<PutRetentionPolicyRequest, PutRetentionPolicyResponse>()
                .withOperationName("PutRetentionPolicy").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(putRetentionPolicyRequest)
                .withMarshaller(new PutRetentionPolicyRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Registers an existing and disabled user, group, or resource for Amazon WorkMail use by associating a mailbox and
     * calendaring capabilities. It performs no change if the user, group, or resource is enabled and fails if the user,
     * group, or resource is deleted. This operation results in the accumulation of costs. For more information, see <a
     * href="https://aws.amazon.com/workmail/pricing">Pricing</a>. The equivalent console functionality for this
     * operation is <i>Enable</i>.
     * </p>
     * <p>
     * Users can either be created by calling the <a>CreateUser</a> API operation or they can be synchronized from your
     * directory. For more information, see <a>DeregisterFromWorkMail</a>.
     * </p>
     *
     * @param registerToWorkMailRequest
     * @return Result of the RegisterToWorkMail operation returned by the service.
     * @throws DirectoryServiceAuthenticationFailedException
     *         The directory service doesn't recognize the credentials supplied by WorkMail.
     * @throws DirectoryUnavailableException
     *         The directory on which you are trying to perform operations isn't available.
     * @throws EmailAddressInUseException
     *         The email address that you're trying to assign is already created for a different user, group, or
     *         resource.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws EntityAlreadyRegisteredException
     *         The user, group, or resource that you're trying to register is already registered.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws MailDomainNotFoundException
     *         For an email or alias to be created in Amazon WorkMail, the included domain must be defined in the
     *         organization.
     * @throws MailDomainStateException
     *         After a domain has been added to the organization, it must be verified. The domain is not yet verified.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.RegisterToWorkMail
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/RegisterToWorkMail" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public RegisterToWorkMailResponse registerToWorkMail(RegisterToWorkMailRequest registerToWorkMailRequest)
            throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, EmailAddressInUseException,
            EntityNotFoundException, EntityStateException, EntityAlreadyRegisteredException, InvalidParameterException,
            MailDomainNotFoundException, MailDomainStateException, OrganizationNotFoundException, OrganizationStateException,
            AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RegisterToWorkMailResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RegisterToWorkMailResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<RegisterToWorkMailRequest, RegisterToWorkMailResponse>()
                .withOperationName("RegisterToWorkMail").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(registerToWorkMailRequest)
                .withMarshaller(new RegisterToWorkMailRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Allows the administrator to reset the password for a user.
     * </p>
     *
     * @param resetPasswordRequest
     * @return Result of the ResetPassword operation returned by the service.
     * @throws DirectoryServiceAuthenticationFailedException
     *         The directory service doesn't recognize the credentials supplied by WorkMail.
     * @throws DirectoryUnavailableException
     *         The directory on which you are trying to perform operations isn't available.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws InvalidPasswordException
     *         The supplied password doesn't match the minimum security constraints, such as length or use of special
     *         characters.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws UnsupportedOperationException
     *         You can't perform a write operation against a read-only directory.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ResetPassword
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ResetPassword" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ResetPasswordResponse resetPassword(ResetPasswordRequest resetPasswordRequest)
            throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, EntityNotFoundException,
            EntityStateException, InvalidParameterException, InvalidPasswordException, OrganizationNotFoundException,
            OrganizationStateException, UnsupportedOperationException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ResetPasswordResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ResetPasswordResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ResetPasswordRequest, ResetPasswordResponse>()
                .withOperationName("ResetPassword").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(resetPasswordRequest)
                .withMarshaller(new ResetPasswordRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Applies the specified tags to the specified Amazon WorkMail organization resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws TooManyTagsException
     *         The resource can have up to 50 user-applied tags.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            TooManyTagsException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                .withOperationName("TagResource").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(tagResourceRequest)
                .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Untags the specified tags from the specified Amazon WorkMail organization resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                .withOperationName("UntagResource").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(untagResourceRequest)
                .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates a user's current mailbox quota for a specified organization and user.
     * </p>
     *
     * @param updateMailboxQuotaRequest
     * @return Result of the UpdateMailboxQuota operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.UpdateMailboxQuota
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateMailboxQuota" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateMailboxQuotaResponse updateMailboxQuota(UpdateMailboxQuotaRequest updateMailboxQuotaRequest)
            throws InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, EntityNotFoundException,
            EntityStateException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateMailboxQuotaResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateMailboxQuotaResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateMailboxQuotaRequest, UpdateMailboxQuotaResponse>()
                .withOperationName("UpdateMailboxQuota").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateMailboxQuotaRequest)
                .withMarshaller(new UpdateMailboxQuotaRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates the primary email for a user, group, or resource. The current email is moved into the list of aliases (or
     * swapped between an existing alias and the current primary email), and the email provided in the input is promoted
     * as the primary.
     * </p>
     *
     * @param updatePrimaryEmailAddressRequest
     * @return Result of the UpdatePrimaryEmailAddress operation returned by the service.
     * @throws DirectoryServiceAuthenticationFailedException
     *         The directory service doesn't recognize the credentials supplied by WorkMail.
     * @throws DirectoryUnavailableException
     *         The directory on which you are trying to perform operations isn't available.
     * @throws EmailAddressInUseException
     *         The email address that you're trying to assign is already created for a different user, group, or
     *         resource.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws MailDomainNotFoundException
     *         For an email or alias to be created in Amazon WorkMail, the included domain must be defined in the
     *         organization.
     * @throws MailDomainStateException
     *         After a domain has been added to the organization, it must be verified. The domain is not yet verified.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws UnsupportedOperationException
     *         You can't perform a write operation against a read-only directory.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.UpdatePrimaryEmailAddress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdatePrimaryEmailAddress"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdatePrimaryEmailAddressResponse updatePrimaryEmailAddress(
            UpdatePrimaryEmailAddressRequest updatePrimaryEmailAddressRequest)
            throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, EmailAddressInUseException,
            EntityNotFoundException, EntityStateException, InvalidParameterException, MailDomainNotFoundException,
            MailDomainStateException, OrganizationNotFoundException, OrganizationStateException, UnsupportedOperationException,
            AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdatePrimaryEmailAddressResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdatePrimaryEmailAddressResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<UpdatePrimaryEmailAddressRequest, UpdatePrimaryEmailAddressResponse>()
                        .withOperationName("UpdatePrimaryEmailAddress").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(updatePrimaryEmailAddressRequest)
                        .withMarshaller(new UpdatePrimaryEmailAddressRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates data for the resource. To have the latest information, it must be preceded by a <a>DescribeResource</a>
     * call. The dataset in the request should be the one expected when performing another <code>DescribeResource</code>
     * call.
     * </p>
     *
     * @param updateResourceRequest
     * @return Result of the UpdateResource operation returned by the service.
     * @throws DirectoryUnavailableException
     *         The directory on which you are trying to perform operations isn't available.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidConfigurationException
     *         The configuration for a resource isn't valid. A resource must either be able to auto-respond to requests
     *         or have at least one delegate associated that can do so on its behalf.
     * @throws EmailAddressInUseException
     *         The email address that you're trying to assign is already created for a different user, group, or
     *         resource.
     * @throws MailDomainNotFoundException
     *         For an email or alias to be created in Amazon WorkMail, the included domain must be defined in the
     *         organization.
     * @throws MailDomainStateException
     *         After a domain has been added to the organization, it must be verified. The domain is not yet verified.
     * @throws NameAvailabilityException
     *         The user, group, or resource name isn't unique in Amazon WorkMail.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state (Active or Synchronizing) to perform certain operations on the
     *         organization or its members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.UpdateResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateResourceResponse updateResource(UpdateResourceRequest updateResourceRequest)
            throws DirectoryUnavailableException, EntityNotFoundException, EntityStateException, InvalidConfigurationException,
            EmailAddressInUseException, MailDomainNotFoundException, MailDomainStateException, NameAvailabilityException,
            OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateResourceRequest, UpdateResourceResponse>()
                .withOperationName("UpdateResource").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateResourceRequest)
                .withMarshaller(new UpdateResourceRequestMarshaller(protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(WorkMailException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DirectoryUnavailableException")
                                .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidConfigurationException")
                                .exceptionBuilderSupplier(InvalidConfigurationException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterException")
                                .exceptionBuilderSupplier(InvalidParameterException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MailDomainStateException")
                                .exceptionBuilderSupplier(MailDomainStateException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MailDomainNotFoundException")
                                .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                                .exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NameAvailabilityException")
                                .exceptionBuilderSupplier(NameAvailabilityException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EmailAddressInUseException")
                                .exceptionBuilderSupplier(EmailAddressInUseException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                                .exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTagsException")
                                .exceptionBuilderSupplier(TooManyTagsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPasswordException")
                                .exceptionBuilderSupplier(InvalidPasswordException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedOperationException")
                                .exceptionBuilderSupplier(UnsupportedOperationException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EntityNotFoundException")
                                .exceptionBuilderSupplier(EntityNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReservedNameException")
                                .exceptionBuilderSupplier(ReservedNameException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OrganizationStateException")
                                .exceptionBuilderSupplier(OrganizationStateException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OrganizationNotFoundException")
                                .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EntityStateException")
                                .exceptionBuilderSupplier(EntityStateException::builder).build());
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends WorkMailRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }
}
