/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.worklink.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWebsiteAuthorizationProvidersResponse extends WorkLinkResponse implements
        ToCopyableBuilder<ListWebsiteAuthorizationProvidersResponse.Builder, ListWebsiteAuthorizationProvidersResponse> {
    private static final SdkField<List<WebsiteAuthorizationProviderSummary>> WEBSITE_AUTHORIZATION_PROVIDERS_FIELD = SdkField
            .<List<WebsiteAuthorizationProviderSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListWebsiteAuthorizationProvidersResponse::websiteAuthorizationProviders))
            .setter(setter(Builder::websiteAuthorizationProviders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebsiteAuthorizationProviders")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WebsiteAuthorizationProviderSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(WebsiteAuthorizationProviderSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListWebsiteAuthorizationProvidersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            WEBSITE_AUTHORIZATION_PROVIDERS_FIELD, NEXT_TOKEN_FIELD));

    private final List<WebsiteAuthorizationProviderSummary> websiteAuthorizationProviders;

    private final String nextToken;

    private ListWebsiteAuthorizationProvidersResponse(BuilderImpl builder) {
        super(builder);
        this.websiteAuthorizationProviders = builder.websiteAuthorizationProviders;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the WebsiteAuthorizationProviders property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasWebsiteAuthorizationProviders() {
        return websiteAuthorizationProviders != null && !(websiteAuthorizationProviders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The website authorization providers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasWebsiteAuthorizationProviders()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The website authorization providers.
     */
    public List<WebsiteAuthorizationProviderSummary> websiteAuthorizationProviders() {
        return websiteAuthorizationProviders;
    }

    /**
     * <p>
     * The pagination token to use to retrieve the next page of results for this operation. If this value is null, it
     * retrieves the first page.
     * </p>
     * 
     * @return The pagination token to use to retrieve the next page of results for this operation. If this value is
     *         null, it retrieves the first page.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(websiteAuthorizationProviders());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWebsiteAuthorizationProvidersResponse)) {
            return false;
        }
        ListWebsiteAuthorizationProvidersResponse other = (ListWebsiteAuthorizationProvidersResponse) obj;
        return Objects.equals(websiteAuthorizationProviders(), other.websiteAuthorizationProviders())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListWebsiteAuthorizationProvidersResponse")
                .add("WebsiteAuthorizationProviders", websiteAuthorizationProviders()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WebsiteAuthorizationProviders":
            return Optional.ofNullable(clazz.cast(websiteAuthorizationProviders()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWebsiteAuthorizationProvidersResponse, T> g) {
        return obj -> g.apply((ListWebsiteAuthorizationProvidersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkLinkResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListWebsiteAuthorizationProvidersResponse> {
        /**
         * <p>
         * The website authorization providers.
         * </p>
         * 
         * @param websiteAuthorizationProviders
         *        The website authorization providers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder websiteAuthorizationProviders(Collection<WebsiteAuthorizationProviderSummary> websiteAuthorizationProviders);

        /**
         * <p>
         * The website authorization providers.
         * </p>
         * 
         * @param websiteAuthorizationProviders
         *        The website authorization providers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder websiteAuthorizationProviders(WebsiteAuthorizationProviderSummary... websiteAuthorizationProviders);

        /**
         * <p>
         * The website authorization providers.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <WebsiteAuthorizationProviderSummary>.Builder} avoiding the need to create one manually via {@link List
         * <WebsiteAuthorizationProviderSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<WebsiteAuthorizationProviderSummary>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #websiteAuthorizationProviders(List<WebsiteAuthorizationProviderSummary>)}.
         * 
         * @param websiteAuthorizationProviders
         *        a consumer that will call methods on {@link List<WebsiteAuthorizationProviderSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #websiteAuthorizationProviders(List<WebsiteAuthorizationProviderSummary>)
         */
        Builder websiteAuthorizationProviders(
                Consumer<WebsiteAuthorizationProviderSummary.Builder>... websiteAuthorizationProviders);

        /**
         * <p>
         * The pagination token to use to retrieve the next page of results for this operation. If this value is null,
         * it retrieves the first page.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use to retrieve the next page of results for this operation. If this value is
         *        null, it retrieves the first page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends WorkLinkResponse.BuilderImpl implements Builder {
        private List<WebsiteAuthorizationProviderSummary> websiteAuthorizationProviders = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWebsiteAuthorizationProvidersResponse model) {
            super(model);
            websiteAuthorizationProviders(model.websiteAuthorizationProviders);
            nextToken(model.nextToken);
        }

        public final Collection<WebsiteAuthorizationProviderSummary.Builder> getWebsiteAuthorizationProviders() {
            return websiteAuthorizationProviders != null ? websiteAuthorizationProviders.stream()
                    .map(WebsiteAuthorizationProviderSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder websiteAuthorizationProviders(
                Collection<WebsiteAuthorizationProviderSummary> websiteAuthorizationProviders) {
            this.websiteAuthorizationProviders = WebsiteAuthorizationProvidersSummaryListCopier
                    .copy(websiteAuthorizationProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder websiteAuthorizationProviders(WebsiteAuthorizationProviderSummary... websiteAuthorizationProviders) {
            websiteAuthorizationProviders(Arrays.asList(websiteAuthorizationProviders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder websiteAuthorizationProviders(
                Consumer<WebsiteAuthorizationProviderSummary.Builder>... websiteAuthorizationProviders) {
            websiteAuthorizationProviders(Stream.of(websiteAuthorizationProviders)
                    .map(c -> WebsiteAuthorizationProviderSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setWebsiteAuthorizationProviders(
                Collection<WebsiteAuthorizationProviderSummary.BuilderImpl> websiteAuthorizationProviders) {
            this.websiteAuthorizationProviders = WebsiteAuthorizationProvidersSummaryListCopier
                    .copyFromBuilder(websiteAuthorizationProviders);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListWebsiteAuthorizationProvidersResponse build() {
            return new ListWebsiteAuthorizationProvidersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
