/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.worklink.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of the certificate authority (CA).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WebsiteCaSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<WebsiteCaSummary.Builder, WebsiteCaSummary> {
    private static final SdkField<String> WEBSITE_CA_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(WebsiteCaSummary::websiteCaId)).setter(setter(Builder::websiteCaId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebsiteCaId").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(WebsiteCaSummary::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(WebsiteCaSummary::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEBSITE_CA_ID_FIELD,
            CREATED_TIME_FIELD, DISPLAY_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String websiteCaId;

    private final Instant createdTime;

    private final String displayName;

    private WebsiteCaSummary(BuilderImpl builder) {
        this.websiteCaId = builder.websiteCaId;
        this.createdTime = builder.createdTime;
        this.displayName = builder.displayName;
    }

    /**
     * <p>
     * A unique identifier for the CA.
     * </p>
     * 
     * @return A unique identifier for the CA.
     */
    public String websiteCaId() {
        return websiteCaId;
    }

    /**
     * <p>
     * The time when the CA was added.
     * </p>
     * 
     * @return The time when the CA was added.
     */
    public Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The name to display.
     * </p>
     * 
     * @return The name to display.
     */
    public String displayName() {
        return displayName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(websiteCaId());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebsiteCaSummary)) {
            return false;
        }
        WebsiteCaSummary other = (WebsiteCaSummary) obj;
        return Objects.equals(websiteCaId(), other.websiteCaId()) && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(displayName(), other.displayName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("WebsiteCaSummary").add("WebsiteCaId", websiteCaId()).add("CreatedTime", createdTime())
                .add("DisplayName", displayName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WebsiteCaId":
            return Optional.ofNullable(clazz.cast(websiteCaId()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WebsiteCaSummary, T> g) {
        return obj -> g.apply((WebsiteCaSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WebsiteCaSummary> {
        /**
         * <p>
         * A unique identifier for the CA.
         * </p>
         * 
         * @param websiteCaId
         *        A unique identifier for the CA.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder websiteCaId(String websiteCaId);

        /**
         * <p>
         * The time when the CA was added.
         * </p>
         * 
         * @param createdTime
         *        The time when the CA was added.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The name to display.
         * </p>
         * 
         * @param displayName
         *        The name to display.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);
    }

    static final class BuilderImpl implements Builder {
        private String websiteCaId;

        private Instant createdTime;

        private String displayName;

        private BuilderImpl() {
        }

        private BuilderImpl(WebsiteCaSummary model) {
            websiteCaId(model.websiteCaId);
            createdTime(model.createdTime);
            displayName(model.displayName);
        }

        public final String getWebsiteCaId() {
            return websiteCaId;
        }

        @Override
        public final Builder websiteCaId(String websiteCaId) {
            this.websiteCaId = websiteCaId;
            return this;
        }

        public final void setWebsiteCaId(String websiteCaId) {
            this.websiteCaId = websiteCaId;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public WebsiteCaSummary build() {
            return new WebsiteCaSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
