/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.worklink.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFleetMetadataResponse extends WorkLinkResponse implements
        ToCopyableBuilder<DescribeFleetMetadataResponse.Builder, DescribeFleetMetadataResponse> {
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeFleetMetadataResponse::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeFleetMetadataResponse::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<String> FLEET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeFleetMetadataResponse::fleetName)).setter(setter(Builder::fleetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetName").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeFleetMetadataResponse::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<Boolean> OPTIMIZE_FOR_END_USER_LOCATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DescribeFleetMetadataResponse::optimizeForEndUserLocation))
            .setter(setter(Builder::optimizeForEndUserLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizeForEndUserLocation").build())
            .build();

    private static final SdkField<String> COMPANY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeFleetMetadataResponse::companyCode)).setter(setter(Builder::companyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompanyCode").build()).build();

    private static final SdkField<String> FLEET_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeFleetMetadataResponse::fleetStatusAsString)).setter(setter(Builder::fleetStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_TIME_FIELD,
            LAST_UPDATED_TIME_FIELD, FLEET_NAME_FIELD, DISPLAY_NAME_FIELD, OPTIMIZE_FOR_END_USER_LOCATION_FIELD,
            COMPANY_CODE_FIELD, FLEET_STATUS_FIELD));

    private final Instant createdTime;

    private final Instant lastUpdatedTime;

    private final String fleetName;

    private final String displayName;

    private final Boolean optimizeForEndUserLocation;

    private final String companyCode;

    private final String fleetStatus;

    private DescribeFleetMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.fleetName = builder.fleetName;
        this.displayName = builder.displayName;
        this.optimizeForEndUserLocation = builder.optimizeForEndUserLocation;
        this.companyCode = builder.companyCode;
        this.fleetStatus = builder.fleetStatus;
    }

    /**
     * <p>
     * The time that the fleet was created.
     * </p>
     * 
     * @return The time that the fleet was created.
     */
    public Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The time that the fleet was last updated.
     * </p>
     * 
     * @return The time that the fleet was last updated.
     */
    public Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The name of the fleet.
     * </p>
     * 
     * @return The name of the fleet.
     */
    public String fleetName() {
        return fleetName;
    }

    /**
     * <p>
     * The name to display.
     * </p>
     * 
     * @return The name to display.
     */
    public String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The option to optimize for better performance by routing traffic through the closest AWS Region to users, which
     * may be outside of your home Region.
     * </p>
     * 
     * @return The option to optimize for better performance by routing traffic through the closest AWS Region to users,
     *         which may be outside of your home Region.
     */
    public Boolean optimizeForEndUserLocation() {
        return optimizeForEndUserLocation;
    }

    /**
     * <p>
     * The identifier used by users to sign in to the Amazon WorkLink app.
     * </p>
     * 
     * @return The identifier used by users to sign in to the Amazon WorkLink app.
     */
    public String companyCode() {
        return companyCode;
    }

    /**
     * <p>
     * The current state of the fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fleetStatus} will
     * return {@link FleetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fleetStatusAsString}.
     * </p>
     * 
     * @return The current state of the fleet.
     * @see FleetStatus
     */
    public FleetStatus fleetStatus() {
        return FleetStatus.fromValue(fleetStatus);
    }

    /**
     * <p>
     * The current state of the fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fleetStatus} will
     * return {@link FleetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fleetStatusAsString}.
     * </p>
     * 
     * @return The current state of the fleet.
     * @see FleetStatus
     */
    public String fleetStatusAsString() {
        return fleetStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(fleetName());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(optimizeForEndUserLocation());
        hashCode = 31 * hashCode + Objects.hashCode(companyCode());
        hashCode = 31 * hashCode + Objects.hashCode(fleetStatusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetMetadataResponse)) {
            return false;
        }
        DescribeFleetMetadataResponse other = (DescribeFleetMetadataResponse) obj;
        return Objects.equals(createdTime(), other.createdTime()) && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(fleetName(), other.fleetName()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(optimizeForEndUserLocation(), other.optimizeForEndUserLocation())
                && Objects.equals(companyCode(), other.companyCode())
                && Objects.equals(fleetStatusAsString(), other.fleetStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeFleetMetadataResponse").add("CreatedTime", createdTime())
                .add("LastUpdatedTime", lastUpdatedTime()).add("FleetName", fleetName()).add("DisplayName", displayName())
                .add("OptimizeForEndUserLocation", optimizeForEndUserLocation()).add("CompanyCode", companyCode())
                .add("FleetStatus", fleetStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "FleetName":
            return Optional.ofNullable(clazz.cast(fleetName()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "OptimizeForEndUserLocation":
            return Optional.ofNullable(clazz.cast(optimizeForEndUserLocation()));
        case "CompanyCode":
            return Optional.ofNullable(clazz.cast(companyCode()));
        case "FleetStatus":
            return Optional.ofNullable(clazz.cast(fleetStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFleetMetadataResponse, T> g) {
        return obj -> g.apply((DescribeFleetMetadataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkLinkResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeFleetMetadataResponse> {
        /**
         * <p>
         * The time that the fleet was created.
         * </p>
         * 
         * @param createdTime
         *        The time that the fleet was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The time that the fleet was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The time that the fleet was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * The name of the fleet.
         * </p>
         * 
         * @param fleetName
         *        The name of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetName(String fleetName);

        /**
         * <p>
         * The name to display.
         * </p>
         * 
         * @param displayName
         *        The name to display.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The option to optimize for better performance by routing traffic through the closest AWS Region to users,
         * which may be outside of your home Region.
         * </p>
         * 
         * @param optimizeForEndUserLocation
         *        The option to optimize for better performance by routing traffic through the closest AWS Region to
         *        users, which may be outside of your home Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optimizeForEndUserLocation(Boolean optimizeForEndUserLocation);

        /**
         * <p>
         * The identifier used by users to sign in to the Amazon WorkLink app.
         * </p>
         * 
         * @param companyCode
         *        The identifier used by users to sign in to the Amazon WorkLink app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder companyCode(String companyCode);

        /**
         * <p>
         * The current state of the fleet.
         * </p>
         * 
         * @param fleetStatus
         *        The current state of the fleet.
         * @see FleetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetStatus
         */
        Builder fleetStatus(String fleetStatus);

        /**
         * <p>
         * The current state of the fleet.
         * </p>
         * 
         * @param fleetStatus
         *        The current state of the fleet.
         * @see FleetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetStatus
         */
        Builder fleetStatus(FleetStatus fleetStatus);
    }

    static final class BuilderImpl extends WorkLinkResponse.BuilderImpl implements Builder {
        private Instant createdTime;

        private Instant lastUpdatedTime;

        private String fleetName;

        private String displayName;

        private Boolean optimizeForEndUserLocation;

        private String companyCode;

        private String fleetStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetMetadataResponse model) {
            super(model);
            createdTime(model.createdTime);
            lastUpdatedTime(model.lastUpdatedTime);
            fleetName(model.fleetName);
            displayName(model.displayName);
            optimizeForEndUserLocation(model.optimizeForEndUserLocation);
            companyCode(model.companyCode);
            fleetStatus(model.fleetStatus);
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        public final String getFleetName() {
            return fleetName;
        }

        @Override
        public final Builder fleetName(String fleetName) {
            this.fleetName = fleetName;
            return this;
        }

        public final void setFleetName(String fleetName) {
            this.fleetName = fleetName;
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final Boolean getOptimizeForEndUserLocation() {
            return optimizeForEndUserLocation;
        }

        @Override
        public final Builder optimizeForEndUserLocation(Boolean optimizeForEndUserLocation) {
            this.optimizeForEndUserLocation = optimizeForEndUserLocation;
            return this;
        }

        public final void setOptimizeForEndUserLocation(Boolean optimizeForEndUserLocation) {
            this.optimizeForEndUserLocation = optimizeForEndUserLocation;
        }

        public final String getCompanyCode() {
            return companyCode;
        }

        @Override
        public final Builder companyCode(String companyCode) {
            this.companyCode = companyCode;
            return this;
        }

        public final void setCompanyCode(String companyCode) {
            this.companyCode = companyCode;
        }

        public final String getFleetStatusAsString() {
            return fleetStatus;
        }

        @Override
        public final Builder fleetStatus(String fleetStatus) {
            this.fleetStatus = fleetStatus;
            return this;
        }

        @Override
        public final Builder fleetStatus(FleetStatus fleetStatus) {
            this.fleetStatus(fleetStatus == null ? null : fleetStatus.toString());
            return this;
        }

        public final void setFleetStatus(String fleetStatus) {
            this.fleetStatus = fleetStatus;
        }

        @Override
        public DescribeFleetMetadataResponse build() {
            return new DescribeFleetMetadataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
