/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class DocumentSourceUrlMapCopier {
    static Map<String, String> copy(Map<String, String> documentSourceUrlMapParam) {
        Map<String, String> map;
        if (documentSourceUrlMapParam == null || documentSourceUrlMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, String> modifiableMap = new LinkedHashMap<>();
            documentSourceUrlMapParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, String> copyEnumToString(Map<DocumentSourceType, String> documentSourceUrlMapParam) {
        Map<String, String> map;
        if (documentSourceUrlMapParam == null || documentSourceUrlMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, String> modifiableMap = new LinkedHashMap<>();
            documentSourceUrlMapParam.forEach((key, value) -> {
                String result = key.toString();
                modifiableMap.put(result, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<DocumentSourceType, String> copyStringToEnum(Map<String, String> documentSourceUrlMapParam) {
        Map<DocumentSourceType, String> map;
        if (documentSourceUrlMapParam == null || documentSourceUrlMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<DocumentSourceType, String> modifiableMap = new LinkedHashMap<>();
            documentSourceUrlMapParam.forEach((key, value) -> {
                DocumentSourceType result = DocumentSourceType.fromValue(key);
                if (result != DocumentSourceType.UNKNOWN_TO_SDK_VERSION) {
                    modifiableMap.put(result, value);
                }
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
