/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workdocs.model.NotificationOptions;
import software.amazon.awssdk.services.workdocs.model.SharePrincipal;
import software.amazon.awssdk.services.workdocs.model.SharePrincipalListCopier;
import software.amazon.awssdk.services.workdocs.model.WorkDocsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddResourcePermissionsRequest
extends WorkDocsRequest
implements ToCopyableBuilder<Builder, AddResourcePermissionsRequest> {
    private static final SdkField<String> AUTHENTICATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationToken").getter(AddResourcePermissionsRequest.getter(AddResourcePermissionsRequest::authenticationToken)).setter(AddResourcePermissionsRequest.setter(Builder::authenticationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Authentication").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(AddResourcePermissionsRequest.getter(AddResourcePermissionsRequest::resourceId)).setter(AddResourcePermissionsRequest.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ResourceId").build()}).build();
    private static final SdkField<List<SharePrincipal>> PRINCIPALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Principals").getter(AddResourcePermissionsRequest.getter(AddResourcePermissionsRequest::principals)).setter(AddResourcePermissionsRequest.setter(Builder::principals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Principals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SharePrincipal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<NotificationOptions> NOTIFICATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NotificationOptions").getter(AddResourcePermissionsRequest.getter(AddResourcePermissionsRequest::notificationOptions)).setter(AddResourcePermissionsRequest.setter(Builder::notificationOptions)).constructor(NotificationOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TOKEN_FIELD, RESOURCE_ID_FIELD, PRINCIPALS_FIELD, NOTIFICATION_OPTIONS_FIELD));
    private final String authenticationToken;
    private final String resourceId;
    private final List<SharePrincipal> principals;
    private final NotificationOptions notificationOptions;

    private AddResourcePermissionsRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.resourceId = builder.resourceId;
        this.principals = builder.principals;
        this.notificationOptions = builder.notificationOptions;
    }

    public final String authenticationToken() {
        return this.authenticationToken;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final boolean hasPrincipals() {
        return this.principals != null && !(this.principals instanceof SdkAutoConstructList);
    }

    public final List<SharePrincipal> principals() {
        return this.principals;
    }

    public final NotificationOptions notificationOptions() {
        return this.notificationOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrincipals() ? this.principals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddResourcePermissionsRequest)) {
            return false;
        }
        AddResourcePermissionsRequest other = (AddResourcePermissionsRequest)((Object)obj);
        return Objects.equals(this.authenticationToken(), other.authenticationToken()) && Objects.equals(this.resourceId(), other.resourceId()) && this.hasPrincipals() == other.hasPrincipals() && Objects.equals(this.principals(), other.principals()) && Objects.equals(this.notificationOptions(), other.notificationOptions());
    }

    public final String toString() {
        return ToString.builder((String)"AddResourcePermissionsRequest").add("AuthenticationToken", (Object)(this.authenticationToken() == null ? null : "*** Sensitive Data Redacted ***")).add("ResourceId", (Object)this.resourceId()).add("Principals", this.hasPrincipals() ? this.principals() : null).add("NotificationOptions", (Object)this.notificationOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationToken": {
                return Optional.ofNullable(clazz.cast(this.authenticationToken()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "Principals": {
                return Optional.ofNullable(clazz.cast(this.principals()));
            }
            case "NotificationOptions": {
                return Optional.ofNullable(clazz.cast(this.notificationOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddResourcePermissionsRequest, T> g) {
        return obj -> g.apply((AddResourcePermissionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkDocsRequest.BuilderImpl
    implements Builder {
        private String authenticationToken;
        private String resourceId;
        private List<SharePrincipal> principals = DefaultSdkAutoConstructList.getInstance();
        private NotificationOptions notificationOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(AddResourcePermissionsRequest model) {
            super(model);
            this.authenticationToken(model.authenticationToken);
            this.resourceId(model.resourceId);
            this.principals(model.principals);
            this.notificationOptions(model.notificationOptions);
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        @Override
        @Transient
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        @Transient
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final List<SharePrincipal.Builder> getPrincipals() {
            List<SharePrincipal.Builder> result = SharePrincipalListCopier.copyToBuilder(this.principals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrincipals(Collection<SharePrincipal.BuilderImpl> principals) {
            this.principals = SharePrincipalListCopier.copyFromBuilder(principals);
        }

        @Override
        @Transient
        public final Builder principals(Collection<SharePrincipal> principals) {
            this.principals = SharePrincipalListCopier.copy(principals);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder principals(SharePrincipal ... principals) {
            this.principals(Arrays.asList(principals));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder principals(Consumer<SharePrincipal.Builder> ... principals) {
            this.principals(Stream.of(principals).map(c -> (SharePrincipal)((SharePrincipal.Builder)SharePrincipal.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final NotificationOptions.Builder getNotificationOptions() {
            return this.notificationOptions != null ? this.notificationOptions.toBuilder() : null;
        }

        public final void setNotificationOptions(NotificationOptions.BuilderImpl notificationOptions) {
            this.notificationOptions = notificationOptions != null ? notificationOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder notificationOptions(NotificationOptions notificationOptions) {
            this.notificationOptions = notificationOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddResourcePermissionsRequest build() {
            return new AddResourcePermissionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkDocsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddResourcePermissionsRequest> {
        public Builder authenticationToken(String var1);

        public Builder resourceId(String var1);

        public Builder principals(Collection<SharePrincipal> var1);

        public Builder principals(SharePrincipal ... var1);

        public Builder principals(Consumer<SharePrincipal.Builder> ... var1);

        public Builder notificationOptions(NotificationOptions var1);

        default public Builder notificationOptions(Consumer<NotificationOptions.Builder> notificationOptions) {
            return this.notificationOptions((NotificationOptions)((NotificationOptions.Builder)NotificationOptions.builder().applyMutation(notificationOptions)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

