/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workdocs.model.StorageType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StorageRuleType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StorageRuleType> {
    private static final SdkField<Long> STORAGE_ALLOCATED_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("StorageAllocatedInBytes").getter(StorageRuleType.getter(StorageRuleType::storageAllocatedInBytes)).setter(StorageRuleType.setter(Builder::storageAllocatedInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageAllocatedInBytes").build()}).build();
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageType").getter(StorageRuleType.getter(StorageRuleType::storageTypeAsString)).setter(StorageRuleType.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_ALLOCATED_IN_BYTES_FIELD, STORAGE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long storageAllocatedInBytes;
    private final String storageType;

    private StorageRuleType(BuilderImpl builder) {
        this.storageAllocatedInBytes = builder.storageAllocatedInBytes;
        this.storageType = builder.storageType;
    }

    public Long storageAllocatedInBytes() {
        return this.storageAllocatedInBytes;
    }

    public StorageType storageType() {
        return StorageType.fromValue(this.storageType);
    }

    public String storageTypeAsString() {
        return this.storageType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.storageAllocatedInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageRuleType)) {
            return false;
        }
        StorageRuleType other = (StorageRuleType)obj;
        return Objects.equals(this.storageAllocatedInBytes(), other.storageAllocatedInBytes()) && Objects.equals(this.storageTypeAsString(), other.storageTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"StorageRuleType").add("StorageAllocatedInBytes", (Object)this.storageAllocatedInBytes()).add("StorageType", (Object)this.storageTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StorageAllocatedInBytes": {
                return Optional.ofNullable(clazz.cast(this.storageAllocatedInBytes()));
            }
            case "StorageType": {
                return Optional.ofNullable(clazz.cast(this.storageTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StorageRuleType, T> g) {
        return obj -> g.apply((StorageRuleType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long storageAllocatedInBytes;
        private String storageType;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageRuleType model) {
            this.storageAllocatedInBytes(model.storageAllocatedInBytes);
            this.storageType(model.storageType);
        }

        public final Long getStorageAllocatedInBytes() {
            return this.storageAllocatedInBytes;
        }

        @Override
        public final Builder storageAllocatedInBytes(Long storageAllocatedInBytes) {
            this.storageAllocatedInBytes = storageAllocatedInBytes;
            return this;
        }

        public final void setStorageAllocatedInBytes(Long storageAllocatedInBytes) {
            this.storageAllocatedInBytes = storageAllocatedInBytes;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        @Override
        public final Builder storageType(StorageType storageType) {
            this.storageType(storageType == null ? null : storageType.toString());
            return this;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        public StorageRuleType build() {
            return new StorageRuleType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StorageRuleType> {
        public Builder storageAllocatedInBytes(Long var1);

        public Builder storageType(String var1);

        public Builder storageType(StorageType var1);
    }
}

