/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workdocs.model.RoleType;
import software.amazon.awssdk.services.workdocs.model.ShareStatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ShareResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ShareResult> {
    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ShareResult.getter(ShareResult::principalId)).setter(ShareResult.setter(Builder::principalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalId").build()}).build();
    private static final SdkField<String> INVITEE_PRINCIPAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ShareResult.getter(ShareResult::inviteePrincipalId)).setter(ShareResult.setter(Builder::inviteePrincipalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InviteePrincipalId").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ShareResult.getter(ShareResult::roleAsString)).setter(ShareResult.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ShareResult.getter(ShareResult::statusAsString)).setter(ShareResult.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> SHARE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ShareResult.getter(ShareResult::shareId)).setter(ShareResult.setter(Builder::shareId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareId").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ShareResult.getter(ShareResult::statusMessage)).setter(ShareResult.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRINCIPAL_ID_FIELD, INVITEE_PRINCIPAL_ID_FIELD, ROLE_FIELD, STATUS_FIELD, SHARE_ID_FIELD, STATUS_MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String principalId;
    private final String inviteePrincipalId;
    private final String role;
    private final String status;
    private final String shareId;
    private final String statusMessage;

    private ShareResult(BuilderImpl builder) {
        this.principalId = builder.principalId;
        this.inviteePrincipalId = builder.inviteePrincipalId;
        this.role = builder.role;
        this.status = builder.status;
        this.shareId = builder.shareId;
        this.statusMessage = builder.statusMessage;
    }

    public String principalId() {
        return this.principalId;
    }

    public String inviteePrincipalId() {
        return this.inviteePrincipalId;
    }

    public RoleType role() {
        return RoleType.fromValue(this.role);
    }

    public String roleAsString() {
        return this.role;
    }

    public ShareStatusType status() {
        return ShareStatusType.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String shareId() {
        return this.shareId;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.principalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.inviteePrincipalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShareResult)) {
            return false;
        }
        ShareResult other = (ShareResult)obj;
        return Objects.equals(this.principalId(), other.principalId()) && Objects.equals(this.inviteePrincipalId(), other.inviteePrincipalId()) && Objects.equals(this.roleAsString(), other.roleAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.shareId(), other.shareId()) && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public String toString() {
        return ToString.builder((String)"ShareResult").add("PrincipalId", (Object)this.principalId()).add("InviteePrincipalId", (Object)this.inviteePrincipalId()).add("Role", (Object)this.roleAsString()).add("Status", (Object)this.statusAsString()).add("ShareId", (Object)this.shareId()).add("StatusMessage", (Object)(this.statusMessage() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PrincipalId": {
                return Optional.ofNullable(clazz.cast(this.principalId()));
            }
            case "InviteePrincipalId": {
                return Optional.ofNullable(clazz.cast(this.inviteePrincipalId()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.roleAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ShareId": {
                return Optional.ofNullable(clazz.cast(this.shareId()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ShareResult, T> g) {
        return obj -> g.apply((ShareResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String principalId;
        private String inviteePrincipalId;
        private String role;
        private String status;
        private String shareId;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ShareResult model) {
            this.principalId(model.principalId);
            this.inviteePrincipalId(model.inviteePrincipalId);
            this.role(model.role);
            this.status(model.status);
            this.shareId(model.shareId);
            this.statusMessage(model.statusMessage);
        }

        public final String getPrincipalId() {
            return this.principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        public final String getInviteePrincipalId() {
            return this.inviteePrincipalId;
        }

        @Override
        public final Builder inviteePrincipalId(String inviteePrincipalId) {
            this.inviteePrincipalId = inviteePrincipalId;
            return this;
        }

        public final void setInviteePrincipalId(String inviteePrincipalId) {
            this.inviteePrincipalId = inviteePrincipalId;
        }

        public final String getRole() {
            return this.role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(RoleType role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ShareStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getShareId() {
            return this.shareId;
        }

        @Override
        public final Builder shareId(String shareId) {
            this.shareId = shareId;
            return this;
        }

        public final void setShareId(String shareId) {
            this.shareId = shareId;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public ShareResult build() {
            return new ShareResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ShareResult> {
        public Builder principalId(String var1);

        public Builder inviteePrincipalId(String var1);

        public Builder role(String var1);

        public Builder role(RoleType var1);

        public Builder status(String var1);

        public Builder status(ShareStatusType var1);

        public Builder shareId(String var1);

        public Builder statusMessage(String var1);
    }
}

