/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the activity information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Activity implements SdkPojo, Serializable, ToCopyableBuilder<Activity.Builder, Activity> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Activity::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Instant> TIME_STAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Activity::timeStamp)).setter(setter(Builder::timeStamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeStamp").build()).build();

    private static final SdkField<Boolean> IS_INDIRECT_ACTIVITY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Activity::isIndirectActivity)).setter(setter(Builder::isIndirectActivity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsIndirectActivity").build())
            .build();

    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Activity::organizationId)).setter(setter(Builder::organizationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()).build();

    private static final SdkField<UserMetadata> INITIATOR_FIELD = SdkField.<UserMetadata> builder(MarshallingType.SDK_POJO)
            .getter(getter(Activity::initiator)).setter(setter(Builder::initiator)).constructor(UserMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Initiator").build()).build();

    private static final SdkField<Participants> PARTICIPANTS_FIELD = SdkField.<Participants> builder(MarshallingType.SDK_POJO)
            .getter(getter(Activity::participants)).setter(setter(Builder::participants)).constructor(Participants::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Participants").build()).build();

    private static final SdkField<ResourceMetadata> RESOURCE_METADATA_FIELD = SdkField
            .<ResourceMetadata> builder(MarshallingType.SDK_POJO).getter(getter(Activity::resourceMetadata))
            .setter(setter(Builder::resourceMetadata)).constructor(ResourceMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceMetadata").build()).build();

    private static final SdkField<ResourceMetadata> ORIGINAL_PARENT_FIELD = SdkField
            .<ResourceMetadata> builder(MarshallingType.SDK_POJO).getter(getter(Activity::originalParent))
            .setter(setter(Builder::originalParent)).constructor(ResourceMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalParent").build()).build();

    private static final SdkField<CommentMetadata> COMMENT_METADATA_FIELD = SdkField
            .<CommentMetadata> builder(MarshallingType.SDK_POJO).getter(getter(Activity::commentMetadata))
            .setter(setter(Builder::commentMetadata)).constructor(CommentMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommentMetadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, TIME_STAMP_FIELD,
            IS_INDIRECT_ACTIVITY_FIELD, ORGANIZATION_ID_FIELD, INITIATOR_FIELD, PARTICIPANTS_FIELD, RESOURCE_METADATA_FIELD,
            ORIGINAL_PARENT_FIELD, COMMENT_METADATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final Instant timeStamp;

    private final Boolean isIndirectActivity;

    private final String organizationId;

    private final UserMetadata initiator;

    private final Participants participants;

    private final ResourceMetadata resourceMetadata;

    private final ResourceMetadata originalParent;

    private final CommentMetadata commentMetadata;

    private Activity(BuilderImpl builder) {
        this.type = builder.type;
        this.timeStamp = builder.timeStamp;
        this.isIndirectActivity = builder.isIndirectActivity;
        this.organizationId = builder.organizationId;
        this.initiator = builder.initiator;
        this.participants = builder.participants;
        this.resourceMetadata = builder.resourceMetadata;
        this.originalParent = builder.originalParent;
        this.commentMetadata = builder.commentMetadata;
    }

    /**
     * <p>
     * The activity type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ActivityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The activity type.
     * @see ActivityType
     */
    public ActivityType type() {
        return ActivityType.fromValue(type);
    }

    /**
     * <p>
     * The activity type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ActivityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The activity type.
     * @see ActivityType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The timestamp when the action was performed.
     * </p>
     * 
     * @return The timestamp when the action was performed.
     */
    public Instant timeStamp() {
        return timeStamp;
    }

    /**
     * <p>
     * Indicates whether an activity is indirect or direct. An indirect activity results from a direct activity
     * performed on a parent resource. For example, sharing a parent folder (the direct activity) shares all of the
     * subfolders and documents within the parent folder (the indirect activity).
     * </p>
     * 
     * @return Indicates whether an activity is indirect or direct. An indirect activity results from a direct activity
     *         performed on a parent resource. For example, sharing a parent folder (the direct activity) shares all of
     *         the subfolders and documents within the parent folder (the indirect activity).
     */
    public Boolean isIndirectActivity() {
        return isIndirectActivity;
    }

    /**
     * <p>
     * The ID of the organization.
     * </p>
     * 
     * @return The ID of the organization.
     */
    public String organizationId() {
        return organizationId;
    }

    /**
     * <p>
     * The user who performed the action.
     * </p>
     * 
     * @return The user who performed the action.
     */
    public UserMetadata initiator() {
        return initiator;
    }

    /**
     * <p>
     * The list of users or groups impacted by this action. This is an optional field and is filled for the following
     * sharing activities: DOCUMENT_SHARED, DOCUMENT_SHARED, DOCUMENT_UNSHARED, FOLDER_SHARED, FOLDER_UNSHARED.
     * </p>
     * 
     * @return The list of users or groups impacted by this action. This is an optional field and is filled for the
     *         following sharing activities: DOCUMENT_SHARED, DOCUMENT_SHARED, DOCUMENT_UNSHARED, FOLDER_SHARED,
     *         FOLDER_UNSHARED.
     */
    public Participants participants() {
        return participants;
    }

    /**
     * <p>
     * The metadata of the resource involved in the user action.
     * </p>
     * 
     * @return The metadata of the resource involved in the user action.
     */
    public ResourceMetadata resourceMetadata() {
        return resourceMetadata;
    }

    /**
     * <p>
     * The original parent of the resource. This is an optional field and is filled for move activities.
     * </p>
     * 
     * @return The original parent of the resource. This is an optional field and is filled for move activities.
     */
    public ResourceMetadata originalParent() {
        return originalParent;
    }

    /**
     * <p>
     * Metadata of the commenting activity. This is an optional field and is filled for commenting activities.
     * </p>
     * 
     * @return Metadata of the commenting activity. This is an optional field and is filled for commenting activities.
     */
    public CommentMetadata commentMetadata() {
        return commentMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(isIndirectActivity());
        hashCode = 31 * hashCode + Objects.hashCode(organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(initiator());
        hashCode = 31 * hashCode + Objects.hashCode(participants());
        hashCode = 31 * hashCode + Objects.hashCode(resourceMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(originalParent());
        hashCode = 31 * hashCode + Objects.hashCode(commentMetadata());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Activity)) {
            return false;
        }
        Activity other = (Activity) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(timeStamp(), other.timeStamp())
                && Objects.equals(isIndirectActivity(), other.isIndirectActivity())
                && Objects.equals(organizationId(), other.organizationId()) && Objects.equals(initiator(), other.initiator())
                && Objects.equals(participants(), other.participants())
                && Objects.equals(resourceMetadata(), other.resourceMetadata())
                && Objects.equals(originalParent(), other.originalParent())
                && Objects.equals(commentMetadata(), other.commentMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Activity").add("Type", typeAsString()).add("TimeStamp", timeStamp())
                .add("IsIndirectActivity", isIndirectActivity()).add("OrganizationId", organizationId())
                .add("Initiator", initiator()).add("Participants", participants()).add("ResourceMetadata", resourceMetadata())
                .add("OriginalParent", originalParent()).add("CommentMetadata", commentMetadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "TimeStamp":
            return Optional.ofNullable(clazz.cast(timeStamp()));
        case "IsIndirectActivity":
            return Optional.ofNullable(clazz.cast(isIndirectActivity()));
        case "OrganizationId":
            return Optional.ofNullable(clazz.cast(organizationId()));
        case "Initiator":
            return Optional.ofNullable(clazz.cast(initiator()));
        case "Participants":
            return Optional.ofNullable(clazz.cast(participants()));
        case "ResourceMetadata":
            return Optional.ofNullable(clazz.cast(resourceMetadata()));
        case "OriginalParent":
            return Optional.ofNullable(clazz.cast(originalParent()));
        case "CommentMetadata":
            return Optional.ofNullable(clazz.cast(commentMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Activity, T> g) {
        return obj -> g.apply((Activity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Activity> {
        /**
         * <p>
         * The activity type.
         * </p>
         * 
         * @param type
         *        The activity type.
         * @see ActivityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActivityType
         */
        Builder type(String type);

        /**
         * <p>
         * The activity type.
         * </p>
         * 
         * @param type
         *        The activity type.
         * @see ActivityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActivityType
         */
        Builder type(ActivityType type);

        /**
         * <p>
         * The timestamp when the action was performed.
         * </p>
         * 
         * @param timeStamp
         *        The timestamp when the action was performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeStamp(Instant timeStamp);

        /**
         * <p>
         * Indicates whether an activity is indirect or direct. An indirect activity results from a direct activity
         * performed on a parent resource. For example, sharing a parent folder (the direct activity) shares all of the
         * subfolders and documents within the parent folder (the indirect activity).
         * </p>
         * 
         * @param isIndirectActivity
         *        Indicates whether an activity is indirect or direct. An indirect activity results from a direct
         *        activity performed on a parent resource. For example, sharing a parent folder (the direct activity)
         *        shares all of the subfolders and documents within the parent folder (the indirect activity).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isIndirectActivity(Boolean isIndirectActivity);

        /**
         * <p>
         * The ID of the organization.
         * </p>
         * 
         * @param organizationId
         *        The ID of the organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationId(String organizationId);

        /**
         * <p>
         * The user who performed the action.
         * </p>
         * 
         * @param initiator
         *        The user who performed the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initiator(UserMetadata initiator);

        /**
         * <p>
         * The user who performed the action.
         * </p>
         * This is a convenience that creates an instance of the {@link UserMetadata.Builder} avoiding the need to
         * create one manually via {@link UserMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #initiator(UserMetadata)}.
         * 
         * @param initiator
         *        a consumer that will call methods on {@link UserMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #initiator(UserMetadata)
         */
        default Builder initiator(Consumer<UserMetadata.Builder> initiator) {
            return initiator(UserMetadata.builder().applyMutation(initiator).build());
        }

        /**
         * <p>
         * The list of users or groups impacted by this action. This is an optional field and is filled for the
         * following sharing activities: DOCUMENT_SHARED, DOCUMENT_SHARED, DOCUMENT_UNSHARED, FOLDER_SHARED,
         * FOLDER_UNSHARED.
         * </p>
         * 
         * @param participants
         *        The list of users or groups impacted by this action. This is an optional field and is filled for the
         *        following sharing activities: DOCUMENT_SHARED, DOCUMENT_SHARED, DOCUMENT_UNSHARED, FOLDER_SHARED,
         *        FOLDER_UNSHARED.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participants(Participants participants);

        /**
         * <p>
         * The list of users or groups impacted by this action. This is an optional field and is filled for the
         * following sharing activities: DOCUMENT_SHARED, DOCUMENT_SHARED, DOCUMENT_UNSHARED, FOLDER_SHARED,
         * FOLDER_UNSHARED.
         * </p>
         * This is a convenience that creates an instance of the {@link Participants.Builder} avoiding the need to
         * create one manually via {@link Participants#builder()}.
         *
         * When the {@link Consumer} completes, {@link Participants.Builder#build()} is called immediately and its
         * result is passed to {@link #participants(Participants)}.
         * 
         * @param participants
         *        a consumer that will call methods on {@link Participants.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #participants(Participants)
         */
        default Builder participants(Consumer<Participants.Builder> participants) {
            return participants(Participants.builder().applyMutation(participants).build());
        }

        /**
         * <p>
         * The metadata of the resource involved in the user action.
         * </p>
         * 
         * @param resourceMetadata
         *        The metadata of the resource involved in the user action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceMetadata(ResourceMetadata resourceMetadata);

        /**
         * <p>
         * The metadata of the resource involved in the user action.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceMetadata.Builder} avoiding the need to
         * create one manually via {@link ResourceMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceMetadata(ResourceMetadata)}.
         * 
         * @param resourceMetadata
         *        a consumer that will call methods on {@link ResourceMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceMetadata(ResourceMetadata)
         */
        default Builder resourceMetadata(Consumer<ResourceMetadata.Builder> resourceMetadata) {
            return resourceMetadata(ResourceMetadata.builder().applyMutation(resourceMetadata).build());
        }

        /**
         * <p>
         * The original parent of the resource. This is an optional field and is filled for move activities.
         * </p>
         * 
         * @param originalParent
         *        The original parent of the resource. This is an optional field and is filled for move activities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originalParent(ResourceMetadata originalParent);

        /**
         * <p>
         * The original parent of the resource. This is an optional field and is filled for move activities.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceMetadata.Builder} avoiding the need to
         * create one manually via {@link ResourceMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #originalParent(ResourceMetadata)}.
         * 
         * @param originalParent
         *        a consumer that will call methods on {@link ResourceMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #originalParent(ResourceMetadata)
         */
        default Builder originalParent(Consumer<ResourceMetadata.Builder> originalParent) {
            return originalParent(ResourceMetadata.builder().applyMutation(originalParent).build());
        }

        /**
         * <p>
         * Metadata of the commenting activity. This is an optional field and is filled for commenting activities.
         * </p>
         * 
         * @param commentMetadata
         *        Metadata of the commenting activity. This is an optional field and is filled for commenting
         *        activities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commentMetadata(CommentMetadata commentMetadata);

        /**
         * <p>
         * Metadata of the commenting activity. This is an optional field and is filled for commenting activities.
         * </p>
         * This is a convenience that creates an instance of the {@link CommentMetadata.Builder} avoiding the need to
         * create one manually via {@link CommentMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link CommentMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #commentMetadata(CommentMetadata)}.
         * 
         * @param commentMetadata
         *        a consumer that will call methods on {@link CommentMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #commentMetadata(CommentMetadata)
         */
        default Builder commentMetadata(Consumer<CommentMetadata.Builder> commentMetadata) {
            return commentMetadata(CommentMetadata.builder().applyMutation(commentMetadata).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private Instant timeStamp;

        private Boolean isIndirectActivity;

        private String organizationId;

        private UserMetadata initiator;

        private Participants participants;

        private ResourceMetadata resourceMetadata;

        private ResourceMetadata originalParent;

        private CommentMetadata commentMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(Activity model) {
            type(model.type);
            timeStamp(model.timeStamp);
            isIndirectActivity(model.isIndirectActivity);
            organizationId(model.organizationId);
            initiator(model.initiator);
            participants(model.participants);
            resourceMetadata(model.resourceMetadata);
            originalParent(model.originalParent);
            commentMetadata(model.commentMetadata);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ActivityType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Instant getTimeStamp() {
            return timeStamp;
        }

        @Override
        public final Builder timeStamp(Instant timeStamp) {
            this.timeStamp = timeStamp;
            return this;
        }

        public final void setTimeStamp(Instant timeStamp) {
            this.timeStamp = timeStamp;
        }

        public final Boolean getIsIndirectActivity() {
            return isIndirectActivity;
        }

        @Override
        public final Builder isIndirectActivity(Boolean isIndirectActivity) {
            this.isIndirectActivity = isIndirectActivity;
            return this;
        }

        public final void setIsIndirectActivity(Boolean isIndirectActivity) {
            this.isIndirectActivity = isIndirectActivity;
        }

        public final String getOrganizationId() {
            return organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        public final UserMetadata.Builder getInitiator() {
            return initiator != null ? initiator.toBuilder() : null;
        }

        @Override
        public final Builder initiator(UserMetadata initiator) {
            this.initiator = initiator;
            return this;
        }

        public final void setInitiator(UserMetadata.BuilderImpl initiator) {
            this.initiator = initiator != null ? initiator.build() : null;
        }

        public final Participants.Builder getParticipants() {
            return participants != null ? participants.toBuilder() : null;
        }

        @Override
        public final Builder participants(Participants participants) {
            this.participants = participants;
            return this;
        }

        public final void setParticipants(Participants.BuilderImpl participants) {
            this.participants = participants != null ? participants.build() : null;
        }

        public final ResourceMetadata.Builder getResourceMetadata() {
            return resourceMetadata != null ? resourceMetadata.toBuilder() : null;
        }

        @Override
        public final Builder resourceMetadata(ResourceMetadata resourceMetadata) {
            this.resourceMetadata = resourceMetadata;
            return this;
        }

        public final void setResourceMetadata(ResourceMetadata.BuilderImpl resourceMetadata) {
            this.resourceMetadata = resourceMetadata != null ? resourceMetadata.build() : null;
        }

        public final ResourceMetadata.Builder getOriginalParent() {
            return originalParent != null ? originalParent.toBuilder() : null;
        }

        @Override
        public final Builder originalParent(ResourceMetadata originalParent) {
            this.originalParent = originalParent;
            return this;
        }

        public final void setOriginalParent(ResourceMetadata.BuilderImpl originalParent) {
            this.originalParent = originalParent != null ? originalParent.build() : null;
        }

        public final CommentMetadata.Builder getCommentMetadata() {
            return commentMetadata != null ? commentMetadata.toBuilder() : null;
        }

        @Override
        public final Builder commentMetadata(CommentMetadata commentMetadata) {
            this.commentMetadata = commentMetadata;
            return this;
        }

        public final void setCommentMetadata(CommentMetadata.BuilderImpl commentMetadata) {
            this.commentMetadata = commentMetadata != null ? commentMetadata.build() : null;
        }

        @Override
        public Activity build() {
            return new Activity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
