/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDocumentVersionResponse extends WorkDocsResponse implements
        ToCopyableBuilder<GetDocumentVersionResponse.Builder, GetDocumentVersionResponse> {
    private static final SdkField<DocumentVersionMetadata> METADATA_FIELD = SdkField
            .<DocumentVersionMetadata> builder(MarshallingType.SDK_POJO).getter(getter(GetDocumentVersionResponse::metadata))
            .setter(setter(Builder::metadata)).constructor(DocumentVersionMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()).build();

    private static final SdkField<Map<String, String>> CUSTOM_METADATA_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(GetDocumentVersionResponse::customMetadata))
            .setter(setter(Builder::customMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomMetadata").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_FIELD,
            CUSTOM_METADATA_FIELD));

    private final DocumentVersionMetadata metadata;

    private final Map<String, String> customMetadata;

    private GetDocumentVersionResponse(BuilderImpl builder) {
        super(builder);
        this.metadata = builder.metadata;
        this.customMetadata = builder.customMetadata;
    }

    /**
     * <p>
     * The version metadata.
     * </p>
     * 
     * @return The version metadata.
     */
    public DocumentVersionMetadata metadata() {
        return metadata;
    }

    /**
     * Returns true if the CustomMetadata property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasCustomMetadata() {
        return customMetadata != null && !(customMetadata instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The custom metadata on the document version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCustomMetadata()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The custom metadata on the document version.
     */
    public Map<String, String> customMetadata() {
        return customMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(customMetadata());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDocumentVersionResponse)) {
            return false;
        }
        GetDocumentVersionResponse other = (GetDocumentVersionResponse) obj;
        return Objects.equals(metadata(), other.metadata()) && Objects.equals(customMetadata(), other.customMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetDocumentVersionResponse").add("Metadata", metadata()).add("CustomMetadata", customMetadata())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "CustomMetadata":
            return Optional.ofNullable(clazz.cast(customMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDocumentVersionResponse, T> g) {
        return obj -> g.apply((GetDocumentVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkDocsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDocumentVersionResponse> {
        /**
         * <p>
         * The version metadata.
         * </p>
         * 
         * @param metadata
         *        The version metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(DocumentVersionMetadata metadata);

        /**
         * <p>
         * The version metadata.
         * </p>
         * This is a convenience that creates an instance of the {@link DocumentVersionMetadata.Builder} avoiding the
         * need to create one manually via {@link DocumentVersionMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link DocumentVersionMetadata.Builder#build()} is called immediately
         * and its result is passed to {@link #metadata(DocumentVersionMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link DocumentVersionMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(DocumentVersionMetadata)
         */
        default Builder metadata(Consumer<DocumentVersionMetadata.Builder> metadata) {
            return metadata(DocumentVersionMetadata.builder().applyMutation(metadata).build());
        }

        /**
         * <p>
         * The custom metadata on the document version.
         * </p>
         * 
         * @param customMetadata
         *        The custom metadata on the document version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customMetadata(Map<String, String> customMetadata);
    }

    static final class BuilderImpl extends WorkDocsResponse.BuilderImpl implements Builder {
        private DocumentVersionMetadata metadata;

        private Map<String, String> customMetadata = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDocumentVersionResponse model) {
            super(model);
            metadata(model.metadata);
            customMetadata(model.customMetadata);
        }

        public final DocumentVersionMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        @Override
        public final Builder metadata(DocumentVersionMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(DocumentVersionMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        public final Map<String, String> getCustomMetadata() {
            return customMetadata;
        }

        @Override
        public final Builder customMetadata(Map<String, String> customMetadata) {
            this.customMetadata = CustomMetadataMapCopier.copy(customMetadata);
            return this;
        }

        public final void setCustomMetadata(Map<String, String> customMetadata) {
            this.customMetadata = CustomMetadataMapCopier.copy(customMetadata);
        }

        @Override
        public GetDocumentVersionResponse build() {
            return new GetDocumentVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
