/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.workdocs.model.StorageRuleType;
import software.amazon.awssdk.services.workdocs.model.WorkDocsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateUserRequest
extends WorkDocsRequest
implements ToCopyableBuilder<Builder, CreateUserRequest> {
    private final String organizationId;
    private final String username;
    private final String emailAddress;
    private final String givenName;
    private final String surname;
    private final String password;
    private final String timeZoneId;
    private final StorageRuleType storageRule;
    private final String authenticationToken;

    private CreateUserRequest(BuilderImpl builder) {
        super(builder);
        this.organizationId = builder.organizationId;
        this.username = builder.username;
        this.emailAddress = builder.emailAddress;
        this.givenName = builder.givenName;
        this.surname = builder.surname;
        this.password = builder.password;
        this.timeZoneId = builder.timeZoneId;
        this.storageRule = builder.storageRule;
        this.authenticationToken = builder.authenticationToken;
    }

    public String organizationId() {
        return this.organizationId;
    }

    public String username() {
        return this.username;
    }

    public String emailAddress() {
        return this.emailAddress;
    }

    public String givenName() {
        return this.givenName;
    }

    public String surname() {
        return this.surname;
    }

    public String password() {
        return this.password;
    }

    public String timeZoneId() {
        return this.timeZoneId;
    }

    public StorageRuleType storageRule() {
        return this.storageRule;
    }

    public String authenticationToken() {
        return this.authenticationToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.givenName());
        hashCode = 31 * hashCode + Objects.hashCode(this.surname());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageRule());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserRequest)) {
            return false;
        }
        CreateUserRequest other = (CreateUserRequest)((Object)obj);
        return Objects.equals(this.organizationId(), other.organizationId()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.emailAddress(), other.emailAddress()) && Objects.equals(this.givenName(), other.givenName()) && Objects.equals(this.surname(), other.surname()) && Objects.equals(this.password(), other.password()) && Objects.equals(this.timeZoneId(), other.timeZoneId()) && Objects.equals(this.storageRule(), other.storageRule()) && Objects.equals(this.authenticationToken(), other.authenticationToken());
    }

    public String toString() {
        return ToString.builder((String)"CreateUserRequest").add("OrganizationId", (Object)this.organizationId()).add("Username", (Object)this.username()).add("EmailAddress", (Object)this.emailAddress()).add("GivenName", (Object)this.givenName()).add("Surname", (Object)this.surname()).add("Password", (Object)this.password()).add("TimeZoneId", (Object)this.timeZoneId()).add("StorageRule", (Object)this.storageRule()).add("AuthenticationToken", (Object)this.authenticationToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationId": {
                return Optional.of(clazz.cast(this.organizationId()));
            }
            case "Username": {
                return Optional.of(clazz.cast(this.username()));
            }
            case "EmailAddress": {
                return Optional.of(clazz.cast(this.emailAddress()));
            }
            case "GivenName": {
                return Optional.of(clazz.cast(this.givenName()));
            }
            case "Surname": {
                return Optional.of(clazz.cast(this.surname()));
            }
            case "Password": {
                return Optional.of(clazz.cast(this.password()));
            }
            case "TimeZoneId": {
                return Optional.of(clazz.cast(this.timeZoneId()));
            }
            case "StorageRule": {
                return Optional.of(clazz.cast(this.storageRule()));
            }
            case "AuthenticationToken": {
                return Optional.of(clazz.cast(this.authenticationToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WorkDocsRequest.BuilderImpl
    implements Builder {
        private String organizationId;
        private String username;
        private String emailAddress;
        private String givenName;
        private String surname;
        private String password;
        private String timeZoneId;
        private StorageRuleType storageRule;
        private String authenticationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserRequest model) {
            this.organizationId(model.organizationId);
            this.username(model.username);
            this.emailAddress(model.emailAddress);
            this.givenName(model.givenName);
            this.surname(model.surname);
            this.password(model.password);
            this.timeZoneId(model.timeZoneId);
            this.storageRule(model.storageRule);
            this.authenticationToken(model.authenticationToken);
        }

        public final String getOrganizationId() {
            return this.organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getEmailAddress() {
            return this.emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        public final String getGivenName() {
            return this.givenName;
        }

        @Override
        public final Builder givenName(String givenName) {
            this.givenName = givenName;
            return this;
        }

        public final void setGivenName(String givenName) {
            this.givenName = givenName;
        }

        public final String getSurname() {
            return this.surname;
        }

        @Override
        public final Builder surname(String surname) {
            this.surname = surname;
            return this;
        }

        public final void setSurname(String surname) {
            this.surname = surname;
        }

        public final String getPassword() {
            return this.password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final String getTimeZoneId() {
            return this.timeZoneId;
        }

        @Override
        public final Builder timeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
            return this;
        }

        public final void setTimeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
        }

        public final StorageRuleType.Builder getStorageRule() {
            return this.storageRule != null ? this.storageRule.toBuilder() : null;
        }

        @Override
        public final Builder storageRule(StorageRuleType storageRule) {
            this.storageRule = storageRule;
            return this;
        }

        public final void setStorageRule(StorageRuleType.BuilderImpl storageRule) {
            this.storageRule = storageRule != null ? storageRule.build() : null;
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateUserRequest build() {
            return new CreateUserRequest(this);
        }
    }

    public static interface Builder
    extends WorkDocsRequest.Builder,
    CopyableBuilder<Builder, CreateUserRequest> {
        public Builder organizationId(String var1);

        public Builder username(String var1);

        public Builder emailAddress(String var1);

        public Builder givenName(String var1);

        public Builder surname(String var1);

        public Builder password(String var1);

        public Builder timeZoneId(String var1);

        public Builder storageRule(StorageRuleType var1);

        default public Builder storageRule(Consumer<StorageRuleType.Builder> storageRule) {
            return this.storageRule((StorageRuleType)((StorageRuleType.Builder)StorageRuleType.builder().apply(storageRule)).build());
        }

        public Builder authenticationToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

