/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.RolePermissionType;
import software.amazon.awssdk.services.workdocs.model.RoleType;
import software.amazon.awssdk.services.workdocs.transform.PermissionInfoMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PermissionInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, PermissionInfo> {
    private final String role;
    private final String type;

    private PermissionInfo(BuilderImpl builder) {
        this.role = builder.role;
        this.type = builder.type;
    }

    public RoleType role() {
        return RoleType.fromValue(this.role);
    }

    public String roleString() {
        return this.role;
    }

    public RolePermissionType type() {
        return RolePermissionType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PermissionInfo)) {
            return false;
        }
        PermissionInfo other = (PermissionInfo)obj;
        return Objects.equals(this.roleString(), other.roleString()) && Objects.equals(this.typeString(), other.typeString());
    }

    public String toString() {
        return ToString.builder((String)"PermissionInfo").add("Role", (Object)this.roleString()).add("Type", (Object)this.typeString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Role": {
                return Optional.of(clazz.cast(this.roleString()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PermissionInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String role;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(PermissionInfo model) {
            this.role(model.role);
            this.type(model.type);
        }

        public final String getRole() {
            return this.role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(RoleType role) {
            this.role(role.toString());
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RolePermissionType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public PermissionInfo build() {
            return new PermissionInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PermissionInfo> {
        public Builder role(String var1);

        public Builder role(RoleType var1);

        public Builder type(String var1);

        public Builder type(RolePermissionType var1);
    }
}

