/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.workdocs.model.DocumentMetadata;
import software.amazon.awssdk.services.workdocs.model.DocumentMetadataListCopier;
import software.amazon.awssdk.services.workdocs.model.FolderMetadata;
import software.amazon.awssdk.services.workdocs.model.FolderMetadataListCopier;
import software.amazon.awssdk.services.workdocs.model.WorkDocsResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeFolderContentsResponse
extends WorkDocsResponse
implements ToCopyableBuilder<Builder, DescribeFolderContentsResponse> {
    private final List<FolderMetadata> folders;
    private final List<DocumentMetadata> documents;
    private final String marker;

    private DescribeFolderContentsResponse(BuilderImpl builder) {
        super(builder);
        this.folders = builder.folders;
        this.documents = builder.documents;
        this.marker = builder.marker;
    }

    public List<FolderMetadata> folders() {
        return this.folders;
    }

    public List<DocumentMetadata> documents() {
        return this.documents;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.folders());
        hashCode = 31 * hashCode + Objects.hashCode(this.documents());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFolderContentsResponse)) {
            return false;
        }
        DescribeFolderContentsResponse other = (DescribeFolderContentsResponse)((Object)obj);
        return Objects.equals(this.folders(), other.folders()) && Objects.equals(this.documents(), other.documents()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.folders() != null) {
            sb.append("Folders: ").append(this.folders()).append(",");
        }
        if (this.documents() != null) {
            sb.append("Documents: ").append(this.documents()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Folders": {
                return Optional.of(clazz.cast(this.folders()));
            }
            case "Documents": {
                return Optional.of(clazz.cast(this.documents()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WorkDocsResponse.BuilderImpl
    implements Builder {
        private List<FolderMetadata> folders;
        private List<DocumentMetadata> documents;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFolderContentsResponse model) {
            this.folders(model.folders);
            this.documents(model.documents);
            this.marker(model.marker);
        }

        public final Collection<FolderMetadata.Builder> getFolders() {
            return this.folders != null ? (Collection)this.folders.stream().map(FolderMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder folders(Collection<FolderMetadata> folders) {
            this.folders = FolderMetadataListCopier.copy(folders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder folders(FolderMetadata ... folders) {
            this.folders(Arrays.asList(folders));
            return this;
        }

        public final void setFolders(Collection<FolderMetadata.BuilderImpl> folders) {
            this.folders = FolderMetadataListCopier.copyFromBuilder(folders);
        }

        public final Collection<DocumentMetadata.Builder> getDocuments() {
            return this.documents != null ? (Collection)this.documents.stream().map(DocumentMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder documents(Collection<DocumentMetadata> documents) {
            this.documents = DocumentMetadataListCopier.copy(documents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documents(DocumentMetadata ... documents) {
            this.documents(Arrays.asList(documents));
            return this;
        }

        public final void setDocuments(Collection<DocumentMetadata.BuilderImpl> documents) {
            this.documents = DocumentMetadataListCopier.copyFromBuilder(documents);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeFolderContentsResponse build() {
            return new DescribeFolderContentsResponse(this);
        }
    }

    public static interface Builder
    extends WorkDocsResponse.Builder,
    CopyableBuilder<Builder, DescribeFolderContentsResponse> {
        public Builder folders(Collection<FolderMetadata> var1);

        public Builder folders(FolderMetadata ... var1);

        public Builder documents(Collection<DocumentMetadata> var1);

        public Builder documents(DocumentMetadata ... var1);

        public Builder marker(String var1);
    }
}

