/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.workdocs.WorkDocsClient;
import software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsResponse;
import software.amazon.awssdk.services.workdocs.model.DocumentMetadata;
import software.amazon.awssdk.services.workdocs.model.FolderMetadata;

public final class DescribeFolderContentsPaginator
implements SdkIterable<DescribeFolderContentsResponse> {
    private final WorkDocsClient client;
    private final DescribeFolderContentsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeFolderContentsPaginator(WorkDocsClient client, DescribeFolderContentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeFolderContentsResponseFetcher();
    }

    public Iterator<DescribeFolderContentsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<FolderMetadata> folders() {
        Function<DescribeFolderContentsResponse, Iterator> getIterator = response -> response != null ? response.folders().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public SdkIterable<DocumentMetadata> documents() {
        Function<DescribeFolderContentsResponse, Iterator> getIterator = response -> response != null ? response.documents().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeFolderContentsResponseFetcher
    implements NextPageFetcher<DescribeFolderContentsResponse> {
        private DescribeFolderContentsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeFolderContentsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeFolderContentsResponse nextPage(DescribeFolderContentsResponse previousPage) {
            if (previousPage == null) {
                return DescribeFolderContentsPaginator.this.client.describeFolderContents(DescribeFolderContentsPaginator.this.firstRequest);
            }
            return DescribeFolderContentsPaginator.this.client.describeFolderContents((DescribeFolderContentsRequest)((Object)DescribeFolderContentsPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

