/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.workdocs.model.ResourceStateType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateDocumentRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateDocumentRequest> {
    private final String authenticationToken;
    private final String documentId;
    private final String name;
    private final String parentFolderId;
    private final String resourceState;

    private UpdateDocumentRequest(BuilderImpl builder) {
        this.authenticationToken = builder.authenticationToken;
        this.documentId = builder.documentId;
        this.name = builder.name;
        this.parentFolderId = builder.parentFolderId;
        this.resourceState = builder.resourceState;
    }

    public String authenticationToken() {
        return this.authenticationToken;
    }

    public String documentId() {
        return this.documentId;
    }

    public String name() {
        return this.name;
    }

    public String parentFolderId() {
        return this.parentFolderId;
    }

    public ResourceStateType resourceState() {
        return ResourceStateType.fromValue(this.resourceState);
    }

    public String resourceStateString() {
        return this.resourceState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentFolderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceStateString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDocumentRequest)) {
            return false;
        }
        UpdateDocumentRequest other = (UpdateDocumentRequest)((Object)obj);
        return Objects.equals(this.authenticationToken(), other.authenticationToken()) && Objects.equals(this.documentId(), other.documentId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.parentFolderId(), other.parentFolderId()) && Objects.equals(this.resourceStateString(), other.resourceStateString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.authenticationToken() != null) {
            sb.append("AuthenticationToken: ").append(this.authenticationToken()).append(",");
        }
        if (this.documentId() != null) {
            sb.append("DocumentId: ").append(this.documentId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.parentFolderId() != null) {
            sb.append("ParentFolderId: ").append(this.parentFolderId()).append(",");
        }
        if (this.resourceStateString() != null) {
            sb.append("ResourceState: ").append(this.resourceStateString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationToken": {
                return Optional.of(clazz.cast(this.authenticationToken()));
            }
            case "DocumentId": {
                return Optional.of(clazz.cast(this.documentId()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "ParentFolderId": {
                return Optional.of(clazz.cast(this.parentFolderId()));
            }
            case "ResourceState": {
                return Optional.of(clazz.cast(this.resourceStateString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String authenticationToken;
        private String documentId;
        private String name;
        private String parentFolderId;
        private String resourceState;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDocumentRequest model) {
            this.authenticationToken(model.authenticationToken);
            this.documentId(model.documentId);
            this.name(model.name);
            this.parentFolderId(model.parentFolderId);
            this.resourceState(model.resourceState);
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public final String getDocumentId() {
            return this.documentId;
        }

        @Override
        public final Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public final void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getParentFolderId() {
            return this.parentFolderId;
        }

        @Override
        public final Builder parentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
            return this;
        }

        public final void setParentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
        }

        public final String getResourceState() {
            return this.resourceState;
        }

        @Override
        public final Builder resourceState(String resourceState) {
            this.resourceState = resourceState;
            return this;
        }

        @Override
        public final Builder resourceState(ResourceStateType resourceState) {
            this.resourceState(resourceState.toString());
            return this;
        }

        public final void setResourceState(String resourceState) {
            this.resourceState = resourceState;
        }

        public UpdateDocumentRequest build() {
            return new UpdateDocumentRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateDocumentRequest> {
        public Builder authenticationToken(String var1);

        public Builder documentId(String var1);

        public Builder name(String var1);

        public Builder parentFolderId(String var1);

        public Builder resourceState(String var1);

        public Builder resourceState(ResourceStateType var1);
    }
}

