/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.workdocs.model.CustomMetadataMapCopier;
import software.amazon.awssdk.services.workdocs.model.FolderMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetFolderResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetFolderResponse> {
    private final FolderMetadata metadata;
    private final Map<String, String> customMetadata;

    private GetFolderResponse(BuilderImpl builder) {
        this.metadata = builder.metadata;
        this.customMetadata = builder.customMetadata;
    }

    public FolderMetadata metadata() {
        return this.metadata;
    }

    public Map<String, String> customMetadata() {
        return this.customMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.customMetadata());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFolderResponse)) {
            return false;
        }
        GetFolderResponse other = (GetFolderResponse)((Object)obj);
        return Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.customMetadata(), other.customMetadata());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.metadata() != null) {
            sb.append("Metadata: ").append(this.metadata()).append(",");
        }
        if (this.customMetadata() != null) {
            sb.append("CustomMetadata: ").append(this.customMetadata()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Metadata": {
                return Optional.of(clazz.cast(this.metadata()));
            }
            case "CustomMetadata": {
                return Optional.of(clazz.cast(this.customMetadata()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private FolderMetadata metadata;
        private Map<String, String> customMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFolderResponse model) {
            this.metadata(model.metadata);
            this.customMetadata(model.customMetadata);
        }

        public final FolderMetadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        @Override
        public final Builder metadata(FolderMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(FolderMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        public final Map<String, String> getCustomMetadata() {
            return this.customMetadata;
        }

        @Override
        public final Builder customMetadata(Map<String, String> customMetadata) {
            this.customMetadata = CustomMetadataMapCopier.copy(customMetadata);
            return this;
        }

        public final void setCustomMetadata(Map<String, String> customMetadata) {
            this.customMetadata = CustomMetadataMapCopier.copy(customMetadata);
        }

        public GetFolderResponse build() {
            return new GetFolderResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetFolderResponse> {
        public Builder metadata(FolderMetadata var1);

        default public Builder metadata(Consumer<FolderMetadata.Builder> metadata) {
            return this.metadata((FolderMetadata)((FolderMetadata.Builder)FolderMetadata.builder().apply(metadata)).build());
        }

        public Builder customMetadata(Map<String, String> var1);
    }
}

