/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.SubscriptionProtocolType;
import software.amazon.awssdk.services.workdocs.transform.SubscriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Subscription
implements StructuredPojo,
ToCopyableBuilder<Builder, Subscription> {
    private final String subscriptionId;
    private final String endPoint;
    private final String protocol;

    private Subscription(BuilderImpl builder) {
        this.subscriptionId = builder.subscriptionId;
        this.endPoint = builder.endPoint;
        this.protocol = builder.protocol;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public String endPoint() {
        return this.endPoint;
    }

    public String protocol() {
        return this.protocol;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.subscriptionId() == null ? 0 : this.subscriptionId().hashCode());
        hashCode = 31 * hashCode + (this.endPoint() == null ? 0 : this.endPoint().hashCode());
        hashCode = 31 * hashCode + (this.protocol() == null ? 0 : this.protocol().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subscription)) {
            return false;
        }
        Subscription other = (Subscription)obj;
        if (other.subscriptionId() == null ^ this.subscriptionId() == null) {
            return false;
        }
        if (other.subscriptionId() != null && !other.subscriptionId().equals(this.subscriptionId())) {
            return false;
        }
        if (other.endPoint() == null ^ this.endPoint() == null) {
            return false;
        }
        if (other.endPoint() != null && !other.endPoint().equals(this.endPoint())) {
            return false;
        }
        if (other.protocol() == null ^ this.protocol() == null) {
            return false;
        }
        return other.protocol() == null || other.protocol().equals(this.protocol());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.subscriptionId() != null) {
            sb.append("SubscriptionId: ").append(this.subscriptionId()).append(",");
        }
        if (this.endPoint() != null) {
            sb.append("EndPoint: ").append(this.endPoint()).append(",");
        }
        if (this.protocol() != null) {
            sb.append("Protocol: ").append(this.protocol()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SubscriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String subscriptionId;
        private String endPoint;
        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(Subscription model) {
            this.setSubscriptionId(model.subscriptionId);
            this.setEndPoint(model.endPoint);
            this.setProtocol(model.protocol);
        }

        public final String getSubscriptionId() {
            return this.subscriptionId;
        }

        @Override
        public final Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public final void setSubscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
        }

        public final String getEndPoint() {
            return this.endPoint;
        }

        @Override
        public final Builder endPoint(String endPoint) {
            this.endPoint = endPoint;
            return this;
        }

        public final void setEndPoint(String endPoint) {
            this.endPoint = endPoint;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(SubscriptionProtocolType protocol) {
            this.protocol(protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public Subscription build() {
            return new Subscription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Subscription> {
        public Builder subscriptionId(String var1);

        public Builder endPoint(String var1);

        public Builder protocol(String var1);

        public Builder protocol(SubscriptionProtocolType var1);
    }
}

