/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import java.time.Instant;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.Activity;

@SdkInternalApi
public class ActivityMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").build();
    private static final MarshallingInfo<Instant> TIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimeStamp").build();
    private static final MarshallingInfo<String> ORGANIZATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OrganizationId").build();
    private static final MarshallingInfo<StructuredPojo> INITIATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Initiator").build();
    private static final MarshallingInfo<StructuredPojo> PARTICIPANTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Participants").build();
    private static final MarshallingInfo<StructuredPojo> RESOURCEMETADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceMetadata").build();
    private static final MarshallingInfo<StructuredPojo> ORIGINALPARENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OriginalParent").build();
    private static final MarshallingInfo<StructuredPojo> COMMENTMETADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CommentMetadata").build();
    private static final ActivityMarshaller INSTANCE = new ActivityMarshaller();

    public static ActivityMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Activity activity, ProtocolMarshaller protocolMarshaller) {
        if (activity == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)activity.type(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)activity.timeStamp(), TIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)activity.organizationId(), ORGANIZATIONID_BINDING);
            protocolMarshaller.marshall((Object)activity.initiator(), INITIATOR_BINDING);
            protocolMarshaller.marshall((Object)activity.participants(), PARTICIPANTS_BINDING);
            protocolMarshaller.marshall((Object)activity.resourceMetadata(), RESOURCEMETADATA_BINDING);
            protocolMarshaller.marshall((Object)activity.originalParent(), ORIGINALPARENT_BINDING);
            protocolMarshaller.marshall((Object)activity.commentMetadata(), COMMENTMETADATA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

