/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.ResourceType;
import software.amazon.awssdk.services.workdocs.model.UserMetadata;
import software.amazon.awssdk.services.workdocs.transform.ResourceMetadataMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResourceMetadata
implements StructuredPojo,
ToCopyableBuilder<Builder, ResourceMetadata> {
    private final String type;
    private final String name;
    private final String originalName;
    private final String id;
    private final String versionId;
    private final UserMetadata owner;
    private final String parentId;

    private ResourceMetadata(BuilderImpl builder) {
        this.type = builder.type;
        this.name = builder.name;
        this.originalName = builder.originalName;
        this.id = builder.id;
        this.versionId = builder.versionId;
        this.owner = builder.owner;
        this.parentId = builder.parentId;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String originalName() {
        return this.originalName;
    }

    public String id() {
        return this.id;
    }

    public String versionId() {
        return this.versionId;
    }

    public UserMetadata owner() {
        return this.owner;
    }

    public String parentId() {
        return this.parentId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.originalName() == null ? 0 : this.originalName().hashCode());
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.versionId() == null ? 0 : this.versionId().hashCode());
        hashCode = 31 * hashCode + (this.owner() == null ? 0 : this.owner().hashCode());
        hashCode = 31 * hashCode + (this.parentId() == null ? 0 : this.parentId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceMetadata)) {
            return false;
        }
        ResourceMetadata other = (ResourceMetadata)obj;
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.originalName() == null ^ this.originalName() == null) {
            return false;
        }
        if (other.originalName() != null && !other.originalName().equals(this.originalName())) {
            return false;
        }
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.versionId() == null ^ this.versionId() == null) {
            return false;
        }
        if (other.versionId() != null && !other.versionId().equals(this.versionId())) {
            return false;
        }
        if (other.owner() == null ^ this.owner() == null) {
            return false;
        }
        if (other.owner() != null && !other.owner().equals(this.owner())) {
            return false;
        }
        if (other.parentId() == null ^ this.parentId() == null) {
            return false;
        }
        return other.parentId() == null || other.parentId().equals(this.parentId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.originalName() != null) {
            sb.append("OriginalName: ").append(this.originalName()).append(",");
        }
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.versionId() != null) {
            sb.append("VersionId: ").append(this.versionId()).append(",");
        }
        if (this.owner() != null) {
            sb.append("Owner: ").append(this.owner()).append(",");
        }
        if (this.parentId() != null) {
            sb.append("ParentId: ").append(this.parentId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String type;
        private String name;
        private String originalName;
        private String id;
        private String versionId;
        private UserMetadata owner;
        private String parentId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceMetadata model) {
            this.setType(model.type);
            this.setName(model.name);
            this.setOriginalName(model.originalName);
            this.setId(model.id);
            this.setVersionId(model.versionId);
            this.setOwner(model.owner);
            this.setParentId(model.parentId);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ResourceType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getOriginalName() {
            return this.originalName;
        }

        @Override
        public final Builder originalName(String originalName) {
            this.originalName = originalName;
            return this;
        }

        public final void setOriginalName(String originalName) {
            this.originalName = originalName;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final UserMetadata getOwner() {
            return this.owner;
        }

        @Override
        public final Builder owner(UserMetadata owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(UserMetadata owner) {
            this.owner = owner;
        }

        public final String getParentId() {
            return this.parentId;
        }

        @Override
        public final Builder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public final void setParentId(String parentId) {
            this.parentId = parentId;
        }

        public ResourceMetadata build() {
            return new ResourceMetadata(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResourceMetadata> {
        public Builder type(String var1);

        public Builder type(ResourceType var1);

        public Builder name(String var1);

        public Builder originalName(String var1);

        public Builder id(String var1);

        public Builder versionId(String var1);

        public Builder owner(UserMetadata var1);

        public Builder parentId(String var1);
    }
}

