/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.workdocs.model.CustomMetadataMapCopier;
import software.amazon.awssdk.services.workdocs.model.DocumentMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetDocumentResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetDocumentResponse> {
    private final DocumentMetadata metadata;
    private final Map<String, String> customMetadata;

    private GetDocumentResponse(BuilderImpl builder) {
        this.metadata = builder.metadata;
        this.customMetadata = builder.customMetadata;
    }

    public DocumentMetadata metadata() {
        return this.metadata;
    }

    public Map<String, String> customMetadata() {
        return this.customMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.metadata() == null ? 0 : this.metadata().hashCode());
        hashCode = 31 * hashCode + (this.customMetadata() == null ? 0 : this.customMetadata().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDocumentResponse)) {
            return false;
        }
        GetDocumentResponse other = (GetDocumentResponse)((Object)obj);
        if (other.metadata() == null ^ this.metadata() == null) {
            return false;
        }
        if (other.metadata() != null && !other.metadata().equals(this.metadata())) {
            return false;
        }
        if (other.customMetadata() == null ^ this.customMetadata() == null) {
            return false;
        }
        return other.customMetadata() == null || other.customMetadata().equals(this.customMetadata());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.metadata() != null) {
            sb.append("Metadata: ").append(this.metadata()).append(",");
        }
        if (this.customMetadata() != null) {
            sb.append("CustomMetadata: ").append(this.customMetadata()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private DocumentMetadata metadata;
        private Map<String, String> customMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDocumentResponse model) {
            this.setMetadata(model.metadata);
            this.setCustomMetadata(model.customMetadata);
        }

        public final DocumentMetadata getMetadata() {
            return this.metadata;
        }

        @Override
        public final Builder metadata(DocumentMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(DocumentMetadata metadata) {
            this.metadata = metadata;
        }

        public final Map<String, String> getCustomMetadata() {
            return this.customMetadata;
        }

        @Override
        public final Builder customMetadata(Map<String, String> customMetadata) {
            this.customMetadata = CustomMetadataMapCopier.copy(customMetadata);
            return this;
        }

        public final void setCustomMetadata(Map<String, String> customMetadata) {
            this.customMetadata = CustomMetadataMapCopier.copy(customMetadata);
        }

        public GetDocumentResponse build() {
            return new GetDocumentResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetDocumentResponse> {
        public Builder metadata(DocumentMetadata var1);

        public Builder customMetadata(Map<String, String> var1);
    }
}

