/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.ResourcePathComponent;
import software.amazon.awssdk.services.workdocs.model.ResourcePathComponentListCopier;
import software.amazon.awssdk.services.workdocs.transform.ResourcePathMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResourcePath
implements StructuredPojo,
ToCopyableBuilder<Builder, ResourcePath> {
    private final List<ResourcePathComponent> components;

    private ResourcePath(BuilderImpl builder) {
        this.components = builder.components;
    }

    public List<ResourcePathComponent> components() {
        return this.components;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.components() == null ? 0 : this.components().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourcePath)) {
            return false;
        }
        ResourcePath other = (ResourcePath)obj;
        if (other.components() == null ^ this.components() == null) {
            return false;
        }
        return other.components() == null || other.components().equals(this.components());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.components() != null) {
            sb.append("Components: ").append(this.components()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourcePathMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ResourcePathComponent> components;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourcePath model) {
            this.setComponents(model.components);
        }

        public final Collection<ResourcePathComponent> getComponents() {
            return this.components;
        }

        @Override
        public final Builder components(Collection<ResourcePathComponent> components) {
            this.components = ResourcePathComponentListCopier.copy(components);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder components(ResourcePathComponent ... components) {
            this.components(Arrays.asList(components));
            return this;
        }

        public final void setComponents(Collection<ResourcePathComponent> components) {
            this.components = ResourcePathComponentListCopier.copy(components);
        }

        @SafeVarargs
        public final void setComponents(ResourcePathComponent ... components) {
            this.components(Arrays.asList(components));
        }

        public ResourcePath build() {
            return new ResourcePath(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResourcePath> {
        public Builder components(Collection<ResourcePathComponent> var1);

        public Builder components(ResourcePathComponent ... var1);
    }
}

