/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs;

import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.AwsSyncClientParams;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandler;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.client.SdkClientHandler;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.workdocs.WorkDocsClient;
import software.amazon.awssdk.services.workdocs.model.AbortDocumentVersionUploadRequest;
import software.amazon.awssdk.services.workdocs.model.AbortDocumentVersionUploadResponse;
import software.amazon.awssdk.services.workdocs.model.ActivateUserRequest;
import software.amazon.awssdk.services.workdocs.model.ActivateUserResponse;
import software.amazon.awssdk.services.workdocs.model.AddResourcePermissionsRequest;
import software.amazon.awssdk.services.workdocs.model.AddResourcePermissionsResponse;
import software.amazon.awssdk.services.workdocs.model.ConcurrentModificationException;
import software.amazon.awssdk.services.workdocs.model.CreateCommentRequest;
import software.amazon.awssdk.services.workdocs.model.CreateCommentResponse;
import software.amazon.awssdk.services.workdocs.model.CreateCustomMetadataRequest;
import software.amazon.awssdk.services.workdocs.model.CreateCustomMetadataResponse;
import software.amazon.awssdk.services.workdocs.model.CreateFolderRequest;
import software.amazon.awssdk.services.workdocs.model.CreateFolderResponse;
import software.amazon.awssdk.services.workdocs.model.CreateLabelsRequest;
import software.amazon.awssdk.services.workdocs.model.CreateLabelsResponse;
import software.amazon.awssdk.services.workdocs.model.CreateNotificationSubscriptionRequest;
import software.amazon.awssdk.services.workdocs.model.CreateNotificationSubscriptionResponse;
import software.amazon.awssdk.services.workdocs.model.CreateUserRequest;
import software.amazon.awssdk.services.workdocs.model.CreateUserResponse;
import software.amazon.awssdk.services.workdocs.model.CustomMetadataLimitExceededException;
import software.amazon.awssdk.services.workdocs.model.DeactivateUserRequest;
import software.amazon.awssdk.services.workdocs.model.DeactivateUserResponse;
import software.amazon.awssdk.services.workdocs.model.DeactivatingLastSystemUserException;
import software.amazon.awssdk.services.workdocs.model.DeleteCommentRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteCommentResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteCustomMetadataRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteCustomMetadataResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteDocumentRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteDocumentResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteFolderContentsRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteFolderContentsResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteFolderRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteFolderResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteLabelsRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteLabelsResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteNotificationSubscriptionRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteNotificationSubscriptionResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteUserRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteUserResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeActivitiesRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeActivitiesResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeCommentsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeCommentsResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeUsersRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeUsersResponse;
import software.amazon.awssdk.services.workdocs.model.DocumentLockedForCommentsException;
import software.amazon.awssdk.services.workdocs.model.DraftUploadOutOfSyncException;
import software.amazon.awssdk.services.workdocs.model.EntityAlreadyExistsException;
import software.amazon.awssdk.services.workdocs.model.EntityNotExistsException;
import software.amazon.awssdk.services.workdocs.model.FailedDependencyException;
import software.amazon.awssdk.services.workdocs.model.GetCurrentUserRequest;
import software.amazon.awssdk.services.workdocs.model.GetCurrentUserResponse;
import software.amazon.awssdk.services.workdocs.model.GetDocumentPathRequest;
import software.amazon.awssdk.services.workdocs.model.GetDocumentPathResponse;
import software.amazon.awssdk.services.workdocs.model.GetDocumentRequest;
import software.amazon.awssdk.services.workdocs.model.GetDocumentResponse;
import software.amazon.awssdk.services.workdocs.model.GetDocumentVersionRequest;
import software.amazon.awssdk.services.workdocs.model.GetDocumentVersionResponse;
import software.amazon.awssdk.services.workdocs.model.GetFolderPathRequest;
import software.amazon.awssdk.services.workdocs.model.GetFolderPathResponse;
import software.amazon.awssdk.services.workdocs.model.GetFolderRequest;
import software.amazon.awssdk.services.workdocs.model.GetFolderResponse;
import software.amazon.awssdk.services.workdocs.model.IllegalUserStateException;
import software.amazon.awssdk.services.workdocs.model.InitiateDocumentVersionUploadRequest;
import software.amazon.awssdk.services.workdocs.model.InitiateDocumentVersionUploadResponse;
import software.amazon.awssdk.services.workdocs.model.InvalidArgumentException;
import software.amazon.awssdk.services.workdocs.model.InvalidOperationException;
import software.amazon.awssdk.services.workdocs.model.LimitExceededException;
import software.amazon.awssdk.services.workdocs.model.ProhibitedStateException;
import software.amazon.awssdk.services.workdocs.model.RemoveAllResourcePermissionsRequest;
import software.amazon.awssdk.services.workdocs.model.RemoveAllResourcePermissionsResponse;
import software.amazon.awssdk.services.workdocs.model.RemoveResourcePermissionRequest;
import software.amazon.awssdk.services.workdocs.model.RemoveResourcePermissionResponse;
import software.amazon.awssdk.services.workdocs.model.ResourceAlreadyCheckedOutException;
import software.amazon.awssdk.services.workdocs.model.ServiceUnavailableException;
import software.amazon.awssdk.services.workdocs.model.StorageLimitExceededException;
import software.amazon.awssdk.services.workdocs.model.StorageLimitWillExceedException;
import software.amazon.awssdk.services.workdocs.model.TooManyLabelsException;
import software.amazon.awssdk.services.workdocs.model.TooManySubscriptionsException;
import software.amazon.awssdk.services.workdocs.model.UnauthorizedOperationException;
import software.amazon.awssdk.services.workdocs.model.UnauthorizedResourceAccessException;
import software.amazon.awssdk.services.workdocs.model.UpdateDocumentRequest;
import software.amazon.awssdk.services.workdocs.model.UpdateDocumentResponse;
import software.amazon.awssdk.services.workdocs.model.UpdateDocumentVersionRequest;
import software.amazon.awssdk.services.workdocs.model.UpdateDocumentVersionResponse;
import software.amazon.awssdk.services.workdocs.model.UpdateFolderRequest;
import software.amazon.awssdk.services.workdocs.model.UpdateFolderResponse;
import software.amazon.awssdk.services.workdocs.model.UpdateUserRequest;
import software.amazon.awssdk.services.workdocs.model.UpdateUserResponse;
import software.amazon.awssdk.services.workdocs.model.WorkDocsException;
import software.amazon.awssdk.services.workdocs.transform.AbortDocumentVersionUploadRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.AbortDocumentVersionUploadResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.ActivateUserRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.ActivateUserResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.AddResourcePermissionsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.AddResourcePermissionsResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.CreateCommentRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.CreateCommentResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.CreateCustomMetadataRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.CreateCustomMetadataResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.CreateFolderRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.CreateFolderResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.CreateLabelsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.CreateLabelsResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.CreateNotificationSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.CreateNotificationSubscriptionResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.CreateUserRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.CreateUserResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeactivateUserRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeactivateUserResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteCommentRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteCommentResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteCustomMetadataRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteCustomMetadataResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteDocumentRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteDocumentResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteFolderContentsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteFolderContentsResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteFolderRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteFolderResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteLabelsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteLabelsResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteNotificationSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteNotificationSubscriptionResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteUserResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeActivitiesRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeActivitiesResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeCommentsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeCommentsResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeDocumentVersionsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeDocumentVersionsResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeFolderContentsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeFolderContentsResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeNotificationSubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeNotificationSubscriptionsResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeResourcePermissionsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeResourcePermissionsResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeRootFoldersRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeRootFoldersResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeUsersRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeUsersResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.GetCurrentUserRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.GetCurrentUserResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.GetDocumentPathRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.GetDocumentPathResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.GetDocumentRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.GetDocumentResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.GetDocumentVersionRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.GetDocumentVersionResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.GetFolderPathRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.GetFolderPathResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.GetFolderRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.GetFolderResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.InitiateDocumentVersionUploadRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.InitiateDocumentVersionUploadResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.RemoveAllResourcePermissionsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.RemoveAllResourcePermissionsResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.RemoveResourcePermissionRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.RemoveResourcePermissionResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.UpdateDocumentRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.UpdateDocumentResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.UpdateDocumentVersionRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.UpdateDocumentVersionResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.UpdateFolderRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.UpdateFolderResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.UpdateUserRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.UpdateUserResponseUnmarshaller;

@SdkInternalApi
final class DefaultWorkDocsClient
implements WorkDocsClient {
    private final ClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;
    private final AwsSyncClientParams clientParams;

    protected DefaultWorkDocsClient(AwsSyncClientParams clientParams) {
        this.clientHandler = new SdkClientHandler(new ClientHandlerParams().withClientParams(clientParams).withCalculateCrc32FromCompressedDataEnabled(false));
        this.clientParams = clientParams;
        this.protocolFactory = this.init();
    }

    @Override
    public AbortDocumentVersionUploadResponse abortDocumentVersionUpload(AbortDocumentVersionUploadRequest abortDocumentVersionUploadRequest) throws EntityNotExistsException, ProhibitedStateException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, SdkBaseException, SdkClientException, WorkDocsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new AbortDocumentVersionUploadResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (AbortDocumentVersionUploadResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)abortDocumentVersionUploadRequest).withMarshaller((Marshaller)new AbortDocumentVersionUploadRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ActivateUserResponse activateUser(ActivateUserRequest activateUserRequest) throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, SdkBaseException, SdkClientException, WorkDocsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ActivateUserResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ActivateUserResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)activateUserRequest).withMarshaller((Marshaller)new ActivateUserRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public AddResourcePermissionsResponse addResourcePermissions(AddResourcePermissionsRequest addResourcePermissionsRequest) throws UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, SdkBaseException, SdkClientException, WorkDocsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new AddResourcePermissionsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (AddResourcePermissionsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)addResourcePermissionsRequest).withMarshaller((Marshaller)new AddResourcePermissionsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public CreateCommentResponse createComment(CreateCommentRequest createCommentRequest) throws EntityNotExistsException, ProhibitedStateException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, DocumentLockedForCommentsException, SdkBaseException, SdkClientException, WorkDocsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CreateCommentResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateCommentResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)createCommentRequest).withMarshaller((Marshaller)new CreateCommentRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public CreateCustomMetadataResponse createCustomMetadata(CreateCustomMetadataRequest createCustomMetadataRequest) throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException, ProhibitedStateException, CustomMetadataLimitExceededException, FailedDependencyException, ServiceUnavailableException, SdkBaseException, SdkClientException, WorkDocsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CreateCustomMetadataResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateCustomMetadataResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)createCustomMetadataRequest).withMarshaller((Marshaller)new CreateCustomMetadataRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public CreateFolderResponse createFolder(CreateFolderRequest createFolderRequest) throws EntityNotExistsException, EntityAlreadyExistsException, ProhibitedStateException, LimitExceededException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, SdkBaseException, SdkClientException, WorkDocsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CreateFolderResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateFolderResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)createFolderRequest).withMarshaller((Marshaller)new CreateFolderRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public CreateLabelsResponse createLabels(CreateLabelsRequest createLabelsRequest) throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, TooManyLabelsException, SdkBaseException, SdkClientException, WorkDocsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CreateLabelsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateLabelsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)createLabelsRequest).withMarshaller((Marshaller)new CreateLabelsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public CreateNotificationSubscriptionResponse createNotificationSubscription(CreateNotificationSubscriptionRequest createNotificationSubscriptionRequest) throws UnauthorizedResourceAccessException, TooManySubscriptionsException, ServiceUnavailableException, SdkBaseException, SdkClientException, WorkDocsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CreateNotificationSubscriptionResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateNotificationSubscriptionResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)createNotificationSubscriptionRequest).withMarshaller((Marshaller)new CreateNotificationSubscriptionRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public CreateUserResponse createUser(CreateUserRequest createUserRequest) throws EntityAlreadyExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, SdkBaseException, SdkClientException, WorkDocsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CreateUserResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateUserResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)createUserRequest).withMarshaller((Marshaller)new CreateUserRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DeactivateUserResponse deactivateUser(DeactivateUserRequest deactivateUserRequest) throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, SdkBaseException, SdkClientException, WorkDocsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeactivateUserResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeactivateUserResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deactivateUserRequest).withMarshaller((Marshaller)new DeactivateUserRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DeleteCommentResponse deleteComment(DeleteCommentRequest deleteCommentRequest) throws EntityNotExistsException, ProhibitedStateException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, DocumentLockedForCommentsException, SdkBaseException, SdkClientException, WorkDocsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteCommentResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteCommentResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteCommentRequest).withMarshaller((Marshaller)new DeleteCommentRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DeleteCustomMetadataResponse deleteCustomMetadata(DeleteCustomMetadataRequest deleteCustomMetadataRequest) throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException, ProhibitedStateException, FailedDependencyException, ServiceUnavailableException, SdkBaseException, SdkClientException, WorkDocsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteCustomMetadataResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteCustomMetadataResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteCustomMetadataRequest).withMarshaller((Marshaller)new DeleteCustomMetadataRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DeleteDocumentResponse deleteDocument(DeleteDocumentRequest deleteDocumentRequest) throws EntityNotExistsException, ProhibitedStateException, ConcurrentModificationException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, SdkBaseException, SdkClientException, WorkDocsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteDocumentResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteDocumentResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteDocumentRequest).withMarshaller((Marshaller)new DeleteDocumentRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DeleteFolderResponse deleteFolder(DeleteFolderRequest deleteFolderRequest) throws EntityNotExistsException, ProhibitedStateException, ConcurrentModificationException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, SdkBaseException, SdkClientException, WorkDocsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteFolderResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteFolderResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteFolderRequest).withMarshaller((Marshaller)new DeleteFolderRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DeleteFolderContentsResponse deleteFolderContents(DeleteFolderContentsRequest deleteFolderContentsRequest) throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, SdkBaseException, SdkClientException, WorkDocsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteFolderContentsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteFolderContentsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteFolderContentsRequest).withMarshaller((Marshaller)new DeleteFolderContentsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DeleteLabelsResponse deleteLabels(DeleteLabelsRequest deleteLabelsRequest) throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, SdkBaseException, SdkClientException, WorkDocsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteLabelsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteLabelsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteLabelsRequest).withMarshaller((Marshaller)new DeleteLabelsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DeleteNotificationSubscriptionResponse deleteNotificationSubscription(DeleteNotificationSubscriptionRequest deleteNotificationSubscriptionRequest) throws UnauthorizedResourceAccessException, EntityNotExistsException, ServiceUnavailableException, ProhibitedStateException, SdkBaseException, SdkClientException, WorkDocsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteNotificationSubscriptionResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteNotificationSubscriptionResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteNotificationSubscriptionRequest).withMarshaller((Marshaller)new DeleteNotificationSubscriptionRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DeleteUserResponse deleteUser(DeleteUserRequest deleteUserRequest) throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, SdkBaseException, SdkClientException, WorkDocsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteUserResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteUserResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteUserRequest).withMarshaller((Marshaller)new DeleteUserRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeActivitiesResponse describeActivities(DescribeActivitiesRequest describeActivitiesRequest) throws UnauthorizedOperationException, UnauthorizedResourceAccessException, InvalidArgumentException, FailedDependencyException, ServiceUnavailableException, SdkBaseException, SdkClientException, WorkDocsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeActivitiesResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeActivitiesResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeActivitiesRequest).withMarshaller((Marshaller)new DescribeActivitiesRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeCommentsResponse describeComments(DescribeCommentsRequest describeCommentsRequest) throws EntityNotExistsException, ProhibitedStateException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, SdkBaseException, SdkClientException, WorkDocsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeCommentsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeCommentsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeCommentsRequest).withMarshaller((Marshaller)new DescribeCommentsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeDocumentVersionsResponse describeDocumentVersions(DescribeDocumentVersionsRequest describeDocumentVersionsRequest) throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException, InvalidArgumentException, FailedDependencyException, ServiceUnavailableException, ProhibitedStateException, SdkBaseException, SdkClientException, WorkDocsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeDocumentVersionsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeDocumentVersionsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeDocumentVersionsRequest).withMarshaller((Marshaller)new DescribeDocumentVersionsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeFolderContentsResponse describeFolderContents(DescribeFolderContentsRequest describeFolderContentsRequest) throws EntityNotExistsException, UnauthorizedResourceAccessException, InvalidArgumentException, FailedDependencyException, ServiceUnavailableException, ProhibitedStateException, SdkBaseException, SdkClientException, WorkDocsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeFolderContentsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeFolderContentsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeFolderContentsRequest).withMarshaller((Marshaller)new DescribeFolderContentsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeNotificationSubscriptionsResponse describeNotificationSubscriptions(DescribeNotificationSubscriptionsRequest describeNotificationSubscriptionsRequest) throws UnauthorizedResourceAccessException, EntityNotExistsException, ServiceUnavailableException, SdkBaseException, SdkClientException, WorkDocsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeNotificationSubscriptionsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeNotificationSubscriptionsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeNotificationSubscriptionsRequest).withMarshaller((Marshaller)new DescribeNotificationSubscriptionsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeResourcePermissionsResponse describeResourcePermissions(DescribeResourcePermissionsRequest describeResourcePermissionsRequest) throws UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, SdkBaseException, SdkClientException, WorkDocsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeResourcePermissionsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeResourcePermissionsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeResourcePermissionsRequest).withMarshaller((Marshaller)new DescribeResourcePermissionsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeRootFoldersResponse describeRootFolders(DescribeRootFoldersRequest describeRootFoldersRequest) throws UnauthorizedOperationException, UnauthorizedResourceAccessException, InvalidArgumentException, FailedDependencyException, ServiceUnavailableException, SdkBaseException, SdkClientException, WorkDocsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeRootFoldersResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeRootFoldersResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeRootFoldersRequest).withMarshaller((Marshaller)new DescribeRootFoldersRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeUsersResponse describeUsers(DescribeUsersRequest describeUsersRequest) throws UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, InvalidArgumentException, SdkBaseException, SdkClientException, WorkDocsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeUsersResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeUsersResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeUsersRequest).withMarshaller((Marshaller)new DescribeUsersRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public GetCurrentUserResponse getCurrentUser(GetCurrentUserRequest getCurrentUserRequest) throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, SdkBaseException, SdkClientException, WorkDocsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new GetCurrentUserResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetCurrentUserResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)getCurrentUserRequest).withMarshaller((Marshaller)new GetCurrentUserRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public GetDocumentResponse getDocument(GetDocumentRequest getDocumentRequest) throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException, InvalidArgumentException, FailedDependencyException, ServiceUnavailableException, SdkBaseException, SdkClientException, WorkDocsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new GetDocumentResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetDocumentResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)getDocumentRequest).withMarshaller((Marshaller)new GetDocumentRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public GetDocumentPathResponse getDocumentPath(GetDocumentPathRequest getDocumentPathRequest) throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, SdkBaseException, SdkClientException, WorkDocsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new GetDocumentPathResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetDocumentPathResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)getDocumentPathRequest).withMarshaller((Marshaller)new GetDocumentPathRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public GetDocumentVersionResponse getDocumentVersion(GetDocumentVersionRequest getDocumentVersionRequest) throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, ProhibitedStateException, SdkBaseException, SdkClientException, WorkDocsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new GetDocumentVersionResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetDocumentVersionResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)getDocumentVersionRequest).withMarshaller((Marshaller)new GetDocumentVersionRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public GetFolderResponse getFolder(GetFolderRequest getFolderRequest) throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException, InvalidArgumentException, FailedDependencyException, ServiceUnavailableException, ProhibitedStateException, SdkBaseException, SdkClientException, WorkDocsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new GetFolderResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetFolderResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)getFolderRequest).withMarshaller((Marshaller)new GetFolderRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public GetFolderPathResponse getFolderPath(GetFolderPathRequest getFolderPathRequest) throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, SdkBaseException, SdkClientException, WorkDocsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new GetFolderPathResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetFolderPathResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)getFolderPathRequest).withMarshaller((Marshaller)new GetFolderPathRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public InitiateDocumentVersionUploadResponse initiateDocumentVersionUpload(InitiateDocumentVersionUploadRequest initiateDocumentVersionUploadRequest) throws EntityNotExistsException, EntityAlreadyExistsException, StorageLimitExceededException, StorageLimitWillExceedException, ProhibitedStateException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, DraftUploadOutOfSyncException, ResourceAlreadyCheckedOutException, SdkBaseException, SdkClientException, WorkDocsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new InitiateDocumentVersionUploadResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (InitiateDocumentVersionUploadResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)initiateDocumentVersionUploadRequest).withMarshaller((Marshaller)new InitiateDocumentVersionUploadRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public RemoveAllResourcePermissionsResponse removeAllResourcePermissions(RemoveAllResourcePermissionsRequest removeAllResourcePermissionsRequest) throws UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, SdkBaseException, SdkClientException, WorkDocsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new RemoveAllResourcePermissionsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (RemoveAllResourcePermissionsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)removeAllResourcePermissionsRequest).withMarshaller((Marshaller)new RemoveAllResourcePermissionsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public RemoveResourcePermissionResponse removeResourcePermission(RemoveResourcePermissionRequest removeResourcePermissionRequest) throws UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, SdkBaseException, SdkClientException, WorkDocsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new RemoveResourcePermissionResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (RemoveResourcePermissionResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)removeResourcePermissionRequest).withMarshaller((Marshaller)new RemoveResourcePermissionRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public UpdateDocumentResponse updateDocument(UpdateDocumentRequest updateDocumentRequest) throws EntityNotExistsException, EntityAlreadyExistsException, LimitExceededException, ProhibitedStateException, ConcurrentModificationException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, SdkBaseException, SdkClientException, WorkDocsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new UpdateDocumentResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateDocumentResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)updateDocumentRequest).withMarshaller((Marshaller)new UpdateDocumentRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public UpdateDocumentVersionResponse updateDocumentVersion(UpdateDocumentVersionRequest updateDocumentVersionRequest) throws EntityNotExistsException, ProhibitedStateException, ConcurrentModificationException, InvalidOperationException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, SdkBaseException, SdkClientException, WorkDocsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new UpdateDocumentVersionResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateDocumentVersionResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)updateDocumentVersionRequest).withMarshaller((Marshaller)new UpdateDocumentVersionRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public UpdateFolderResponse updateFolder(UpdateFolderRequest updateFolderRequest) throws EntityNotExistsException, EntityAlreadyExistsException, ProhibitedStateException, ConcurrentModificationException, LimitExceededException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, SdkBaseException, SdkClientException, WorkDocsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new UpdateFolderResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateFolderResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)updateFolderRequest).withMarshaller((Marshaller)new UpdateFolderRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public UpdateUserResponse updateUser(UpdateUserRequest updateUserRequest) throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException, IllegalUserStateException, FailedDependencyException, ServiceUnavailableException, DeactivatingLastSystemUserException, SdkBaseException, SdkClientException, WorkDocsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new UpdateUserResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateUserResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)updateUserRequest).withMarshaller((Marshaller)new UpdateUserRequestMarshaller(this.protocolFactory))));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(WorkDocsException.class).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("FailedDependencyException").withModeledClass(FailedDependencyException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConcurrentModificationException").withModeledClass(ConcurrentModificationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidOperationException").withModeledClass(InvalidOperationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CustomMetadataLimitExceededException").withModeledClass(CustomMetadataLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnauthorizedResourceAccessException").withModeledClass(UnauthorizedResourceAccessException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManySubscriptionsException").withModeledClass(TooManySubscriptionsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("EntityAlreadyExistsException").withModeledClass(EntityAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("EntityNotExistsException").withModeledClass(EntityNotExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DocumentLockedForCommentsException").withModeledClass(DocumentLockedForCommentsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("StorageLimitExceededException").withModeledClass(StorageLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("StorageLimitWillExceedException").withModeledClass(StorageLimitWillExceedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ProhibitedStateException").withModeledClass(ProhibitedStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("IllegalUserStateException").withModeledClass(IllegalUserStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidArgumentException").withModeledClass(InvalidArgumentException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnauthorizedOperationException").withModeledClass(UnauthorizedOperationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyLabelsException").withModeledClass(TooManyLabelsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DraftUploadOutOfSyncException").withModeledClass(DraftUploadOutOfSyncException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceAlreadyCheckedOutException").withModeledClass(ResourceAlreadyCheckedOutException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailableException").withModeledClass(ServiceUnavailableException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DeactivatingLastSystemUserException").withModeledClass(DeactivatingLastSystemUserException.class)));
    }

    @Override
    public void close() throws Exception {
        this.clientHandler.close();
    }
}

