/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.workdocs.model.GetDocumentVersionRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetDocumentVersionRequestModelMarshaller {
    private static final MarshallingInfo<String> AUTHENTICATIONTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("Authentication").isBinary(false).build();
    private static final MarshallingInfo<String> DOCUMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("DocumentId").isBinary(false).build();
    private static final MarshallingInfo<String> VERSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("VersionId").isBinary(false).build();
    private static final MarshallingInfo<String> FIELDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("fields").isBinary(false).build();
    private static final MarshallingInfo<Boolean> INCLUDECUSTOMMETADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("includeCustomMetadata").isBinary(false).build();
    private static final GetDocumentVersionRequestModelMarshaller INSTANCE = new GetDocumentVersionRequestModelMarshaller();

    private GetDocumentVersionRequestModelMarshaller() {
    }

    public static GetDocumentVersionRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetDocumentVersionRequest getDocumentVersionRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)getDocumentVersionRequest), (String)"getDocumentVersionRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)getDocumentVersionRequest.authenticationToken(), AUTHENTICATIONTOKEN_BINDING);
            protocolMarshaller.marshall((Object)getDocumentVersionRequest.documentId(), DOCUMENTID_BINDING);
            protocolMarshaller.marshall((Object)getDocumentVersionRequest.versionId(), VERSIONID_BINDING);
            protocolMarshaller.marshall((Object)getDocumentVersionRequest.fields(), FIELDS_BINDING);
            protocolMarshaller.marshall((Object)getDocumentVersionRequest.includeCustomMetadata(), INCLUDECUSTOMMETADATA_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

