/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.User;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UserMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Username").isBinary(false).build();
    private static final MarshallingInfo<String> EMAILADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EmailAddress").isBinary(false).build();
    private static final MarshallingInfo<String> GIVENNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GivenName").isBinary(false).build();
    private static final MarshallingInfo<String> SURNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Surname").isBinary(false).build();
    private static final MarshallingInfo<String> ORGANIZATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OrganizationId").isBinary(false).build();
    private static final MarshallingInfo<String> ROOTFOLDERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RootFolderId").isBinary(false).build();
    private static final MarshallingInfo<String> RECYCLEBINFOLDERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecycleBinFolderId").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedTimestamp").isBinary(false).build();
    private static final MarshallingInfo<Instant> MODIFIEDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModifiedTimestamp").isBinary(false).build();
    private static final MarshallingInfo<String> TIMEZONEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimeZoneId").isBinary(false).build();
    private static final MarshallingInfo<String> LOCALE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Locale").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> STORAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Storage").isBinary(false).build();
    private static final UserMarshaller INSTANCE = new UserMarshaller();

    private UserMarshaller() {
    }

    public static UserMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(User user, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)user, (String)"user");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)user.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)user.username(), USERNAME_BINDING);
            protocolMarshaller.marshall((Object)user.emailAddress(), EMAILADDRESS_BINDING);
            protocolMarshaller.marshall((Object)user.givenName(), GIVENNAME_BINDING);
            protocolMarshaller.marshall((Object)user.surname(), SURNAME_BINDING);
            protocolMarshaller.marshall((Object)user.organizationId(), ORGANIZATIONID_BINDING);
            protocolMarshaller.marshall((Object)user.rootFolderId(), ROOTFOLDERID_BINDING);
            protocolMarshaller.marshall((Object)user.recycleBinFolderId(), RECYCLEBINFOLDERID_BINDING);
            protocolMarshaller.marshall((Object)user.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)user.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)user.createdTimestamp(), CREATEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)user.modifiedTimestamp(), MODIFIEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)user.timeZoneId(), TIMEZONEID_BINDING);
            protocolMarshaller.marshall((Object)user.localeAsString(), LOCALE_BINDING);
            protocolMarshaller.marshall((Object)user.storage(), STORAGE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

