/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.workdocs.model.Participants;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ParticipantsMarshaller {
    private static final MarshallingInfo<List> USERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Users").isBinary(false).build();
    private static final MarshallingInfo<List> GROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Groups").isBinary(false).build();
    private static final ParticipantsMarshaller INSTANCE = new ParticipantsMarshaller();

    private ParticipantsMarshaller() {
    }

    public static ParticipantsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Participants participants, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)participants, (String)"participants");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(participants.users(), USERS_BINDING);
            protocolMarshaller.marshall(participants.groups(), GROUPS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

