/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.workdocs.model.WorkDocsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFolderPathRequest
extends WorkDocsRequest
implements ToCopyableBuilder<Builder, GetFolderPathRequest> {
    private final String authenticationToken;
    private final String folderId;
    private final Integer limit;
    private final String fields;
    private final String marker;

    private GetFolderPathRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.folderId = builder.folderId;
        this.limit = builder.limit;
        this.fields = builder.fields;
        this.marker = builder.marker;
    }

    public String authenticationToken() {
        return this.authenticationToken;
    }

    public String folderId() {
        return this.folderId;
    }

    public Integer limit() {
        return this.limit;
    }

    public String fields() {
        return this.fields;
    }

    public String marker() {
        return this.marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.folderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.fields());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFolderPathRequest)) {
            return false;
        }
        GetFolderPathRequest other = (GetFolderPathRequest)((Object)obj);
        return Objects.equals(this.authenticationToken(), other.authenticationToken()) && Objects.equals(this.folderId(), other.folderId()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.fields(), other.fields()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"GetFolderPathRequest").add("AuthenticationToken", (Object)this.authenticationToken()).add("FolderId", (Object)this.folderId()).add("Limit", (Object)this.limit()).add("Fields", (Object)this.fields()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationToken": {
                return Optional.ofNullable(clazz.cast(this.authenticationToken()));
            }
            case "FolderId": {
                return Optional.ofNullable(clazz.cast(this.folderId()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "Fields": {
                return Optional.ofNullable(clazz.cast(this.fields()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WorkDocsRequest.BuilderImpl
    implements Builder {
        private String authenticationToken;
        private String folderId;
        private Integer limit;
        private String fields;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFolderPathRequest model) {
            super(model);
            this.authenticationToken(model.authenticationToken);
            this.folderId(model.folderId);
            this.limit(model.limit);
            this.fields(model.fields);
            this.marker(model.marker);
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public final String getFolderId() {
            return this.folderId;
        }

        @Override
        public final Builder folderId(String folderId) {
            this.folderId = folderId;
            return this;
        }

        public final void setFolderId(String folderId) {
            this.folderId = folderId;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getFields() {
            return this.fields;
        }

        @Override
        public final Builder fields(String fields) {
            this.fields = fields;
            return this;
        }

        public final void setFields(String fields) {
            this.fields = fields;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetFolderPathRequest build() {
            return new GetFolderPathRequest(this);
        }
    }

    public static interface Builder
    extends WorkDocsRequest.Builder,
    CopyableBuilder<Builder, GetFolderPathRequest> {
        public Builder authenticationToken(String var1);

        public Builder folderId(String var1);

        public Builder limit(Integer var1);

        public Builder fields(String var1);

        public Builder marker(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

