/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.workdocs.model.NotificationOptions;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class NotificationOptionsMarshaller {
    private static final MarshallingInfo<Boolean> SENDEMAIL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SendEmail").isBinary(false).build();
    private static final MarshallingInfo<String> EMAILMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EmailMessage").isBinary(false).build();
    private static final NotificationOptionsMarshaller INSTANCE = new NotificationOptionsMarshaller();

    private NotificationOptionsMarshaller() {
    }

    public static NotificationOptionsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(NotificationOptions notificationOptions, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)notificationOptions, (String)"notificationOptions");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)notificationOptions.sendEmail(), SENDEMAIL_BINDING);
            protocolMarshaller.marshall((Object)notificationOptions.emailMessage(), EMAILMESSAGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

