/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.GroupMetadata;
import software.amazon.awssdk.services.workdocs.model.GroupMetadataListCopier;
import software.amazon.awssdk.services.workdocs.model.UserMetadata;
import software.amazon.awssdk.services.workdocs.model.UserMetadataListCopier;
import software.amazon.awssdk.services.workdocs.transform.ParticipantsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Participants
implements StructuredPojo,
ToCopyableBuilder<Builder, Participants> {
    private final List<UserMetadata> users;
    private final List<GroupMetadata> groups;

    private Participants(BuilderImpl builder) {
        this.users = builder.users;
        this.groups = builder.groups;
    }

    public List<UserMetadata> users() {
        return this.users;
    }

    public List<GroupMetadata> groups() {
        return this.groups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.users());
        hashCode = 31 * hashCode + Objects.hashCode(this.groups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Participants)) {
            return false;
        }
        Participants other = (Participants)obj;
        return Objects.equals(this.users(), other.users()) && Objects.equals(this.groups(), other.groups());
    }

    public String toString() {
        return ToString.builder((String)"Participants").add("Users", this.users()).add("Groups", this.groups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Users": {
                return Optional.of(clazz.cast(this.users()));
            }
            case "Groups": {
                return Optional.of(clazz.cast(this.groups()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ParticipantsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<UserMetadata> users;
        private List<GroupMetadata> groups;

        private BuilderImpl() {
        }

        private BuilderImpl(Participants model) {
            this.users(model.users);
            this.groups(model.groups);
        }

        public final Collection<UserMetadata.Builder> getUsers() {
            return this.users != null ? (Collection)this.users.stream().map(UserMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder users(Collection<UserMetadata> users) {
            this.users = UserMetadataListCopier.copy(users);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(UserMetadata ... users) {
            this.users(Arrays.asList(users));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(Consumer<UserMetadata.Builder> ... users) {
            this.users(Stream.of(users).map(c -> (UserMetadata)((UserMetadata.Builder)UserMetadata.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUsers(Collection<UserMetadata.BuilderImpl> users) {
            this.users = UserMetadataListCopier.copyFromBuilder(users);
        }

        public final Collection<GroupMetadata.Builder> getGroups() {
            return this.groups != null ? (Collection)this.groups.stream().map(GroupMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder groups(Collection<GroupMetadata> groups) {
            this.groups = GroupMetadataListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(GroupMetadata ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<GroupMetadata.Builder> ... groups) {
            this.groups(Stream.of(groups).map(c -> (GroupMetadata)((GroupMetadata.Builder)GroupMetadata.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGroups(Collection<GroupMetadata.BuilderImpl> groups) {
            this.groups = GroupMetadataListCopier.copyFromBuilder(groups);
        }

        public Participants build() {
            return new Participants(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Participants> {
        public Builder users(Collection<UserMetadata> var1);

        public Builder users(UserMetadata ... var1);

        public Builder users(Consumer<UserMetadata.Builder> ... var1);

        public Builder groups(Collection<GroupMetadata> var1);

        public Builder groups(GroupMetadata ... var1);

        public Builder groups(Consumer<GroupMetadata.Builder> ... var1);
    }
}

