/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.workdocs.model.WorkDocsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteNotificationSubscriptionRequest
extends WorkDocsRequest
implements ToCopyableBuilder<Builder, DeleteNotificationSubscriptionRequest> {
    private final String subscriptionId;
    private final String organizationId;

    private DeleteNotificationSubscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.subscriptionId = builder.subscriptionId;
        this.organizationId = builder.organizationId;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public String organizationId() {
        return this.organizationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteNotificationSubscriptionRequest)) {
            return false;
        }
        DeleteNotificationSubscriptionRequest other = (DeleteNotificationSubscriptionRequest)((Object)obj);
        return Objects.equals(this.subscriptionId(), other.subscriptionId()) && Objects.equals(this.organizationId(), other.organizationId());
    }

    public String toString() {
        return ToString.builder((String)"DeleteNotificationSubscriptionRequest").add("SubscriptionId", (Object)this.subscriptionId()).add("OrganizationId", (Object)this.organizationId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubscriptionId": {
                return Optional.of(clazz.cast(this.subscriptionId()));
            }
            case "OrganizationId": {
                return Optional.of(clazz.cast(this.organizationId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WorkDocsRequest.BuilderImpl
    implements Builder {
        private String subscriptionId;
        private String organizationId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteNotificationSubscriptionRequest model) {
            super(model);
            this.subscriptionId(model.subscriptionId);
            this.organizationId(model.organizationId);
        }

        public final String getSubscriptionId() {
            return this.subscriptionId;
        }

        @Override
        public final Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public final void setSubscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
        }

        public final String getOrganizationId() {
            return this.organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteNotificationSubscriptionRequest build() {
            return new DeleteNotificationSubscriptionRequest(this);
        }
    }

    public static interface Builder
    extends WorkDocsRequest.Builder,
    CopyableBuilder<Builder, DeleteNotificationSubscriptionRequest> {
        public Builder subscriptionId(String var1);

        public Builder organizationId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

