/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.ResourceMetadata;

@SdkInternalApi
public class ResourceMetadataMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> ORIGINALNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OriginalName").build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").build();
    private static final MarshallingInfo<String> VERSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VersionId").build();
    private static final MarshallingInfo<StructuredPojo> OWNER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Owner").build();
    private static final MarshallingInfo<String> PARENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParentId").build();
    private static final ResourceMetadataMarshaller instance = new ResourceMetadataMarshaller();

    public static ResourceMetadataMarshaller getInstance() {
        return instance;
    }

    public void marshall(ResourceMetadata resourceMetadata, ProtocolMarshaller protocolMarshaller) {
        if (resourceMetadata == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)resourceMetadata.type(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)resourceMetadata.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)resourceMetadata.originalName(), ORIGINALNAME_BINDING);
            protocolMarshaller.marshall((Object)resourceMetadata.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)resourceMetadata.versionId(), VERSIONID_BINDING);
            protocolMarshaller.marshall((Object)resourceMetadata.owner(), OWNER_BINDING);
            protocolMarshaller.marshall((Object)resourceMetadata.parentId(), PARENTID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

