/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wisdom.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wisdom.WisdomClient;
import software.amazon.awssdk.services.wisdom.internal.UserAgentUtils;
import software.amazon.awssdk.services.wisdom.model.ListQuickResponsesRequest;
import software.amazon.awssdk.services.wisdom.model.ListQuickResponsesResponse;
import software.amazon.awssdk.services.wisdom.model.QuickResponseSummary;

public class ListQuickResponsesIterable
implements SdkIterable<ListQuickResponsesResponse> {
    private final WisdomClient client;
    private final ListQuickResponsesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListQuickResponsesIterable(WisdomClient client, ListQuickResponsesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListQuickResponsesResponseFetcher();
    }

    public Iterator<ListQuickResponsesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<QuickResponseSummary> quickResponseSummaries() {
        Function<ListQuickResponsesResponse, Iterator> getIterator = response -> {
            if (response != null && response.quickResponseSummaries() != null) {
                return response.quickResponseSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListQuickResponsesResponseFetcher
    implements SyncPageFetcher<ListQuickResponsesResponse> {
        private ListQuickResponsesResponseFetcher() {
        }

        public boolean hasNextPage(ListQuickResponsesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListQuickResponsesResponse nextPage(ListQuickResponsesResponse previousPage) {
            if (previousPage == null) {
                return ListQuickResponsesIterable.this.client.listQuickResponses(ListQuickResponsesIterable.this.firstRequest);
            }
            return ListQuickResponsesIterable.this.client.listQuickResponses((ListQuickResponsesRequest)((Object)ListQuickResponsesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

