/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wisdom.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.wisdom.model.KnowledgeBaseStatus;
import software.amazon.awssdk.services.wisdom.model.KnowledgeBaseType;
import software.amazon.awssdk.services.wisdom.model.RenderingConfiguration;
import software.amazon.awssdk.services.wisdom.model.ServerSideEncryptionConfiguration;
import software.amazon.awssdk.services.wisdom.model.SourceConfiguration;
import software.amazon.awssdk.services.wisdom.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KnowledgeBaseData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KnowledgeBaseData> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(KnowledgeBaseData.getter(KnowledgeBaseData::description)).setter(KnowledgeBaseData.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseArn").getter(KnowledgeBaseData.getter(KnowledgeBaseData::knowledgeBaseArn)).setter(KnowledgeBaseData.setter(Builder::knowledgeBaseArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseArn").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(KnowledgeBaseData.getter(KnowledgeBaseData::knowledgeBaseId)).setter(KnowledgeBaseData.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseType").getter(KnowledgeBaseData.getter(KnowledgeBaseData::knowledgeBaseTypeAsString)).setter(KnowledgeBaseData.setter(Builder::knowledgeBaseType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseType").build()}).build();
    private static final SdkField<Instant> LAST_CONTENT_MODIFICATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastContentModificationTime").getter(KnowledgeBaseData.getter(KnowledgeBaseData::lastContentModificationTime)).setter(KnowledgeBaseData.setter(Builder::lastContentModificationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastContentModificationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(KnowledgeBaseData.getter(KnowledgeBaseData::name)).setter(KnowledgeBaseData.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<RenderingConfiguration> RENDERING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("renderingConfiguration").getter(KnowledgeBaseData.getter(KnowledgeBaseData::renderingConfiguration)).setter(KnowledgeBaseData.setter(Builder::renderingConfiguration)).constructor(RenderingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renderingConfiguration").build()}).build();
    private static final SdkField<ServerSideEncryptionConfiguration> SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("serverSideEncryptionConfiguration").getter(KnowledgeBaseData.getter(KnowledgeBaseData::serverSideEncryptionConfiguration)).setter(KnowledgeBaseData.setter(Builder::serverSideEncryptionConfiguration)).constructor(ServerSideEncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverSideEncryptionConfiguration").build()}).build();
    private static final SdkField<SourceConfiguration> SOURCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceConfiguration").getter(KnowledgeBaseData.getter(KnowledgeBaseData::sourceConfiguration)).setter(KnowledgeBaseData.setter(Builder::sourceConfiguration)).constructor(SourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceConfiguration").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(KnowledgeBaseData.getter(KnowledgeBaseData::statusAsString)).setter(KnowledgeBaseData.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(KnowledgeBaseData.getter(KnowledgeBaseData::tags)).setter(KnowledgeBaseData.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, KNOWLEDGE_BASE_ARN_FIELD, KNOWLEDGE_BASE_ID_FIELD, KNOWLEDGE_BASE_TYPE_FIELD, LAST_CONTENT_MODIFICATION_TIME_FIELD, NAME_FIELD, RENDERING_CONFIGURATION_FIELD, SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD, SOURCE_CONFIGURATION_FIELD, STATUS_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String description;
    private final String knowledgeBaseArn;
    private final String knowledgeBaseId;
    private final String knowledgeBaseType;
    private final Instant lastContentModificationTime;
    private final String name;
    private final RenderingConfiguration renderingConfiguration;
    private final ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;
    private final SourceConfiguration sourceConfiguration;
    private final String status;
    private final Map<String, String> tags;

    private KnowledgeBaseData(BuilderImpl builder) {
        this.description = builder.description;
        this.knowledgeBaseArn = builder.knowledgeBaseArn;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.knowledgeBaseType = builder.knowledgeBaseType;
        this.lastContentModificationTime = builder.lastContentModificationTime;
        this.name = builder.name;
        this.renderingConfiguration = builder.renderingConfiguration;
        this.serverSideEncryptionConfiguration = builder.serverSideEncryptionConfiguration;
        this.sourceConfiguration = builder.sourceConfiguration;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    public final String description() {
        return this.description;
    }

    public final String knowledgeBaseArn() {
        return this.knowledgeBaseArn;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final KnowledgeBaseType knowledgeBaseType() {
        return KnowledgeBaseType.fromValue(this.knowledgeBaseType);
    }

    public final String knowledgeBaseTypeAsString() {
        return this.knowledgeBaseType;
    }

    public final Instant lastContentModificationTime() {
        return this.lastContentModificationTime;
    }

    public final String name() {
        return this.name;
    }

    public final RenderingConfiguration renderingConfiguration() {
        return this.renderingConfiguration;
    }

    public final ServerSideEncryptionConfiguration serverSideEncryptionConfiguration() {
        return this.serverSideEncryptionConfiguration;
    }

    public final SourceConfiguration sourceConfiguration() {
        return this.sourceConfiguration;
    }

    public final KnowledgeBaseStatus status() {
        return KnowledgeBaseStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastContentModificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.renderingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverSideEncryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KnowledgeBaseData)) {
            return false;
        }
        KnowledgeBaseData other = (KnowledgeBaseData)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.knowledgeBaseArn(), other.knowledgeBaseArn()) && Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(this.knowledgeBaseTypeAsString(), other.knowledgeBaseTypeAsString()) && Objects.equals(this.lastContentModificationTime(), other.lastContentModificationTime()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.renderingConfiguration(), other.renderingConfiguration()) && Objects.equals(this.serverSideEncryptionConfiguration(), other.serverSideEncryptionConfiguration()) && Objects.equals(this.sourceConfiguration(), other.sourceConfiguration()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"KnowledgeBaseData").add("Description", (Object)this.description()).add("KnowledgeBaseArn", (Object)this.knowledgeBaseArn()).add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("KnowledgeBaseType", (Object)this.knowledgeBaseTypeAsString()).add("LastContentModificationTime", (Object)this.lastContentModificationTime()).add("Name", (Object)this.name()).add("RenderingConfiguration", (Object)this.renderingConfiguration()).add("ServerSideEncryptionConfiguration", (Object)this.serverSideEncryptionConfiguration()).add("SourceConfiguration", (Object)this.sourceConfiguration()).add("Status", (Object)this.statusAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "knowledgeBaseArn": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseArn()));
            }
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "knowledgeBaseType": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseTypeAsString()));
            }
            case "lastContentModificationTime": {
                return Optional.ofNullable(clazz.cast(this.lastContentModificationTime()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "renderingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.renderingConfiguration()));
            }
            case "serverSideEncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.serverSideEncryptionConfiguration()));
            }
            case "sourceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sourceConfiguration()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KnowledgeBaseData, T> g) {
        return obj -> g.apply((KnowledgeBaseData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String knowledgeBaseArn;
        private String knowledgeBaseId;
        private String knowledgeBaseType;
        private Instant lastContentModificationTime;
        private String name;
        private RenderingConfiguration renderingConfiguration;
        private ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;
        private SourceConfiguration sourceConfiguration;
        private String status;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(KnowledgeBaseData model) {
            this.description(model.description);
            this.knowledgeBaseArn(model.knowledgeBaseArn);
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.knowledgeBaseType(model.knowledgeBaseType);
            this.lastContentModificationTime(model.lastContentModificationTime);
            this.name(model.name);
            this.renderingConfiguration(model.renderingConfiguration);
            this.serverSideEncryptionConfiguration(model.serverSideEncryptionConfiguration);
            this.sourceConfiguration(model.sourceConfiguration);
            this.status(model.status);
            this.tags(model.tags);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getKnowledgeBaseArn() {
            return this.knowledgeBaseArn;
        }

        public final void setKnowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
        }

        @Override
        public final Builder knowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getKnowledgeBaseType() {
            return this.knowledgeBaseType;
        }

        public final void setKnowledgeBaseType(String knowledgeBaseType) {
            this.knowledgeBaseType = knowledgeBaseType;
        }

        @Override
        public final Builder knowledgeBaseType(String knowledgeBaseType) {
            this.knowledgeBaseType = knowledgeBaseType;
            return this;
        }

        @Override
        public final Builder knowledgeBaseType(KnowledgeBaseType knowledgeBaseType) {
            this.knowledgeBaseType(knowledgeBaseType == null ? null : knowledgeBaseType.toString());
            return this;
        }

        public final Instant getLastContentModificationTime() {
            return this.lastContentModificationTime;
        }

        public final void setLastContentModificationTime(Instant lastContentModificationTime) {
            this.lastContentModificationTime = lastContentModificationTime;
        }

        @Override
        public final Builder lastContentModificationTime(Instant lastContentModificationTime) {
            this.lastContentModificationTime = lastContentModificationTime;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final RenderingConfiguration.Builder getRenderingConfiguration() {
            return this.renderingConfiguration != null ? this.renderingConfiguration.toBuilder() : null;
        }

        public final void setRenderingConfiguration(RenderingConfiguration.BuilderImpl renderingConfiguration) {
            this.renderingConfiguration = renderingConfiguration != null ? renderingConfiguration.build() : null;
        }

        @Override
        public final Builder renderingConfiguration(RenderingConfiguration renderingConfiguration) {
            this.renderingConfiguration = renderingConfiguration;
            return this;
        }

        public final ServerSideEncryptionConfiguration.Builder getServerSideEncryptionConfiguration() {
            return this.serverSideEncryptionConfiguration != null ? this.serverSideEncryptionConfiguration.toBuilder() : null;
        }

        public final void setServerSideEncryptionConfiguration(ServerSideEncryptionConfiguration.BuilderImpl serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration != null ? serverSideEncryptionConfiguration.build() : null;
        }

        @Override
        public final Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
            return this;
        }

        public final SourceConfiguration.Builder getSourceConfiguration() {
            return this.sourceConfiguration != null ? this.sourceConfiguration.toBuilder() : null;
        }

        public final void setSourceConfiguration(SourceConfiguration.BuilderImpl sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration != null ? sourceConfiguration.build() : null;
        }

        @Override
        public final Builder sourceConfiguration(SourceConfiguration sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(KnowledgeBaseStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public KnowledgeBaseData build() {
            return new KnowledgeBaseData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KnowledgeBaseData> {
        public Builder description(String var1);

        public Builder knowledgeBaseArn(String var1);

        public Builder knowledgeBaseId(String var1);

        public Builder knowledgeBaseType(String var1);

        public Builder knowledgeBaseType(KnowledgeBaseType var1);

        public Builder lastContentModificationTime(Instant var1);

        public Builder name(String var1);

        public Builder renderingConfiguration(RenderingConfiguration var1);

        default public Builder renderingConfiguration(Consumer<RenderingConfiguration.Builder> renderingConfiguration) {
            return this.renderingConfiguration((RenderingConfiguration)((RenderingConfiguration.Builder)RenderingConfiguration.builder().applyMutation(renderingConfiguration)).build());
        }

        public Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration var1);

        default public Builder serverSideEncryptionConfiguration(Consumer<ServerSideEncryptionConfiguration.Builder> serverSideEncryptionConfiguration) {
            return this.serverSideEncryptionConfiguration((ServerSideEncryptionConfiguration)((ServerSideEncryptionConfiguration.Builder)ServerSideEncryptionConfiguration.builder().applyMutation(serverSideEncryptionConfiguration)).build());
        }

        public Builder sourceConfiguration(SourceConfiguration var1);

        default public Builder sourceConfiguration(Consumer<SourceConfiguration.Builder> sourceConfiguration) {
            return this.sourceConfiguration((SourceConfiguration)((SourceConfiguration.Builder)SourceConfiguration.builder().applyMutation(sourceConfiguration)).build());
        }

        public Builder status(String var1);

        public Builder status(KnowledgeBaseStatus var1);

        public Builder tags(Map<String, String> var1);
    }
}

