/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wisdom.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Relevance {
    HELPFUL("HELPFUL"),
    NOT_HELPFUL("NOT_HELPFUL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Relevance> VALUE_MAP;
    private final String value;

    private Relevance(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Relevance fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Relevance> knownValues() {
        EnumSet<Relevance> knownValues = EnumSet.allOf(Relevance.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Relevance.class, Relevance::toString);
    }
}

