/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wisdom;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.wisdom.WisdomClient;
import software.amazon.awssdk.services.wisdom.model.AccessDeniedException;
import software.amazon.awssdk.services.wisdom.model.ConflictException;
import software.amazon.awssdk.services.wisdom.model.CreateAssistantAssociationRequest;
import software.amazon.awssdk.services.wisdom.model.CreateAssistantAssociationResponse;
import software.amazon.awssdk.services.wisdom.model.CreateAssistantRequest;
import software.amazon.awssdk.services.wisdom.model.CreateAssistantResponse;
import software.amazon.awssdk.services.wisdom.model.CreateContentRequest;
import software.amazon.awssdk.services.wisdom.model.CreateContentResponse;
import software.amazon.awssdk.services.wisdom.model.CreateKnowledgeBaseRequest;
import software.amazon.awssdk.services.wisdom.model.CreateKnowledgeBaseResponse;
import software.amazon.awssdk.services.wisdom.model.CreateSessionRequest;
import software.amazon.awssdk.services.wisdom.model.CreateSessionResponse;
import software.amazon.awssdk.services.wisdom.model.DeleteAssistantAssociationRequest;
import software.amazon.awssdk.services.wisdom.model.DeleteAssistantAssociationResponse;
import software.amazon.awssdk.services.wisdom.model.DeleteAssistantRequest;
import software.amazon.awssdk.services.wisdom.model.DeleteAssistantResponse;
import software.amazon.awssdk.services.wisdom.model.DeleteContentRequest;
import software.amazon.awssdk.services.wisdom.model.DeleteContentResponse;
import software.amazon.awssdk.services.wisdom.model.DeleteKnowledgeBaseRequest;
import software.amazon.awssdk.services.wisdom.model.DeleteKnowledgeBaseResponse;
import software.amazon.awssdk.services.wisdom.model.GetAssistantAssociationRequest;
import software.amazon.awssdk.services.wisdom.model.GetAssistantAssociationResponse;
import software.amazon.awssdk.services.wisdom.model.GetAssistantRequest;
import software.amazon.awssdk.services.wisdom.model.GetAssistantResponse;
import software.amazon.awssdk.services.wisdom.model.GetContentRequest;
import software.amazon.awssdk.services.wisdom.model.GetContentResponse;
import software.amazon.awssdk.services.wisdom.model.GetContentSummaryRequest;
import software.amazon.awssdk.services.wisdom.model.GetContentSummaryResponse;
import software.amazon.awssdk.services.wisdom.model.GetKnowledgeBaseRequest;
import software.amazon.awssdk.services.wisdom.model.GetKnowledgeBaseResponse;
import software.amazon.awssdk.services.wisdom.model.GetRecommendationsRequest;
import software.amazon.awssdk.services.wisdom.model.GetRecommendationsResponse;
import software.amazon.awssdk.services.wisdom.model.GetSessionRequest;
import software.amazon.awssdk.services.wisdom.model.GetSessionResponse;
import software.amazon.awssdk.services.wisdom.model.ListAssistantAssociationsRequest;
import software.amazon.awssdk.services.wisdom.model.ListAssistantAssociationsResponse;
import software.amazon.awssdk.services.wisdom.model.ListAssistantsRequest;
import software.amazon.awssdk.services.wisdom.model.ListAssistantsResponse;
import software.amazon.awssdk.services.wisdom.model.ListContentsRequest;
import software.amazon.awssdk.services.wisdom.model.ListContentsResponse;
import software.amazon.awssdk.services.wisdom.model.ListKnowledgeBasesRequest;
import software.amazon.awssdk.services.wisdom.model.ListKnowledgeBasesResponse;
import software.amazon.awssdk.services.wisdom.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.wisdom.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.wisdom.model.NotifyRecommendationsReceivedRequest;
import software.amazon.awssdk.services.wisdom.model.NotifyRecommendationsReceivedResponse;
import software.amazon.awssdk.services.wisdom.model.PreconditionFailedException;
import software.amazon.awssdk.services.wisdom.model.QueryAssistantRequest;
import software.amazon.awssdk.services.wisdom.model.QueryAssistantResponse;
import software.amazon.awssdk.services.wisdom.model.RemoveKnowledgeBaseTemplateUriRequest;
import software.amazon.awssdk.services.wisdom.model.RemoveKnowledgeBaseTemplateUriResponse;
import software.amazon.awssdk.services.wisdom.model.ResourceNotFoundException;
import software.amazon.awssdk.services.wisdom.model.SearchContentRequest;
import software.amazon.awssdk.services.wisdom.model.SearchContentResponse;
import software.amazon.awssdk.services.wisdom.model.SearchSessionsRequest;
import software.amazon.awssdk.services.wisdom.model.SearchSessionsResponse;
import software.amazon.awssdk.services.wisdom.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.wisdom.model.StartContentUploadRequest;
import software.amazon.awssdk.services.wisdom.model.StartContentUploadResponse;
import software.amazon.awssdk.services.wisdom.model.TagResourceRequest;
import software.amazon.awssdk.services.wisdom.model.TagResourceResponse;
import software.amazon.awssdk.services.wisdom.model.TooManyTagsException;
import software.amazon.awssdk.services.wisdom.model.UntagResourceRequest;
import software.amazon.awssdk.services.wisdom.model.UntagResourceResponse;
import software.amazon.awssdk.services.wisdom.model.UpdateContentRequest;
import software.amazon.awssdk.services.wisdom.model.UpdateContentResponse;
import software.amazon.awssdk.services.wisdom.model.UpdateKnowledgeBaseTemplateUriRequest;
import software.amazon.awssdk.services.wisdom.model.UpdateKnowledgeBaseTemplateUriResponse;
import software.amazon.awssdk.services.wisdom.model.ValidationException;
import software.amazon.awssdk.services.wisdom.model.WisdomException;
import software.amazon.awssdk.services.wisdom.model.WisdomRequest;
import software.amazon.awssdk.services.wisdom.paginators.ListAssistantAssociationsIterable;
import software.amazon.awssdk.services.wisdom.paginators.ListAssistantsIterable;
import software.amazon.awssdk.services.wisdom.paginators.ListContentsIterable;
import software.amazon.awssdk.services.wisdom.paginators.ListKnowledgeBasesIterable;
import software.amazon.awssdk.services.wisdom.paginators.QueryAssistantIterable;
import software.amazon.awssdk.services.wisdom.paginators.SearchContentIterable;
import software.amazon.awssdk.services.wisdom.paginators.SearchSessionsIterable;
import software.amazon.awssdk.services.wisdom.transform.CreateAssistantAssociationRequestMarshaller;
import software.amazon.awssdk.services.wisdom.transform.CreateAssistantRequestMarshaller;
import software.amazon.awssdk.services.wisdom.transform.CreateContentRequestMarshaller;
import software.amazon.awssdk.services.wisdom.transform.CreateKnowledgeBaseRequestMarshaller;
import software.amazon.awssdk.services.wisdom.transform.CreateSessionRequestMarshaller;
import software.amazon.awssdk.services.wisdom.transform.DeleteAssistantAssociationRequestMarshaller;
import software.amazon.awssdk.services.wisdom.transform.DeleteAssistantRequestMarshaller;
import software.amazon.awssdk.services.wisdom.transform.DeleteContentRequestMarshaller;
import software.amazon.awssdk.services.wisdom.transform.DeleteKnowledgeBaseRequestMarshaller;
import software.amazon.awssdk.services.wisdom.transform.GetAssistantAssociationRequestMarshaller;
import software.amazon.awssdk.services.wisdom.transform.GetAssistantRequestMarshaller;
import software.amazon.awssdk.services.wisdom.transform.GetContentRequestMarshaller;
import software.amazon.awssdk.services.wisdom.transform.GetContentSummaryRequestMarshaller;
import software.amazon.awssdk.services.wisdom.transform.GetKnowledgeBaseRequestMarshaller;
import software.amazon.awssdk.services.wisdom.transform.GetRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.wisdom.transform.GetSessionRequestMarshaller;
import software.amazon.awssdk.services.wisdom.transform.ListAssistantAssociationsRequestMarshaller;
import software.amazon.awssdk.services.wisdom.transform.ListAssistantsRequestMarshaller;
import software.amazon.awssdk.services.wisdom.transform.ListContentsRequestMarshaller;
import software.amazon.awssdk.services.wisdom.transform.ListKnowledgeBasesRequestMarshaller;
import software.amazon.awssdk.services.wisdom.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.wisdom.transform.NotifyRecommendationsReceivedRequestMarshaller;
import software.amazon.awssdk.services.wisdom.transform.QueryAssistantRequestMarshaller;
import software.amazon.awssdk.services.wisdom.transform.RemoveKnowledgeBaseTemplateUriRequestMarshaller;
import software.amazon.awssdk.services.wisdom.transform.SearchContentRequestMarshaller;
import software.amazon.awssdk.services.wisdom.transform.SearchSessionsRequestMarshaller;
import software.amazon.awssdk.services.wisdom.transform.StartContentUploadRequestMarshaller;
import software.amazon.awssdk.services.wisdom.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.wisdom.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.wisdom.transform.UpdateContentRequestMarshaller;
import software.amazon.awssdk.services.wisdom.transform.UpdateKnowledgeBaseTemplateUriRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultWisdomClient
implements WisdomClient {
    private static final Logger log = Logger.loggerFor(DefaultWisdomClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultWisdomClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "wisdom";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAssistantResponse createAssistant(CreateAssistantRequest createAssistantRequest) throws ConflictException, ValidationException, ServiceQuotaExceededException, AccessDeniedException, AwsServiceException, SdkClientException, WisdomException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAssistantResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWisdomClient.resolveMetricPublishers(this.clientConfiguration, createAssistantRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wisdom");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAssistant");
            CreateAssistantResponse createAssistantResponse = (CreateAssistantResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAssistant").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAssistantRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAssistantRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAssistantResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWisdomClient.lambda$createAssistant$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAssistantAssociationResponse createAssistantAssociation(CreateAssistantAssociationRequest createAssistantAssociationRequest) throws ConflictException, ValidationException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAssistantAssociationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWisdomClient.resolveMetricPublishers(this.clientConfiguration, createAssistantAssociationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wisdom");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAssistantAssociation");
            CreateAssistantAssociationResponse createAssistantAssociationResponse = (CreateAssistantAssociationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAssistantAssociation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAssistantAssociationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAssistantAssociationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAssistantAssociationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWisdomClient.lambda$createAssistantAssociation$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateContentResponse createContent(CreateContentRequest createContentRequest) throws ConflictException, ValidationException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateContentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWisdomClient.resolveMetricPublishers(this.clientConfiguration, createContentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wisdom");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateContent");
            CreateContentResponse createContentResponse = (CreateContentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateContent").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createContentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateContentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createContentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWisdomClient.lambda$createContent$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateKnowledgeBaseResponse createKnowledgeBase(CreateKnowledgeBaseRequest createKnowledgeBaseRequest) throws ConflictException, ValidationException, ServiceQuotaExceededException, AccessDeniedException, AwsServiceException, SdkClientException, WisdomException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateKnowledgeBaseResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWisdomClient.resolveMetricPublishers(this.clientConfiguration, createKnowledgeBaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wisdom");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateKnowledgeBase");
            CreateKnowledgeBaseResponse createKnowledgeBaseResponse = (CreateKnowledgeBaseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateKnowledgeBase").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createKnowledgeBaseRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateKnowledgeBaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createKnowledgeBaseResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWisdomClient.lambda$createKnowledgeBase$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSessionResponse createSession(CreateSessionRequest createSessionRequest) throws ConflictException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSessionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWisdomClient.resolveMetricPublishers(this.clientConfiguration, createSessionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wisdom");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSession");
            CreateSessionResponse createSessionResponse = (CreateSessionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSession").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSessionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSessionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWisdomClient.lambda$createSession$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAssistantResponse deleteAssistant(DeleteAssistantRequest deleteAssistantRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAssistantResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWisdomClient.resolveMetricPublishers(this.clientConfiguration, deleteAssistantRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wisdom");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAssistant");
            DeleteAssistantResponse deleteAssistantResponse = (DeleteAssistantResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAssistant").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAssistantRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAssistantRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAssistantResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWisdomClient.lambda$deleteAssistant$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAssistantAssociationResponse deleteAssistantAssociation(DeleteAssistantAssociationRequest deleteAssistantAssociationRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAssistantAssociationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWisdomClient.resolveMetricPublishers(this.clientConfiguration, deleteAssistantAssociationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wisdom");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAssistantAssociation");
            DeleteAssistantAssociationResponse deleteAssistantAssociationResponse = (DeleteAssistantAssociationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAssistantAssociation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAssistantAssociationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAssistantAssociationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAssistantAssociationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWisdomClient.lambda$deleteAssistantAssociation$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteContentResponse deleteContent(DeleteContentRequest deleteContentRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteContentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWisdomClient.resolveMetricPublishers(this.clientConfiguration, deleteContentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wisdom");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteContent");
            DeleteContentResponse deleteContentResponse = (DeleteContentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteContent").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteContentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteContentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteContentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWisdomClient.lambda$deleteContent$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteKnowledgeBaseResponse deleteKnowledgeBase(DeleteKnowledgeBaseRequest deleteKnowledgeBaseRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteKnowledgeBaseResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWisdomClient.resolveMetricPublishers(this.clientConfiguration, deleteKnowledgeBaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wisdom");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteKnowledgeBase");
            DeleteKnowledgeBaseResponse deleteKnowledgeBaseResponse = (DeleteKnowledgeBaseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteKnowledgeBase").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteKnowledgeBaseRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteKnowledgeBaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteKnowledgeBaseResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWisdomClient.lambda$deleteKnowledgeBase$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAssistantResponse getAssistant(GetAssistantRequest getAssistantRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAssistantResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWisdomClient.resolveMetricPublishers(this.clientConfiguration, getAssistantRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wisdom");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAssistant");
            GetAssistantResponse getAssistantResponse = (GetAssistantResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAssistant").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAssistantRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAssistantRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAssistantResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWisdomClient.lambda$getAssistant$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAssistantAssociationResponse getAssistantAssociation(GetAssistantAssociationRequest getAssistantAssociationRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAssistantAssociationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWisdomClient.resolveMetricPublishers(this.clientConfiguration, getAssistantAssociationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wisdom");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAssistantAssociation");
            GetAssistantAssociationResponse getAssistantAssociationResponse = (GetAssistantAssociationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAssistantAssociation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAssistantAssociationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAssistantAssociationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAssistantAssociationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWisdomClient.lambda$getAssistantAssociation$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetContentResponse getContent(GetContentRequest getContentRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetContentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWisdomClient.resolveMetricPublishers(this.clientConfiguration, getContentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wisdom");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetContent");
            GetContentResponse getContentResponse = (GetContentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetContent").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getContentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetContentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getContentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWisdomClient.lambda$getContent$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetContentSummaryResponse getContentSummary(GetContentSummaryRequest getContentSummaryRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetContentSummaryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWisdomClient.resolveMetricPublishers(this.clientConfiguration, getContentSummaryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wisdom");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetContentSummary");
            GetContentSummaryResponse getContentSummaryResponse = (GetContentSummaryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetContentSummary").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getContentSummaryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetContentSummaryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getContentSummaryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWisdomClient.lambda$getContentSummary$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetKnowledgeBaseResponse getKnowledgeBase(GetKnowledgeBaseRequest getKnowledgeBaseRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetKnowledgeBaseResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWisdomClient.resolveMetricPublishers(this.clientConfiguration, getKnowledgeBaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wisdom");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetKnowledgeBase");
            GetKnowledgeBaseResponse getKnowledgeBaseResponse = (GetKnowledgeBaseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetKnowledgeBase").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getKnowledgeBaseRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetKnowledgeBaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getKnowledgeBaseResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWisdomClient.lambda$getKnowledgeBase$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRecommendationsResponse getRecommendations(GetRecommendationsRequest getRecommendationsRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRecommendationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWisdomClient.resolveMetricPublishers(this.clientConfiguration, getRecommendationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wisdom");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRecommendations");
            GetRecommendationsResponse getRecommendationsResponse = (GetRecommendationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRecommendations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getRecommendationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRecommendationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRecommendationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWisdomClient.lambda$getRecommendations$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSessionResponse getSession(GetSessionRequest getSessionRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSessionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWisdomClient.resolveMetricPublishers(this.clientConfiguration, getSessionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wisdom");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSession");
            GetSessionResponse getSessionResponse = (GetSessionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSession").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSessionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSessionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWisdomClient.lambda$getSession$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAssistantAssociationsResponse listAssistantAssociations(ListAssistantAssociationsRequest listAssistantAssociationsRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAssistantAssociationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWisdomClient.resolveMetricPublishers(this.clientConfiguration, listAssistantAssociationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wisdom");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAssistantAssociations");
            ListAssistantAssociationsResponse listAssistantAssociationsResponse = (ListAssistantAssociationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAssistantAssociations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAssistantAssociationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAssistantAssociationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAssistantAssociationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWisdomClient.lambda$listAssistantAssociations$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListAssistantAssociationsIterable listAssistantAssociationsPaginator(ListAssistantAssociationsRequest listAssistantAssociationsRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        return new ListAssistantAssociationsIterable(this, this.applyPaginatorUserAgent(listAssistantAssociationsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAssistantsResponse listAssistants(ListAssistantsRequest listAssistantsRequest) throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, WisdomException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAssistantsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWisdomClient.resolveMetricPublishers(this.clientConfiguration, listAssistantsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wisdom");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAssistants");
            ListAssistantsResponse listAssistantsResponse = (ListAssistantsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAssistants").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAssistantsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAssistantsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAssistantsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWisdomClient.lambda$listAssistants$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListAssistantsIterable listAssistantsPaginator(ListAssistantsRequest listAssistantsRequest) throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, WisdomException {
        return new ListAssistantsIterable(this, this.applyPaginatorUserAgent(listAssistantsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListContentsResponse listContents(ListContentsRequest listContentsRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListContentsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWisdomClient.resolveMetricPublishers(this.clientConfiguration, listContentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wisdom");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListContents");
            ListContentsResponse listContentsResponse = (ListContentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListContents").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listContentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListContentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listContentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWisdomClient.lambda$listContents$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListContentsIterable listContentsPaginator(ListContentsRequest listContentsRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        return new ListContentsIterable(this, this.applyPaginatorUserAgent(listContentsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListKnowledgeBasesResponse listKnowledgeBases(ListKnowledgeBasesRequest listKnowledgeBasesRequest) throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, WisdomException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListKnowledgeBasesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWisdomClient.resolveMetricPublishers(this.clientConfiguration, listKnowledgeBasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wisdom");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListKnowledgeBases");
            ListKnowledgeBasesResponse listKnowledgeBasesResponse = (ListKnowledgeBasesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListKnowledgeBases").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listKnowledgeBasesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListKnowledgeBasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listKnowledgeBasesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWisdomClient.lambda$listKnowledgeBases$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListKnowledgeBasesIterable listKnowledgeBasesPaginator(ListKnowledgeBasesRequest listKnowledgeBasesRequest) throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, WisdomException {
        return new ListKnowledgeBasesIterable(this, this.applyPaginatorUserAgent(listKnowledgeBasesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWisdomClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wisdom");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWisdomClient.lambda$listTagsForResource$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NotifyRecommendationsReceivedResponse notifyRecommendationsReceived(NotifyRecommendationsReceivedRequest notifyRecommendationsReceivedRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, NotifyRecommendationsReceivedResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWisdomClient.resolveMetricPublishers(this.clientConfiguration, notifyRecommendationsReceivedRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wisdom");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"NotifyRecommendationsReceived");
            NotifyRecommendationsReceivedResponse notifyRecommendationsReceivedResponse = (NotifyRecommendationsReceivedResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("NotifyRecommendationsReceived").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)notifyRecommendationsReceivedRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new NotifyRecommendationsReceivedRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return notifyRecommendationsReceivedResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWisdomClient.lambda$notifyRecommendationsReceived$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryAssistantResponse queryAssistant(QueryAssistantRequest queryAssistantRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, QueryAssistantResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWisdomClient.resolveMetricPublishers(this.clientConfiguration, queryAssistantRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wisdom");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"QueryAssistant");
            QueryAssistantResponse queryAssistantResponse = (QueryAssistantResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("QueryAssistant").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)queryAssistantRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new QueryAssistantRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return queryAssistantResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWisdomClient.lambda$queryAssistant$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public QueryAssistantIterable queryAssistantPaginator(QueryAssistantRequest queryAssistantRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        return new QueryAssistantIterable(this, this.applyPaginatorUserAgent(queryAssistantRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveKnowledgeBaseTemplateUriResponse removeKnowledgeBaseTemplateUri(RemoveKnowledgeBaseTemplateUriRequest removeKnowledgeBaseTemplateUriRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveKnowledgeBaseTemplateUriResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWisdomClient.resolveMetricPublishers(this.clientConfiguration, removeKnowledgeBaseTemplateUriRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wisdom");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveKnowledgeBaseTemplateUri");
            RemoveKnowledgeBaseTemplateUriResponse removeKnowledgeBaseTemplateUriResponse = (RemoveKnowledgeBaseTemplateUriResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveKnowledgeBaseTemplateUri").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeKnowledgeBaseTemplateUriRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveKnowledgeBaseTemplateUriRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return removeKnowledgeBaseTemplateUriResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWisdomClient.lambda$removeKnowledgeBaseTemplateUri$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchContentResponse searchContent(SearchContentRequest searchContentRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchContentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWisdomClient.resolveMetricPublishers(this.clientConfiguration, searchContentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wisdom");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SearchContent");
            SearchContentResponse searchContentResponse = (SearchContentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchContent").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)searchContentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SearchContentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return searchContentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWisdomClient.lambda$searchContent$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public SearchContentIterable searchContentPaginator(SearchContentRequest searchContentRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        return new SearchContentIterable(this, this.applyPaginatorUserAgent(searchContentRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchSessionsResponse searchSessions(SearchSessionsRequest searchSessionsRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchSessionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWisdomClient.resolveMetricPublishers(this.clientConfiguration, searchSessionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wisdom");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SearchSessions");
            SearchSessionsResponse searchSessionsResponse = (SearchSessionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchSessions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)searchSessionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SearchSessionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return searchSessionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWisdomClient.lambda$searchSessions$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public SearchSessionsIterable searchSessionsPaginator(SearchSessionsRequest searchSessionsRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        return new SearchSessionsIterable(this, this.applyPaginatorUserAgent(searchSessionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartContentUploadResponse startContentUpload(StartContentUploadRequest startContentUploadRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartContentUploadResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWisdomClient.resolveMetricPublishers(this.clientConfiguration, startContentUploadRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wisdom");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartContentUpload");
            StartContentUploadResponse startContentUploadResponse = (StartContentUploadResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartContentUpload").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startContentUploadRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartContentUploadRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startContentUploadResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWisdomClient.lambda$startContentUpload$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws TooManyTagsException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWisdomClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wisdom");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWisdomClient.lambda$tagResource$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWisdomClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wisdom");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWisdomClient.lambda$untagResource$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateContentResponse updateContent(UpdateContentRequest updateContentRequest) throws ValidationException, AccessDeniedException, PreconditionFailedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateContentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWisdomClient.resolveMetricPublishers(this.clientConfiguration, updateContentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wisdom");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateContent");
            UpdateContentResponse updateContentResponse = (UpdateContentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateContent").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateContentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateContentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateContentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWisdomClient.lambda$updateContent$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateKnowledgeBaseTemplateUriResponse updateKnowledgeBaseTemplateUri(UpdateKnowledgeBaseTemplateUriRequest updateKnowledgeBaseTemplateUriRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateKnowledgeBaseTemplateUriResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWisdomClient.resolveMetricPublishers(this.clientConfiguration, updateKnowledgeBaseTemplateUriRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wisdom");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateKnowledgeBaseTemplateUri");
            UpdateKnowledgeBaseTemplateUriResponse updateKnowledgeBaseTemplateUriResponse = (UpdateKnowledgeBaseTemplateUriResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateKnowledgeBaseTemplateUri").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateKnowledgeBaseTemplateUriRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateKnowledgeBaseTemplateUriRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateKnowledgeBaseTemplateUriResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWisdomClient.lambda$updateKnowledgeBaseTemplateUri$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(WisdomException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTagsException").exceptionBuilderSupplier(TooManyTagsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PreconditionFailedException").exceptionBuilderSupplier(PreconditionFailedException::builder).httpStatusCode(Integer.valueOf(412)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends WisdomRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.17.175").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((WisdomRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$updateKnowledgeBaseTemplateUri$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateContent$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startContentUpload$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$searchSessions$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$searchContent$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeKnowledgeBaseTemplateUri$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$queryAssistant$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$notifyRecommendationsReceived$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listKnowledgeBases$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listContents$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAssistants$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAssistantAssociations$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSession$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRecommendations$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getKnowledgeBase$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getContentSummary$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getContent$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAssistantAssociation$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAssistant$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteKnowledgeBase$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteContent$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAssistantAssociation$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAssistant$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSession$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createKnowledgeBase$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createContent$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAssistantAssociation$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAssistant$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

