/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wickr.WickrAsyncClient;
import software.amazon.awssdk.services.wickr.internal.UserAgentUtils;
import software.amazon.awssdk.services.wickr.model.GuestUser;
import software.amazon.awssdk.services.wickr.model.ListGuestUsersRequest;
import software.amazon.awssdk.services.wickr.model.ListGuestUsersResponse;

public class ListGuestUsersPublisher
implements SdkPublisher<ListGuestUsersResponse> {
    private final WickrAsyncClient client;
    private final ListGuestUsersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListGuestUsersPublisher(WickrAsyncClient client, ListGuestUsersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListGuestUsersPublisher(WickrAsyncClient client, ListGuestUsersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListGuestUsersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListGuestUsersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GuestUser> guestlist() {
        Function<ListGuestUsersResponse, Iterator> getIterator = response -> {
            if (response != null && response.guestlist() != null) {
                return response.guestlist().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListGuestUsersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListGuestUsersResponseFetcher
    implements AsyncPageFetcher<ListGuestUsersResponse> {
        private ListGuestUsersResponseFetcher() {
        }

        public boolean hasNextPage(ListGuestUsersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListGuestUsersResponse> nextPage(ListGuestUsersResponse previousPage) {
            if (previousPage == null) {
                return ListGuestUsersPublisher.this.client.listGuestUsers(ListGuestUsersPublisher.this.firstRequest);
            }
            return ListGuestUsersPublisher.this.client.listGuestUsers((ListGuestUsersRequest)((Object)ListGuestUsersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

