/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wickr.WickrAsyncClient;
import software.amazon.awssdk.services.wickr.internal.UserAgentUtils;
import software.amazon.awssdk.services.wickr.model.BasicDeviceObject;
import software.amazon.awssdk.services.wickr.model.ListDevicesForUserRequest;
import software.amazon.awssdk.services.wickr.model.ListDevicesForUserResponse;

public class ListDevicesForUserPublisher
implements SdkPublisher<ListDevicesForUserResponse> {
    private final WickrAsyncClient client;
    private final ListDevicesForUserRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDevicesForUserPublisher(WickrAsyncClient client, ListDevicesForUserRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDevicesForUserPublisher(WickrAsyncClient client, ListDevicesForUserRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDevicesForUserResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDevicesForUserResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<BasicDeviceObject> devices() {
        Function<ListDevicesForUserResponse, Iterator> getIterator = response -> {
            if (response != null && response.devices() != null) {
                return response.devices().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDevicesForUserResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDevicesForUserResponseFetcher
    implements AsyncPageFetcher<ListDevicesForUserResponse> {
        private ListDevicesForUserResponseFetcher() {
        }

        public boolean hasNextPage(ListDevicesForUserResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDevicesForUserResponse> nextPage(ListDevicesForUserResponse previousPage) {
            if (previousPage == null) {
                return ListDevicesForUserPublisher.this.client.listDevicesForUser(ListDevicesForUserPublisher.this.firstRequest);
            }
            return ListDevicesForUserPublisher.this.client.listDevicesForUser((ListDevicesForUserRequest)((Object)ListDevicesForUserPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

