/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wickr.model.SortDirection;
import software.amazon.awssdk.services.wickr.model.WickrRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListUsersRequest
extends WickrRequest
implements ToCopyableBuilder<Builder, ListUsersRequest> {
    private static final SdkField<String> NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkId").getter(ListUsersRequest.getter(ListUsersRequest::networkId)).setter(ListUsersRequest.setter(Builder::networkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("networkId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListUsersRequest.getter(ListUsersRequest::nextToken)).setter(ListUsersRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListUsersRequest.getter(ListUsersRequest::maxResults)).setter(ListUsersRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> SORT_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortFields").getter(ListUsersRequest.getter(ListUsersRequest::sortFields)).setter(ListUsersRequest.setter(Builder::sortFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortFields").build()}).build();
    private static final SdkField<String> SORT_DIRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortDirection").getter(ListUsersRequest.getter(ListUsersRequest::sortDirectionAsString)).setter(ListUsersRequest.setter(Builder::sortDirection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortDirection").build()}).build();
    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("firstName").getter(ListUsersRequest.getter(ListUsersRequest::firstName)).setter(ListUsersRequest.setter(Builder::firstName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("firstName").build()}).build();
    private static final SdkField<String> LAST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastName").getter(ListUsersRequest.getter(ListUsersRequest::lastName)).setter(ListUsersRequest.setter(Builder::lastName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("lastName").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("username").getter(ListUsersRequest.getter(ListUsersRequest::username)).setter(ListUsersRequest.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("username").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("status").getter(ListUsersRequest.getter(ListUsersRequest::status)).setter(ListUsersRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build()}).build();
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groupId").getter(ListUsersRequest.getter(ListUsersRequest::groupId)).setter(ListUsersRequest.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("groupId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_ID_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, SORT_FIELDS_FIELD, SORT_DIRECTION_FIELD, FIRST_NAME_FIELD, LAST_NAME_FIELD, USERNAME_FIELD, STATUS_FIELD, GROUP_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListUsersRequest.memberNameToFieldInitializer();
    private final String networkId;
    private final String nextToken;
    private final Integer maxResults;
    private final String sortFields;
    private final String sortDirection;
    private final String firstName;
    private final String lastName;
    private final String username;
    private final Integer status;
    private final String groupId;

    private ListUsersRequest(BuilderImpl builder) {
        super(builder);
        this.networkId = builder.networkId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.sortFields = builder.sortFields;
        this.sortDirection = builder.sortDirection;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.username = builder.username;
        this.status = builder.status;
        this.groupId = builder.groupId;
    }

    public final String networkId() {
        return this.networkId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String sortFields() {
        return this.sortFields;
    }

    public final SortDirection sortDirection() {
        return SortDirection.fromValue(this.sortDirection);
    }

    public final String sortDirectionAsString() {
        return this.sortDirection;
    }

    public final String firstName() {
        return this.firstName;
    }

    public final String lastName() {
        return this.lastName;
    }

    public final String username() {
        return this.username;
    }

    public final Integer status() {
        return this.status;
    }

    public final String groupId() {
        return this.groupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.networkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortFields());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortDirectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastName());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUsersRequest)) {
            return false;
        }
        ListUsersRequest other = (ListUsersRequest)((Object)obj);
        return Objects.equals(this.networkId(), other.networkId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.sortFields(), other.sortFields()) && Objects.equals(this.sortDirectionAsString(), other.sortDirectionAsString()) && Objects.equals(this.firstName(), other.firstName()) && Objects.equals(this.lastName(), other.lastName()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.groupId(), other.groupId());
    }

    public final String toString() {
        return ToString.builder((String)"ListUsersRequest").add("NetworkId", (Object)this.networkId()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("SortFields", (Object)this.sortFields()).add("SortDirection", (Object)this.sortDirectionAsString()).add("FirstName", (Object)(this.firstName() == null ? null : "*** Sensitive Data Redacted ***")).add("LastName", (Object)(this.lastName() == null ? null : "*** Sensitive Data Redacted ***")).add("Username", (Object)this.username()).add("Status", (Object)this.status()).add("GroupId", (Object)this.groupId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "networkId": {
                return Optional.ofNullable(clazz.cast(this.networkId()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "sortFields": {
                return Optional.ofNullable(clazz.cast(this.sortFields()));
            }
            case "sortDirection": {
                return Optional.ofNullable(clazz.cast(this.sortDirectionAsString()));
            }
            case "firstName": {
                return Optional.ofNullable(clazz.cast(this.firstName()));
            }
            case "lastName": {
                return Optional.ofNullable(clazz.cast(this.lastName()));
            }
            case "username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "groupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("networkId", NETWORK_ID_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("sortFields", SORT_FIELDS_FIELD);
        map.put("sortDirection", SORT_DIRECTION_FIELD);
        map.put("firstName", FIRST_NAME_FIELD);
        map.put("lastName", LAST_NAME_FIELD);
        map.put("username", USERNAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("groupId", GROUP_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListUsersRequest, T> g) {
        return obj -> g.apply((ListUsersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WickrRequest.BuilderImpl
    implements Builder {
        private String networkId;
        private String nextToken;
        private Integer maxResults;
        private String sortFields;
        private String sortDirection;
        private String firstName;
        private String lastName;
        private String username;
        private Integer status;
        private String groupId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUsersRequest model) {
            super(model);
            this.networkId(model.networkId);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.sortFields(model.sortFields);
            this.sortDirection(model.sortDirection);
            this.firstName(model.firstName);
            this.lastName(model.lastName);
            this.username(model.username);
            this.status(model.status);
            this.groupId(model.groupId);
        }

        public final String getNetworkId() {
            return this.networkId;
        }

        public final void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        @Override
        public final Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getSortFields() {
            return this.sortFields;
        }

        public final void setSortFields(String sortFields) {
            this.sortFields = sortFields;
        }

        @Override
        public final Builder sortFields(String sortFields) {
            this.sortFields = sortFields;
            return this;
        }

        public final String getSortDirection() {
            return this.sortDirection;
        }

        public final void setSortDirection(String sortDirection) {
            this.sortDirection = sortDirection;
        }

        @Override
        public final Builder sortDirection(String sortDirection) {
            this.sortDirection = sortDirection;
            return this;
        }

        @Override
        public final Builder sortDirection(SortDirection sortDirection) {
            this.sortDirection(sortDirection == null ? null : sortDirection.toString());
            return this;
        }

        public final String getFirstName() {
            return this.firstName;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final String getLastName() {
            return this.lastName;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final String getUsername() {
            return this.username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListUsersRequest build() {
            return new ListUsersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WickrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListUsersRequest> {
        public Builder networkId(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder sortFields(String var1);

        public Builder sortDirection(String var1);

        public Builder sortDirection(SortDirection var1);

        public Builder firstName(String var1);

        public Builder lastName(String var1);

        public Builder username(String var1);

        public Builder status(Integer var1);

        public Builder groupId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

