/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wickr.model.BatchDeviceErrorResponseItem;
import software.amazon.awssdk.services.wickr.model.BatchDeviceErrorResponseItemsCopier;
import software.amazon.awssdk.services.wickr.model.BatchDeviceSuccessResponseItem;
import software.amazon.awssdk.services.wickr.model.BatchDeviceSuccessResponseItemsCopier;
import software.amazon.awssdk.services.wickr.model.WickrResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchResetDevicesForUserResponse
extends WickrResponse
implements ToCopyableBuilder<Builder, BatchResetDevicesForUserResponse> {
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(BatchResetDevicesForUserResponse.getter(BatchResetDevicesForUserResponse::message)).setter(BatchResetDevicesForUserResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<List<BatchDeviceSuccessResponseItem>> SUCCESSFUL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("successful").getter(BatchResetDevicesForUserResponse.getter(BatchResetDevicesForUserResponse::successful)).setter(BatchResetDevicesForUserResponse.setter(Builder::successful)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successful").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchDeviceSuccessResponseItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchDeviceErrorResponseItem>> FAILED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failed").getter(BatchResetDevicesForUserResponse.getter(BatchResetDevicesForUserResponse::failed)).setter(BatchResetDevicesForUserResponse.setter(Builder::failed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failed").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchDeviceErrorResponseItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD, SUCCESSFUL_FIELD, FAILED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchResetDevicesForUserResponse.memberNameToFieldInitializer();
    private final String message;
    private final List<BatchDeviceSuccessResponseItem> successful;
    private final List<BatchDeviceErrorResponseItem> failed;

    private BatchResetDevicesForUserResponse(BuilderImpl builder) {
        super(builder);
        this.message = builder.message;
        this.successful = builder.successful;
        this.failed = builder.failed;
    }

    public final String message() {
        return this.message;
    }

    public final boolean hasSuccessful() {
        return this.successful != null && !(this.successful instanceof SdkAutoConstructList);
    }

    public final List<BatchDeviceSuccessResponseItem> successful() {
        return this.successful;
    }

    public final boolean hasFailed() {
        return this.failed != null && !(this.failed instanceof SdkAutoConstructList);
    }

    public final List<BatchDeviceErrorResponseItem> failed() {
        return this.failed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessful() ? this.successful() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailed() ? this.failed() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchResetDevicesForUserResponse)) {
            return false;
        }
        BatchResetDevicesForUserResponse other = (BatchResetDevicesForUserResponse)((Object)obj);
        return Objects.equals(this.message(), other.message()) && this.hasSuccessful() == other.hasSuccessful() && Objects.equals(this.successful(), other.successful()) && this.hasFailed() == other.hasFailed() && Objects.equals(this.failed(), other.failed());
    }

    public final String toString() {
        return ToString.builder((String)"BatchResetDevicesForUserResponse").add("Message", (Object)this.message()).add("Successful", this.hasSuccessful() ? this.successful() : null).add("Failed", this.hasFailed() ? this.failed() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "successful": {
                return Optional.ofNullable(clazz.cast(this.successful()));
            }
            case "failed": {
                return Optional.ofNullable(clazz.cast(this.failed()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("message", MESSAGE_FIELD);
        map.put("successful", SUCCESSFUL_FIELD);
        map.put("failed", FAILED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchResetDevicesForUserResponse, T> g) {
        return obj -> g.apply((BatchResetDevicesForUserResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WickrResponse.BuilderImpl
    implements Builder {
        private String message;
        private List<BatchDeviceSuccessResponseItem> successful = DefaultSdkAutoConstructList.getInstance();
        private List<BatchDeviceErrorResponseItem> failed = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchResetDevicesForUserResponse model) {
            super(model);
            this.message(model.message);
            this.successful(model.successful);
            this.failed(model.failed);
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final List<BatchDeviceSuccessResponseItem.Builder> getSuccessful() {
            List<BatchDeviceSuccessResponseItem.Builder> result = BatchDeviceSuccessResponseItemsCopier.copyToBuilder(this.successful);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessful(Collection<BatchDeviceSuccessResponseItem.BuilderImpl> successful) {
            this.successful = BatchDeviceSuccessResponseItemsCopier.copyFromBuilder(successful);
        }

        @Override
        public final Builder successful(Collection<BatchDeviceSuccessResponseItem> successful) {
            this.successful = BatchDeviceSuccessResponseItemsCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(BatchDeviceSuccessResponseItem ... successful) {
            this.successful(Arrays.asList(successful));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(Consumer<BatchDeviceSuccessResponseItem.Builder> ... successful) {
            this.successful(Stream.of(successful).map(c -> (BatchDeviceSuccessResponseItem)((BatchDeviceSuccessResponseItem.Builder)BatchDeviceSuccessResponseItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchDeviceErrorResponseItem.Builder> getFailed() {
            List<BatchDeviceErrorResponseItem.Builder> result = BatchDeviceErrorResponseItemsCopier.copyToBuilder(this.failed);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailed(Collection<BatchDeviceErrorResponseItem.BuilderImpl> failed) {
            this.failed = BatchDeviceErrorResponseItemsCopier.copyFromBuilder(failed);
        }

        @Override
        public final Builder failed(Collection<BatchDeviceErrorResponseItem> failed) {
            this.failed = BatchDeviceErrorResponseItemsCopier.copy(failed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(BatchDeviceErrorResponseItem ... failed) {
            this.failed(Arrays.asList(failed));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(Consumer<BatchDeviceErrorResponseItem.Builder> ... failed) {
            this.failed(Stream.of(failed).map(c -> (BatchDeviceErrorResponseItem)((BatchDeviceErrorResponseItem.Builder)BatchDeviceErrorResponseItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchResetDevicesForUserResponse build() {
            return new BatchResetDevicesForUserResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WickrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchResetDevicesForUserResponse> {
        public Builder message(String var1);

        public Builder successful(Collection<BatchDeviceSuccessResponseItem> var1);

        public Builder successful(BatchDeviceSuccessResponseItem ... var1);

        public Builder successful(Consumer<BatchDeviceSuccessResponseItem.Builder> ... var1);

        public Builder failed(Collection<BatchDeviceErrorResponseItem> var1);

        public Builder failed(BatchDeviceErrorResponseItem ... var1);

        public Builder failed(Consumer<BatchDeviceErrorResponseItem.Builder> ... var1);
    }
}

