/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wickr.WickrClient;
import software.amazon.awssdk.services.wickr.internal.UserAgentUtils;
import software.amazon.awssdk.services.wickr.model.BlockedGuestUser;
import software.amazon.awssdk.services.wickr.model.ListBlockedGuestUsersRequest;
import software.amazon.awssdk.services.wickr.model.ListBlockedGuestUsersResponse;

public class ListBlockedGuestUsersIterable
implements SdkIterable<ListBlockedGuestUsersResponse> {
    private final WickrClient client;
    private final ListBlockedGuestUsersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBlockedGuestUsersIterable(WickrClient client, ListBlockedGuestUsersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBlockedGuestUsersResponseFetcher();
    }

    public Iterator<ListBlockedGuestUsersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<BlockedGuestUser> blocklist() {
        Function<ListBlockedGuestUsersResponse, Iterator> getIterator = response -> {
            if (response != null && response.blocklist() != null) {
                return response.blocklist().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListBlockedGuestUsersResponseFetcher
    implements SyncPageFetcher<ListBlockedGuestUsersResponse> {
        private ListBlockedGuestUsersResponseFetcher() {
        }

        public boolean hasNextPage(ListBlockedGuestUsersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBlockedGuestUsersResponse nextPage(ListBlockedGuestUsersResponse previousPage) {
            if (previousPage == null) {
                return ListBlockedGuestUsersIterable.this.client.listBlockedGuestUsers(ListBlockedGuestUsersIterable.this.firstRequest);
            }
            return ListBlockedGuestUsersIterable.this.client.listBlockedGuestUsers((ListBlockedGuestUsersRequest)((Object)ListBlockedGuestUsersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

