/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wickr.model.SecurityGroupIdListCopier;
import software.amazon.awssdk.services.wickr.model.WickrResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetUserResponse
extends WickrResponse
implements ToCopyableBuilder<Builder, GetUserResponse> {
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userId").getter(GetUserResponse.getter(GetUserResponse::userId)).setter(GetUserResponse.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()}).build();
    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("firstName").getter(GetUserResponse.getter(GetUserResponse::firstName)).setter(GetUserResponse.setter(Builder::firstName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstName").build()}).build();
    private static final SdkField<String> LAST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastName").getter(GetUserResponse.getter(GetUserResponse::lastName)).setter(GetUserResponse.setter(Builder::lastName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastName").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("username").getter(GetUserResponse.getter(GetUserResponse::username)).setter(GetUserResponse.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("username").build()}).build();
    private static final SdkField<Boolean> IS_ADMIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isAdmin").getter(GetUserResponse.getter(GetUserResponse::isAdmin)).setter(GetUserResponse.setter(Builder::isAdmin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isAdmin").build()}).build();
    private static final SdkField<Boolean> SUSPENDED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("suspended").getter(GetUserResponse.getter(GetUserResponse::suspended)).setter(GetUserResponse.setter(Builder::suspended)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suspended").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("status").getter(GetUserResponse.getter(GetUserResponse::status)).setter(GetUserResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Integer> LAST_ACTIVITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("lastActivity").getter(GetUserResponse.getter(GetUserResponse::lastActivity)).setter(GetUserResponse.setter(Builder::lastActivity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastActivity").build()}).build();
    private static final SdkField<Integer> LAST_LOGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("lastLogin").getter(GetUserResponse.getter(GetUserResponse::lastLogin)).setter(GetUserResponse.setter(Builder::lastLogin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastLogin").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("securityGroupIds").getter(GetUserResponse.getter(GetUserResponse::securityGroupIds)).setter(GetUserResponse.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ID_FIELD, FIRST_NAME_FIELD, LAST_NAME_FIELD, USERNAME_FIELD, IS_ADMIN_FIELD, SUSPENDED_FIELD, STATUS_FIELD, LAST_ACTIVITY_FIELD, LAST_LOGIN_FIELD, SECURITY_GROUP_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetUserResponse.memberNameToFieldInitializer();
    private final String userId;
    private final String firstName;
    private final String lastName;
    private final String username;
    private final Boolean isAdmin;
    private final Boolean suspended;
    private final Integer status;
    private final Integer lastActivity;
    private final Integer lastLogin;
    private final List<String> securityGroupIds;

    private GetUserResponse(BuilderImpl builder) {
        super(builder);
        this.userId = builder.userId;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.username = builder.username;
        this.isAdmin = builder.isAdmin;
        this.suspended = builder.suspended;
        this.status = builder.status;
        this.lastActivity = builder.lastActivity;
        this.lastLogin = builder.lastLogin;
        this.securityGroupIds = builder.securityGroupIds;
    }

    public final String userId() {
        return this.userId;
    }

    public final String firstName() {
        return this.firstName;
    }

    public final String lastName() {
        return this.lastName;
    }

    public final String username() {
        return this.username;
    }

    public final Boolean isAdmin() {
        return this.isAdmin;
    }

    public final Boolean suspended() {
        return this.suspended;
    }

    public final Integer status() {
        return this.status;
    }

    public final Integer lastActivity() {
        return this.lastActivity;
    }

    public final Integer lastLogin() {
        return this.lastLogin;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastName());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.isAdmin());
        hashCode = 31 * hashCode + Objects.hashCode(this.suspended());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastActivity());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastLogin());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUserResponse)) {
            return false;
        }
        GetUserResponse other = (GetUserResponse)((Object)obj);
        return Objects.equals(this.userId(), other.userId()) && Objects.equals(this.firstName(), other.firstName()) && Objects.equals(this.lastName(), other.lastName()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.isAdmin(), other.isAdmin()) && Objects.equals(this.suspended(), other.suspended()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.lastActivity(), other.lastActivity()) && Objects.equals(this.lastLogin(), other.lastLogin()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds());
    }

    public final String toString() {
        return ToString.builder((String)"GetUserResponse").add("UserId", (Object)this.userId()).add("FirstName", (Object)(this.firstName() == null ? null : "*** Sensitive Data Redacted ***")).add("LastName", (Object)(this.lastName() == null ? null : "*** Sensitive Data Redacted ***")).add("Username", (Object)this.username()).add("IsAdmin", (Object)this.isAdmin()).add("Suspended", (Object)this.suspended()).add("Status", (Object)this.status()).add("LastActivity", (Object)this.lastActivity()).add("LastLogin", (Object)this.lastLogin()).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "firstName": {
                return Optional.ofNullable(clazz.cast(this.firstName()));
            }
            case "lastName": {
                return Optional.ofNullable(clazz.cast(this.lastName()));
            }
            case "username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "isAdmin": {
                return Optional.ofNullable(clazz.cast(this.isAdmin()));
            }
            case "suspended": {
                return Optional.ofNullable(clazz.cast(this.suspended()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "lastActivity": {
                return Optional.ofNullable(clazz.cast(this.lastActivity()));
            }
            case "lastLogin": {
                return Optional.ofNullable(clazz.cast(this.lastLogin()));
            }
            case "securityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", USER_ID_FIELD);
        map.put("firstName", FIRST_NAME_FIELD);
        map.put("lastName", LAST_NAME_FIELD);
        map.put("username", USERNAME_FIELD);
        map.put("isAdmin", IS_ADMIN_FIELD);
        map.put("suspended", SUSPENDED_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("lastActivity", LAST_ACTIVITY_FIELD);
        map.put("lastLogin", LAST_LOGIN_FIELD);
        map.put("securityGroupIds", SECURITY_GROUP_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetUserResponse, T> g) {
        return obj -> g.apply((GetUserResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WickrResponse.BuilderImpl
    implements Builder {
        private String userId;
        private String firstName;
        private String lastName;
        private String username;
        private Boolean isAdmin;
        private Boolean suspended;
        private Integer status;
        private Integer lastActivity;
        private Integer lastLogin;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetUserResponse model) {
            super(model);
            this.userId(model.userId);
            this.firstName(model.firstName);
            this.lastName(model.lastName);
            this.username(model.username);
            this.isAdmin(model.isAdmin);
            this.suspended(model.suspended);
            this.status(model.status);
            this.lastActivity(model.lastActivity);
            this.lastLogin(model.lastLogin);
            this.securityGroupIds(model.securityGroupIds);
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getFirstName() {
            return this.firstName;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final String getLastName() {
            return this.lastName;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final String getUsername() {
            return this.username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final Boolean getIsAdmin() {
            return this.isAdmin;
        }

        public final void setIsAdmin(Boolean isAdmin) {
            this.isAdmin = isAdmin;
        }

        @Override
        public final Builder isAdmin(Boolean isAdmin) {
            this.isAdmin = isAdmin;
            return this;
        }

        public final Boolean getSuspended() {
            return this.suspended;
        }

        public final void setSuspended(Boolean suspended) {
            this.suspended = suspended;
        }

        @Override
        public final Builder suspended(Boolean suspended) {
            this.suspended = suspended;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final Integer getLastActivity() {
            return this.lastActivity;
        }

        public final void setLastActivity(Integer lastActivity) {
            this.lastActivity = lastActivity;
        }

        @Override
        public final Builder lastActivity(Integer lastActivity) {
            this.lastActivity = lastActivity;
            return this;
        }

        public final Integer getLastLogin() {
            return this.lastLogin;
        }

        public final void setLastLogin(Integer lastLogin) {
            this.lastLogin = lastLogin;
        }

        @Override
        public final Builder lastLogin(Integer lastLogin) {
            this.lastLogin = lastLogin;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        @Override
        public GetUserResponse build() {
            return new GetUserResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WickrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetUserResponse> {
        public Builder userId(String var1);

        public Builder firstName(String var1);

        public Builder lastName(String var1);

        public Builder username(String var1);

        public Builder isAdmin(Boolean var1);

        public Builder suspended(Boolean var1);

        public Builder status(Integer var1);

        public Builder lastActivity(Integer var1);

        public Builder lastLogin(Integer var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);
    }
}

