/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wickr.model.SortDirection;
import software.amazon.awssdk.services.wickr.model.WickrRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGuestUsersRequest
extends WickrRequest
implements ToCopyableBuilder<Builder, ListGuestUsersRequest> {
    private static final SdkField<String> NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkId").getter(ListGuestUsersRequest.getter(ListGuestUsersRequest::networkId)).setter(ListGuestUsersRequest.setter(Builder::networkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("networkId").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListGuestUsersRequest.getter(ListGuestUsersRequest::maxResults)).setter(ListGuestUsersRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> SORT_DIRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortDirection").getter(ListGuestUsersRequest.getter(ListGuestUsersRequest::sortDirectionAsString)).setter(ListGuestUsersRequest.setter(Builder::sortDirection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortDirection").build()}).build();
    private static final SdkField<String> SORT_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortFields").getter(ListGuestUsersRequest.getter(ListGuestUsersRequest::sortFields)).setter(ListGuestUsersRequest.setter(Builder::sortFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortFields").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("username").getter(ListGuestUsersRequest.getter(ListGuestUsersRequest::username)).setter(ListGuestUsersRequest.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("username").build()}).build();
    private static final SdkField<String> BILLING_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("billingPeriod").getter(ListGuestUsersRequest.getter(ListGuestUsersRequest::billingPeriod)).setter(ListGuestUsersRequest.setter(Builder::billingPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("billingPeriod").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListGuestUsersRequest.getter(ListGuestUsersRequest::nextToken)).setter(ListGuestUsersRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_ID_FIELD, MAX_RESULTS_FIELD, SORT_DIRECTION_FIELD, SORT_FIELDS_FIELD, USERNAME_FIELD, BILLING_PERIOD_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListGuestUsersRequest.memberNameToFieldInitializer();
    private final String networkId;
    private final Integer maxResults;
    private final String sortDirection;
    private final String sortFields;
    private final String username;
    private final String billingPeriod;
    private final String nextToken;

    private ListGuestUsersRequest(BuilderImpl builder) {
        super(builder);
        this.networkId = builder.networkId;
        this.maxResults = builder.maxResults;
        this.sortDirection = builder.sortDirection;
        this.sortFields = builder.sortFields;
        this.username = builder.username;
        this.billingPeriod = builder.billingPeriod;
        this.nextToken = builder.nextToken;
    }

    public final String networkId() {
        return this.networkId;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final SortDirection sortDirection() {
        return SortDirection.fromValue(this.sortDirection);
    }

    public final String sortDirectionAsString() {
        return this.sortDirection;
    }

    public final String sortFields() {
        return this.sortFields;
    }

    public final String username() {
        return this.username;
    }

    public final String billingPeriod() {
        return this.billingPeriod;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.networkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortDirectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortFields());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGuestUsersRequest)) {
            return false;
        }
        ListGuestUsersRequest other = (ListGuestUsersRequest)((Object)obj);
        return Objects.equals(this.networkId(), other.networkId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.sortDirectionAsString(), other.sortDirectionAsString()) && Objects.equals(this.sortFields(), other.sortFields()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.billingPeriod(), other.billingPeriod()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListGuestUsersRequest").add("NetworkId", (Object)this.networkId()).add("MaxResults", (Object)this.maxResults()).add("SortDirection", (Object)this.sortDirectionAsString()).add("SortFields", (Object)this.sortFields()).add("Username", (Object)this.username()).add("BillingPeriod", (Object)this.billingPeriod()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "networkId": {
                return Optional.ofNullable(clazz.cast(this.networkId()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "sortDirection": {
                return Optional.ofNullable(clazz.cast(this.sortDirectionAsString()));
            }
            case "sortFields": {
                return Optional.ofNullable(clazz.cast(this.sortFields()));
            }
            case "username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "billingPeriod": {
                return Optional.ofNullable(clazz.cast(this.billingPeriod()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("networkId", NETWORK_ID_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("sortDirection", SORT_DIRECTION_FIELD);
        map.put("sortFields", SORT_FIELDS_FIELD);
        map.put("username", USERNAME_FIELD);
        map.put("billingPeriod", BILLING_PERIOD_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListGuestUsersRequest, T> g) {
        return obj -> g.apply((ListGuestUsersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WickrRequest.BuilderImpl
    implements Builder {
        private String networkId;
        private Integer maxResults;
        private String sortDirection;
        private String sortFields;
        private String username;
        private String billingPeriod;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGuestUsersRequest model) {
            super(model);
            this.networkId(model.networkId);
            this.maxResults(model.maxResults);
            this.sortDirection(model.sortDirection);
            this.sortFields(model.sortFields);
            this.username(model.username);
            this.billingPeriod(model.billingPeriod);
            this.nextToken(model.nextToken);
        }

        public final String getNetworkId() {
            return this.networkId;
        }

        public final void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        @Override
        public final Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getSortDirection() {
            return this.sortDirection;
        }

        public final void setSortDirection(String sortDirection) {
            this.sortDirection = sortDirection;
        }

        @Override
        public final Builder sortDirection(String sortDirection) {
            this.sortDirection = sortDirection;
            return this;
        }

        @Override
        public final Builder sortDirection(SortDirection sortDirection) {
            this.sortDirection(sortDirection == null ? null : sortDirection.toString());
            return this;
        }

        public final String getSortFields() {
            return this.sortFields;
        }

        public final void setSortFields(String sortFields) {
            this.sortFields = sortFields;
        }

        @Override
        public final Builder sortFields(String sortFields) {
            this.sortFields = sortFields;
            return this;
        }

        public final String getUsername() {
            return this.username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final String getBillingPeriod() {
            return this.billingPeriod;
        }

        public final void setBillingPeriod(String billingPeriod) {
            this.billingPeriod = billingPeriod;
        }

        @Override
        public final Builder billingPeriod(String billingPeriod) {
            this.billingPeriod = billingPeriod;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListGuestUsersRequest build() {
            return new ListGuestUsersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WickrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListGuestUsersRequest> {
        public Builder networkId(String var1);

        public Builder maxResults(Integer var1);

        public Builder sortDirection(String var1);

        public Builder sortDirection(SortDirection var1);

        public Builder sortFields(String var1);

        public Builder username(String var1);

        public Builder billingPeriod(String var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

