/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wickr.WickrAsyncClient;
import software.amazon.awssdk.services.wickr.internal.UserAgentUtils;
import software.amazon.awssdk.services.wickr.model.BlockedGuestUser;
import software.amazon.awssdk.services.wickr.model.ListBlockedGuestUsersRequest;
import software.amazon.awssdk.services.wickr.model.ListBlockedGuestUsersResponse;

public class ListBlockedGuestUsersPublisher
implements SdkPublisher<ListBlockedGuestUsersResponse> {
    private final WickrAsyncClient client;
    private final ListBlockedGuestUsersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBlockedGuestUsersPublisher(WickrAsyncClient client, ListBlockedGuestUsersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBlockedGuestUsersPublisher(WickrAsyncClient client, ListBlockedGuestUsersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBlockedGuestUsersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBlockedGuestUsersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<BlockedGuestUser> blocklist() {
        Function<ListBlockedGuestUsersResponse, Iterator> getIterator = response -> {
            if (response != null && response.blocklist() != null) {
                return response.blocklist().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListBlockedGuestUsersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListBlockedGuestUsersResponseFetcher
    implements AsyncPageFetcher<ListBlockedGuestUsersResponse> {
        private ListBlockedGuestUsersResponseFetcher() {
        }

        public boolean hasNextPage(ListBlockedGuestUsersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBlockedGuestUsersResponse> nextPage(ListBlockedGuestUsersResponse previousPage) {
            if (previousPage == null) {
                return ListBlockedGuestUsersPublisher.this.client.listBlockedGuestUsers(ListBlockedGuestUsersPublisher.this.firstRequest);
            }
            return ListBlockedGuestUsersPublisher.this.client.listBlockedGuestUsers((ListBlockedGuestUsersRequest)((Object)ListBlockedGuestUsersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

