/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wickr.WickrClient;
import software.amazon.awssdk.services.wickr.internal.UserAgentUtils;
import software.amazon.awssdk.services.wickr.model.Bot;
import software.amazon.awssdk.services.wickr.model.ListBotsRequest;
import software.amazon.awssdk.services.wickr.model.ListBotsResponse;

public class ListBotsIterable
implements SdkIterable<ListBotsResponse> {
    private final WickrClient client;
    private final ListBotsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBotsIterable(WickrClient client, ListBotsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBotsResponseFetcher();
    }

    public Iterator<ListBotsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Bot> bots() {
        Function<ListBotsResponse, Iterator> getIterator = response -> {
            if (response != null && response.bots() != null) {
                return response.bots().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListBotsResponseFetcher
    implements SyncPageFetcher<ListBotsResponse> {
        private ListBotsResponseFetcher() {
        }

        public boolean hasNextPage(ListBotsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBotsResponse nextPage(ListBotsResponse previousPage) {
            if (previousPage == null) {
                return ListBotsIterable.this.client.listBots(ListBotsIterable.this.firstRequest);
            }
            return ListBotsIterable.this.client.listBots((ListBotsRequest)((Object)ListBotsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

