/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wickr.model.BasicDeviceObject;
import software.amazon.awssdk.services.wickr.model.DevicesCopier;
import software.amazon.awssdk.services.wickr.model.WickrResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDevicesForUserResponse
extends WickrResponse
implements ToCopyableBuilder<Builder, ListDevicesForUserResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDevicesForUserResponse.getter(ListDevicesForUserResponse::nextToken)).setter(ListDevicesForUserResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<BasicDeviceObject>> DEVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("devices").getter(ListDevicesForUserResponse.getter(ListDevicesForUserResponse::devices)).setter(ListDevicesForUserResponse.setter(Builder::devices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("devices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BasicDeviceObject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, DEVICES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDevicesForUserResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<BasicDeviceObject> devices;

    private ListDevicesForUserResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.devices = builder.devices;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasDevices() {
        return this.devices != null && !(this.devices instanceof SdkAutoConstructList);
    }

    public final List<BasicDeviceObject> devices() {
        return this.devices;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDevices() ? this.devices() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDevicesForUserResponse)) {
            return false;
        }
        ListDevicesForUserResponse other = (ListDevicesForUserResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasDevices() == other.hasDevices() && Objects.equals(this.devices(), other.devices());
    }

    public final String toString() {
        return ToString.builder((String)"ListDevicesForUserResponse").add("NextToken", (Object)this.nextToken()).add("Devices", this.hasDevices() ? this.devices() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "devices": {
                return Optional.ofNullable(clazz.cast(this.devices()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("devices", DEVICES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDevicesForUserResponse, T> g) {
        return obj -> g.apply((ListDevicesForUserResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WickrResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<BasicDeviceObject> devices = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListDevicesForUserResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.devices(model.devices);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<BasicDeviceObject.Builder> getDevices() {
            List<BasicDeviceObject.Builder> result = DevicesCopier.copyToBuilder(this.devices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDevices(Collection<BasicDeviceObject.BuilderImpl> devices) {
            this.devices = DevicesCopier.copyFromBuilder(devices);
        }

        @Override
        public final Builder devices(Collection<BasicDeviceObject> devices) {
            this.devices = DevicesCopier.copy(devices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devices(BasicDeviceObject ... devices) {
            this.devices(Arrays.asList(devices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devices(Consumer<BasicDeviceObject.Builder> ... devices) {
            this.devices(Stream.of(devices).map(c -> (BasicDeviceObject)((BasicDeviceObject.Builder)BasicDeviceObject.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListDevicesForUserResponse build() {
            return new ListDevicesForUserResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WickrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDevicesForUserResponse> {
        public Builder nextToken(String var1);

        public Builder devices(Collection<BasicDeviceObject> var1);

        public Builder devices(BasicDeviceObject ... var1);

        public Builder devices(Consumer<BasicDeviceObject.Builder> ... var1);
    }
}

