/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wellarchitected.model.LensReview;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLensReviewResponse
extends WellArchitectedResponse
implements ToCopyableBuilder<Builder, GetLensReviewResponse> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadId").getter(GetLensReviewResponse.getter(GetLensReviewResponse::workloadId)).setter(GetLensReviewResponse.setter(Builder::workloadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadId").build()}).build();
    private static final SdkField<Integer> MILESTONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MilestoneNumber").getter(GetLensReviewResponse.getter(GetLensReviewResponse::milestoneNumber)).setter(GetLensReviewResponse.setter(Builder::milestoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MilestoneNumber").build()}).build();
    private static final SdkField<LensReview> LENS_REVIEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LensReview").getter(GetLensReviewResponse.getter(GetLensReviewResponse::lensReview)).setter(GetLensReviewResponse.setter(Builder::lensReview)).constructor(LensReview::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensReview").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD, MILESTONE_NUMBER_FIELD, LENS_REVIEW_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetLensReviewResponse.memberNameToFieldInitializer();
    private final String workloadId;
    private final Integer milestoneNumber;
    private final LensReview lensReview;

    private GetLensReviewResponse(BuilderImpl builder) {
        super(builder);
        this.workloadId = builder.workloadId;
        this.milestoneNumber = builder.milestoneNumber;
        this.lensReview = builder.lensReview;
    }

    public final String workloadId() {
        return this.workloadId;
    }

    public final Integer milestoneNumber() {
        return this.milestoneNumber;
    }

    public final LensReview lensReview() {
        return this.lensReview;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.milestoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensReview());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLensReviewResponse)) {
            return false;
        }
        GetLensReviewResponse other = (GetLensReviewResponse)((Object)obj);
        return Objects.equals(this.workloadId(), other.workloadId()) && Objects.equals(this.milestoneNumber(), other.milestoneNumber()) && Objects.equals(this.lensReview(), other.lensReview());
    }

    public final String toString() {
        return ToString.builder((String)"GetLensReviewResponse").add("WorkloadId", (Object)this.workloadId()).add("MilestoneNumber", (Object)this.milestoneNumber()).add("LensReview", (Object)this.lensReview()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkloadId": {
                return Optional.ofNullable(clazz.cast(this.workloadId()));
            }
            case "MilestoneNumber": {
                return Optional.ofNullable(clazz.cast(this.milestoneNumber()));
            }
            case "LensReview": {
                return Optional.ofNullable(clazz.cast(this.lensReview()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("WorkloadId", WORKLOAD_ID_FIELD);
        map.put("MilestoneNumber", MILESTONE_NUMBER_FIELD);
        map.put("LensReview", LENS_REVIEW_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetLensReviewResponse, T> g) {
        return obj -> g.apply((GetLensReviewResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedResponse.BuilderImpl
    implements Builder {
        private String workloadId;
        private Integer milestoneNumber;
        private LensReview lensReview;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLensReviewResponse model) {
            super(model);
            this.workloadId(model.workloadId);
            this.milestoneNumber(model.milestoneNumber);
            this.lensReview(model.lensReview);
        }

        public final String getWorkloadId() {
            return this.workloadId;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final Integer getMilestoneNumber() {
            return this.milestoneNumber;
        }

        public final void setMilestoneNumber(Integer milestoneNumber) {
            this.milestoneNumber = milestoneNumber;
        }

        @Override
        public final Builder milestoneNumber(Integer milestoneNumber) {
            this.milestoneNumber = milestoneNumber;
            return this;
        }

        public final LensReview.Builder getLensReview() {
            return this.lensReview != null ? this.lensReview.toBuilder() : null;
        }

        public final void setLensReview(LensReview.BuilderImpl lensReview) {
            this.lensReview = lensReview != null ? lensReview.build() : null;
        }

        @Override
        public final Builder lensReview(LensReview lensReview) {
            this.lensReview = lensReview;
            return this;
        }

        @Override
        public GetLensReviewResponse build() {
            return new GetLensReviewResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WellArchitectedResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLensReviewResponse> {
        public Builder workloadId(String var1);

        public Builder milestoneNumber(Integer var1);

        public Builder lensReview(LensReview var1);

        default public Builder lensReview(Consumer<LensReview.Builder> lensReview) {
            return this.lensReview((LensReview)((LensReview.Builder)LensReview.builder().applyMutation(lensReview)).build());
        }
    }
}

