/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wellarchitected.model.ShareResourceType;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListShareInvitationsRequest
extends WellArchitectedRequest
implements ToCopyableBuilder<Builder, ListShareInvitationsRequest> {
    private static final SdkField<String> WORKLOAD_NAME_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadNamePrefix").getter(ListShareInvitationsRequest.getter(ListShareInvitationsRequest::workloadNamePrefix)).setter(ListShareInvitationsRequest.setter(Builder::workloadNamePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("WorkloadNamePrefix").build()}).build();
    private static final SdkField<String> LENS_NAME_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensNamePrefix").getter(ListShareInvitationsRequest.getter(ListShareInvitationsRequest::lensNamePrefix)).setter(ListShareInvitationsRequest.setter(Builder::lensNamePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("LensNamePrefix").build()}).build();
    private static final SdkField<String> SHARE_RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShareResourceType").getter(ListShareInvitationsRequest.getter(ListShareInvitationsRequest::shareResourceTypeAsString)).setter(ListShareInvitationsRequest.setter(Builder::shareResourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ShareResourceType").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListShareInvitationsRequest.getter(ListShareInvitationsRequest::nextToken)).setter(ListShareInvitationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListShareInvitationsRequest.getter(ListShareInvitationsRequest::maxResults)).setter(ListShareInvitationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()}).build();
    private static final SdkField<String> PROFILE_NAME_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileNamePrefix").getter(ListShareInvitationsRequest.getter(ListShareInvitationsRequest::profileNamePrefix)).setter(ListShareInvitationsRequest.setter(Builder::profileNamePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ProfileNamePrefix").build()}).build();
    private static final SdkField<String> TEMPLATE_NAME_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateNamePrefix").getter(ListShareInvitationsRequest.getter(ListShareInvitationsRequest::templateNamePrefix)).setter(ListShareInvitationsRequest.setter(Builder::templateNamePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("TemplateNamePrefix").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_NAME_PREFIX_FIELD, LENS_NAME_PREFIX_FIELD, SHARE_RESOURCE_TYPE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, PROFILE_NAME_PREFIX_FIELD, TEMPLATE_NAME_PREFIX_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListShareInvitationsRequest.memberNameToFieldInitializer();
    private final String workloadNamePrefix;
    private final String lensNamePrefix;
    private final String shareResourceType;
    private final String nextToken;
    private final Integer maxResults;
    private final String profileNamePrefix;
    private final String templateNamePrefix;

    private ListShareInvitationsRequest(BuilderImpl builder) {
        super(builder);
        this.workloadNamePrefix = builder.workloadNamePrefix;
        this.lensNamePrefix = builder.lensNamePrefix;
        this.shareResourceType = builder.shareResourceType;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.profileNamePrefix = builder.profileNamePrefix;
        this.templateNamePrefix = builder.templateNamePrefix;
    }

    public final String workloadNamePrefix() {
        return this.workloadNamePrefix;
    }

    public final String lensNamePrefix() {
        return this.lensNamePrefix;
    }

    public final ShareResourceType shareResourceType() {
        return ShareResourceType.fromValue(this.shareResourceType);
    }

    public final String shareResourceTypeAsString() {
        return this.shareResourceType;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String profileNamePrefix() {
        return this.profileNamePrefix;
    }

    public final String templateNamePrefix() {
        return this.templateNamePrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareResourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateNamePrefix());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListShareInvitationsRequest)) {
            return false;
        }
        ListShareInvitationsRequest other = (ListShareInvitationsRequest)((Object)obj);
        return Objects.equals(this.workloadNamePrefix(), other.workloadNamePrefix()) && Objects.equals(this.lensNamePrefix(), other.lensNamePrefix()) && Objects.equals(this.shareResourceTypeAsString(), other.shareResourceTypeAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.profileNamePrefix(), other.profileNamePrefix()) && Objects.equals(this.templateNamePrefix(), other.templateNamePrefix());
    }

    public final String toString() {
        return ToString.builder((String)"ListShareInvitationsRequest").add("WorkloadNamePrefix", (Object)this.workloadNamePrefix()).add("LensNamePrefix", (Object)this.lensNamePrefix()).add("ShareResourceType", (Object)this.shareResourceTypeAsString()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("ProfileNamePrefix", (Object)this.profileNamePrefix()).add("TemplateNamePrefix", (Object)this.templateNamePrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkloadNamePrefix": {
                return Optional.ofNullable(clazz.cast(this.workloadNamePrefix()));
            }
            case "LensNamePrefix": {
                return Optional.ofNullable(clazz.cast(this.lensNamePrefix()));
            }
            case "ShareResourceType": {
                return Optional.ofNullable(clazz.cast(this.shareResourceTypeAsString()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "ProfileNamePrefix": {
                return Optional.ofNullable(clazz.cast(this.profileNamePrefix()));
            }
            case "TemplateNamePrefix": {
                return Optional.ofNullable(clazz.cast(this.templateNamePrefix()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("WorkloadNamePrefix", WORKLOAD_NAME_PREFIX_FIELD);
        map.put("LensNamePrefix", LENS_NAME_PREFIX_FIELD);
        map.put("ShareResourceType", SHARE_RESOURCE_TYPE_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("ProfileNamePrefix", PROFILE_NAME_PREFIX_FIELD);
        map.put("TemplateNamePrefix", TEMPLATE_NAME_PREFIX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListShareInvitationsRequest, T> g) {
        return obj -> g.apply((ListShareInvitationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedRequest.BuilderImpl
    implements Builder {
        private String workloadNamePrefix;
        private String lensNamePrefix;
        private String shareResourceType;
        private String nextToken;
        private Integer maxResults;
        private String profileNamePrefix;
        private String templateNamePrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(ListShareInvitationsRequest model) {
            super(model);
            this.workloadNamePrefix(model.workloadNamePrefix);
            this.lensNamePrefix(model.lensNamePrefix);
            this.shareResourceType(model.shareResourceType);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.profileNamePrefix(model.profileNamePrefix);
            this.templateNamePrefix(model.templateNamePrefix);
        }

        public final String getWorkloadNamePrefix() {
            return this.workloadNamePrefix;
        }

        public final void setWorkloadNamePrefix(String workloadNamePrefix) {
            this.workloadNamePrefix = workloadNamePrefix;
        }

        @Override
        public final Builder workloadNamePrefix(String workloadNamePrefix) {
            this.workloadNamePrefix = workloadNamePrefix;
            return this;
        }

        public final String getLensNamePrefix() {
            return this.lensNamePrefix;
        }

        public final void setLensNamePrefix(String lensNamePrefix) {
            this.lensNamePrefix = lensNamePrefix;
        }

        @Override
        public final Builder lensNamePrefix(String lensNamePrefix) {
            this.lensNamePrefix = lensNamePrefix;
            return this;
        }

        public final String getShareResourceType() {
            return this.shareResourceType;
        }

        public final void setShareResourceType(String shareResourceType) {
            this.shareResourceType = shareResourceType;
        }

        @Override
        public final Builder shareResourceType(String shareResourceType) {
            this.shareResourceType = shareResourceType;
            return this;
        }

        @Override
        public final Builder shareResourceType(ShareResourceType shareResourceType) {
            this.shareResourceType(shareResourceType == null ? null : shareResourceType.toString());
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getProfileNamePrefix() {
            return this.profileNamePrefix;
        }

        public final void setProfileNamePrefix(String profileNamePrefix) {
            this.profileNamePrefix = profileNamePrefix;
        }

        @Override
        public final Builder profileNamePrefix(String profileNamePrefix) {
            this.profileNamePrefix = profileNamePrefix;
            return this;
        }

        public final String getTemplateNamePrefix() {
            return this.templateNamePrefix;
        }

        public final void setTemplateNamePrefix(String templateNamePrefix) {
            this.templateNamePrefix = templateNamePrefix;
        }

        @Override
        public final Builder templateNamePrefix(String templateNamePrefix) {
            this.templateNamePrefix = templateNamePrefix;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListShareInvitationsRequest build() {
            return new ListShareInvitationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WellArchitectedRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListShareInvitationsRequest> {
        public Builder workloadNamePrefix(String var1);

        public Builder lensNamePrefix(String var1);

        public Builder shareResourceType(String var1);

        public Builder shareResourceType(ShareResourceType var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder profileNamePrefix(String var1);

        public Builder templateNamePrefix(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

