/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wellarchitected.model.QuestionPriority;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAnswersRequest
extends WellArchitectedRequest
implements ToCopyableBuilder<Builder, ListAnswersRequest> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadId").getter(ListAnswersRequest.getter(ListAnswersRequest::workloadId)).setter(ListAnswersRequest.setter(Builder::workloadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("WorkloadId").build()}).build();
    private static final SdkField<String> LENS_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensAlias").getter(ListAnswersRequest.getter(ListAnswersRequest::lensAlias)).setter(ListAnswersRequest.setter(Builder::lensAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("LensAlias").build()}).build();
    private static final SdkField<String> PILLAR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PillarId").getter(ListAnswersRequest.getter(ListAnswersRequest::pillarId)).setter(ListAnswersRequest.setter(Builder::pillarId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("PillarId").build()}).build();
    private static final SdkField<Integer> MILESTONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MilestoneNumber").getter(ListAnswersRequest.getter(ListAnswersRequest::milestoneNumber)).setter(ListAnswersRequest.setter(Builder::milestoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MilestoneNumber").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAnswersRequest.getter(ListAnswersRequest::nextToken)).setter(ListAnswersRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListAnswersRequest.getter(ListAnswersRequest::maxResults)).setter(ListAnswersRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()}).build();
    private static final SdkField<String> QUESTION_PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuestionPriority").getter(ListAnswersRequest.getter(ListAnswersRequest::questionPriorityAsString)).setter(ListAnswersRequest.setter(Builder::questionPriority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("QuestionPriority").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD, LENS_ALIAS_FIELD, PILLAR_ID_FIELD, MILESTONE_NUMBER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, QUESTION_PRIORITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAnswersRequest.memberNameToFieldInitializer();
    private final String workloadId;
    private final String lensAlias;
    private final String pillarId;
    private final Integer milestoneNumber;
    private final String nextToken;
    private final Integer maxResults;
    private final String questionPriority;

    private ListAnswersRequest(BuilderImpl builder) {
        super(builder);
        this.workloadId = builder.workloadId;
        this.lensAlias = builder.lensAlias;
        this.pillarId = builder.pillarId;
        this.milestoneNumber = builder.milestoneNumber;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.questionPriority = builder.questionPriority;
    }

    public final String workloadId() {
        return this.workloadId;
    }

    public final String lensAlias() {
        return this.lensAlias;
    }

    public final String pillarId() {
        return this.pillarId;
    }

    public final Integer milestoneNumber() {
        return this.milestoneNumber;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final QuestionPriority questionPriority() {
        return QuestionPriority.fromValue(this.questionPriority);
    }

    public final String questionPriorityAsString() {
        return this.questionPriority;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.pillarId());
        hashCode = 31 * hashCode + Objects.hashCode(this.milestoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.questionPriorityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAnswersRequest)) {
            return false;
        }
        ListAnswersRequest other = (ListAnswersRequest)((Object)obj);
        return Objects.equals(this.workloadId(), other.workloadId()) && Objects.equals(this.lensAlias(), other.lensAlias()) && Objects.equals(this.pillarId(), other.pillarId()) && Objects.equals(this.milestoneNumber(), other.milestoneNumber()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.questionPriorityAsString(), other.questionPriorityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListAnswersRequest").add("WorkloadId", (Object)this.workloadId()).add("LensAlias", (Object)this.lensAlias()).add("PillarId", (Object)this.pillarId()).add("MilestoneNumber", (Object)this.milestoneNumber()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("QuestionPriority", (Object)this.questionPriorityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkloadId": {
                return Optional.ofNullable(clazz.cast(this.workloadId()));
            }
            case "LensAlias": {
                return Optional.ofNullable(clazz.cast(this.lensAlias()));
            }
            case "PillarId": {
                return Optional.ofNullable(clazz.cast(this.pillarId()));
            }
            case "MilestoneNumber": {
                return Optional.ofNullable(clazz.cast(this.milestoneNumber()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "QuestionPriority": {
                return Optional.ofNullable(clazz.cast(this.questionPriorityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("WorkloadId", WORKLOAD_ID_FIELD);
        map.put("LensAlias", LENS_ALIAS_FIELD);
        map.put("PillarId", PILLAR_ID_FIELD);
        map.put("MilestoneNumber", MILESTONE_NUMBER_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("QuestionPriority", QUESTION_PRIORITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAnswersRequest, T> g) {
        return obj -> g.apply((ListAnswersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedRequest.BuilderImpl
    implements Builder {
        private String workloadId;
        private String lensAlias;
        private String pillarId;
        private Integer milestoneNumber;
        private String nextToken;
        private Integer maxResults;
        private String questionPriority;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAnswersRequest model) {
            super(model);
            this.workloadId(model.workloadId);
            this.lensAlias(model.lensAlias);
            this.pillarId(model.pillarId);
            this.milestoneNumber(model.milestoneNumber);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.questionPriority(model.questionPriority);
        }

        public final String getWorkloadId() {
            return this.workloadId;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final String getLensAlias() {
            return this.lensAlias;
        }

        public final void setLensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
        }

        @Override
        public final Builder lensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
            return this;
        }

        public final String getPillarId() {
            return this.pillarId;
        }

        public final void setPillarId(String pillarId) {
            this.pillarId = pillarId;
        }

        @Override
        public final Builder pillarId(String pillarId) {
            this.pillarId = pillarId;
            return this;
        }

        public final Integer getMilestoneNumber() {
            return this.milestoneNumber;
        }

        public final void setMilestoneNumber(Integer milestoneNumber) {
            this.milestoneNumber = milestoneNumber;
        }

        @Override
        public final Builder milestoneNumber(Integer milestoneNumber) {
            this.milestoneNumber = milestoneNumber;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getQuestionPriority() {
            return this.questionPriority;
        }

        public final void setQuestionPriority(String questionPriority) {
            this.questionPriority = questionPriority;
        }

        @Override
        public final Builder questionPriority(String questionPriority) {
            this.questionPriority = questionPriority;
            return this;
        }

        @Override
        public final Builder questionPriority(QuestionPriority questionPriority) {
            this.questionPriority(questionPriority == null ? null : questionPriority.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAnswersRequest build() {
            return new ListAnswersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WellArchitectedRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAnswersRequest> {
        public Builder workloadId(String var1);

        public Builder lensAlias(String var1);

        public Builder pillarId(String var1);

        public Builder milestoneNumber(Integer var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder questionPriority(String var1);

        public Builder questionPriority(QuestionPriority var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

