/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.wellarchitected.model.ProfileQuestionUpdate;
import software.amazon.awssdk.services.wellarchitected.model.ProfileQuestionUpdatesCopier;
import software.amazon.awssdk.services.wellarchitected.model.TagMapCopier;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateProfileRequest
extends WellArchitectedRequest
implements ToCopyableBuilder<Builder, CreateProfileRequest> {
    private static final SdkField<String> PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileName").getter(CreateProfileRequest.getter(CreateProfileRequest::profileName)).setter(CreateProfileRequest.setter(Builder::profileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileName").build()}).build();
    private static final SdkField<String> PROFILE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileDescription").getter(CreateProfileRequest.getter(CreateProfileRequest::profileDescription)).setter(CreateProfileRequest.setter(Builder::profileDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileDescription").build()}).build();
    private static final SdkField<List<ProfileQuestionUpdate>> PROFILE_QUESTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProfileQuestions").getter(CreateProfileRequest.getter(CreateProfileRequest::profileQuestions)).setter(CreateProfileRequest.setter(Builder::profileQuestions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileQuestions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProfileQuestionUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateProfileRequest.getter(CreateProfileRequest::clientRequestToken)).setter(CreateProfileRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateProfileRequest.getter(CreateProfileRequest::tags)).setter(CreateProfileRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_NAME_FIELD, PROFILE_DESCRIPTION_FIELD, PROFILE_QUESTIONS_FIELD, CLIENT_REQUEST_TOKEN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateProfileRequest.memberNameToFieldInitializer();
    private final String profileName;
    private final String profileDescription;
    private final List<ProfileQuestionUpdate> profileQuestions;
    private final String clientRequestToken;
    private final Map<String, String> tags;

    private CreateProfileRequest(BuilderImpl builder) {
        super(builder);
        this.profileName = builder.profileName;
        this.profileDescription = builder.profileDescription;
        this.profileQuestions = builder.profileQuestions;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
    }

    public final String profileName() {
        return this.profileName;
    }

    public final String profileDescription() {
        return this.profileDescription;
    }

    public final boolean hasProfileQuestions() {
        return this.profileQuestions != null && !(this.profileQuestions instanceof SdkAutoConstructList);
    }

    public final List<ProfileQuestionUpdate> profileQuestions() {
        return this.profileQuestions;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.profileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProfileQuestions() ? this.profileQuestions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProfileRequest)) {
            return false;
        }
        CreateProfileRequest other = (CreateProfileRequest)((Object)obj);
        return Objects.equals(this.profileName(), other.profileName()) && Objects.equals(this.profileDescription(), other.profileDescription()) && this.hasProfileQuestions() == other.hasProfileQuestions() && Objects.equals(this.profileQuestions(), other.profileQuestions()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateProfileRequest").add("ProfileName", (Object)this.profileName()).add("ProfileDescription", (Object)this.profileDescription()).add("ProfileQuestions", this.hasProfileQuestions() ? this.profileQuestions() : null).add("ClientRequestToken", (Object)this.clientRequestToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProfileName": {
                return Optional.ofNullable(clazz.cast(this.profileName()));
            }
            case "ProfileDescription": {
                return Optional.ofNullable(clazz.cast(this.profileDescription()));
            }
            case "ProfileQuestions": {
                return Optional.ofNullable(clazz.cast(this.profileQuestions()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProfileName", PROFILE_NAME_FIELD);
        map.put("ProfileDescription", PROFILE_DESCRIPTION_FIELD);
        map.put("ProfileQuestions", PROFILE_QUESTIONS_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateProfileRequest, T> g) {
        return obj -> g.apply((CreateProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedRequest.BuilderImpl
    implements Builder {
        private String profileName;
        private String profileDescription;
        private List<ProfileQuestionUpdate> profileQuestions = DefaultSdkAutoConstructList.getInstance();
        private String clientRequestToken;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProfileRequest model) {
            super(model);
            this.profileName(model.profileName);
            this.profileDescription(model.profileDescription);
            this.profileQuestions(model.profileQuestions);
            this.clientRequestToken(model.clientRequestToken);
            this.tags(model.tags);
        }

        public final String getProfileName() {
            return this.profileName;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        @Override
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public final String getProfileDescription() {
            return this.profileDescription;
        }

        public final void setProfileDescription(String profileDescription) {
            this.profileDescription = profileDescription;
        }

        @Override
        public final Builder profileDescription(String profileDescription) {
            this.profileDescription = profileDescription;
            return this;
        }

        public final List<ProfileQuestionUpdate.Builder> getProfileQuestions() {
            List<ProfileQuestionUpdate.Builder> result = ProfileQuestionUpdatesCopier.copyToBuilder(this.profileQuestions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProfileQuestions(Collection<ProfileQuestionUpdate.BuilderImpl> profileQuestions) {
            this.profileQuestions = ProfileQuestionUpdatesCopier.copyFromBuilder(profileQuestions);
        }

        @Override
        public final Builder profileQuestions(Collection<ProfileQuestionUpdate> profileQuestions) {
            this.profileQuestions = ProfileQuestionUpdatesCopier.copy(profileQuestions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profileQuestions(ProfileQuestionUpdate ... profileQuestions) {
            this.profileQuestions(Arrays.asList(profileQuestions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profileQuestions(Consumer<ProfileQuestionUpdate.Builder> ... profileQuestions) {
            this.profileQuestions(Stream.of(profileQuestions).map(c -> (ProfileQuestionUpdate)((ProfileQuestionUpdate.Builder)ProfileQuestionUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProfileRequest build() {
            return new CreateProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WellArchitectedRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateProfileRequest> {
        public Builder profileName(String var1);

        public Builder profileDescription(String var1);

        public Builder profileQuestions(Collection<ProfileQuestionUpdate> var1);

        public Builder profileQuestions(ProfileQuestionUpdate ... var1);

        public Builder profileQuestions(Consumer<ProfileQuestionUpdate.Builder> ... var1);

        public Builder clientRequestToken(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

