/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateProfileShareResponse
extends WellArchitectedResponse
implements ToCopyableBuilder<Builder, CreateProfileShareResponse> {
    private static final SdkField<String> SHARE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShareId").getter(CreateProfileShareResponse.getter(CreateProfileShareResponse::shareId)).setter(CreateProfileShareResponse.setter(Builder::shareId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareId").build()}).build();
    private static final SdkField<String> PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileArn").getter(CreateProfileShareResponse.getter(CreateProfileShareResponse::profileArn)).setter(CreateProfileShareResponse.setter(Builder::profileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARE_ID_FIELD, PROFILE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ShareId", SHARE_ID_FIELD);
            this.put("ProfileArn", PROFILE_ARN_FIELD);
        }
    });
    private final String shareId;
    private final String profileArn;

    private CreateProfileShareResponse(BuilderImpl builder) {
        super(builder);
        this.shareId = builder.shareId;
        this.profileArn = builder.profileArn;
    }

    public final String shareId() {
        return this.shareId;
    }

    public final String profileArn() {
        return this.profileArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.shareId());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProfileShareResponse)) {
            return false;
        }
        CreateProfileShareResponse other = (CreateProfileShareResponse)((Object)obj);
        return Objects.equals(this.shareId(), other.shareId()) && Objects.equals(this.profileArn(), other.profileArn());
    }

    public final String toString() {
        return ToString.builder((String)"CreateProfileShareResponse").add("ShareId", (Object)this.shareId()).add("ProfileArn", (Object)this.profileArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ShareId": {
                return Optional.ofNullable(clazz.cast(this.shareId()));
            }
            case "ProfileArn": {
                return Optional.ofNullable(clazz.cast(this.profileArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateProfileShareResponse, T> g) {
        return obj -> g.apply((CreateProfileShareResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedResponse.BuilderImpl
    implements Builder {
        private String shareId;
        private String profileArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProfileShareResponse model) {
            super(model);
            this.shareId(model.shareId);
            this.profileArn(model.profileArn);
        }

        public final String getShareId() {
            return this.shareId;
        }

        public final void setShareId(String shareId) {
            this.shareId = shareId;
        }

        @Override
        public final Builder shareId(String shareId) {
            this.shareId = shareId;
            return this;
        }

        public final String getProfileArn() {
            return this.profileArn;
        }

        public final void setProfileArn(String profileArn) {
            this.profileArn = profileArn;
        }

        @Override
        public final Builder profileArn(String profileArn) {
            this.profileArn = profileArn;
            return this;
        }

        @Override
        public CreateProfileShareResponse build() {
            return new CreateProfileShareResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WellArchitectedResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateProfileShareResponse> {
        public Builder shareId(String var1);

        public Builder profileArn(String var1);
    }
}

